/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.Serializable;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.property.Duration;

public class BwDuration
implements Serializable {
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private int weeks;
    private boolean negative = false;

    public void setDays(int val) {
        this.days = val;
    }

    public int getDays() {
        return this.days;
    }

    public void setHours(int val) {
        this.hours = val;
    }

    public int getHours() {
        return this.hours;
    }

    public void setMinutes(int val) {
        this.minutes = val;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setSeconds(int val) {
        this.seconds = val;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setWeeks(int val) {
        this.weeks = val;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public void setNegative(boolean val) {
        this.negative = val;
    }

    public boolean getNegative() {
        return this.negative;
    }

    public static BwDuration makeDuration(String val) {
        BwDuration db = new BwDuration();
        BwDuration.populate(db, val);
        return db;
    }

    public static void populate(BwDuration db, String val) {
        try {
            if (val == null) {
                return;
            }
            Dur d = new Dur(val);
            if (d.getWeeks() != 0) {
                db.setWeeks(d.getWeeks());
                return;
            }
            db.setDays(d.getDays());
            db.setHours(d.getHours());
            db.setMinutes(d.getMinutes());
            db.setSeconds(d.getSeconds());
            db.setNegative(d.isNegative());
        }
        catch (Throwable t) {
            throw new RuntimeException("Invalid duration");
        }
    }

    public Duration makeDuration() {
        Dur d = this.weeks != 0 ? new Dur(this.getWeeks()) : new Dur(this.getDays(), this.getHours(), this.getMinutes(), this.getSeconds());
        return new Duration(d);
    }

    public boolean isZero() {
        if (this.getWeeks() != 0) {
            return false;
        }
        return this.getDays() == 0 && this.getHours() == 0 && this.getMinutes() == 0 && this.getSeconds() == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.negative) {
            sb.append("-");
        }
        sb.append("P");
        if (this.getWeeks() != 0) {
            sb.append(this.getWeeks());
            sb.append("W");
        } else {
            if (this.getDays() != 0) {
                sb.append(this.getDays());
                sb.append("D");
            }
            boolean addedT = this.addTimeComponent(sb, this.getHours(), "H", false);
            addedT = this.addTimeComponent(sb, this.getMinutes(), "M", addedT);
            this.addTimeComponent(sb, this.getSeconds(), "S", addedT);
        }
        return sb.toString();
    }

    private boolean addTimeComponent(StringBuffer sb, int val, String flag, boolean addedT) {
        if (val == 0) {
            return addedT;
        }
        if (!addedT) {
            sb.append("T");
            addedT = true;
        }
        sb.append(val);
        sb.append(flag);
        return addedT;
    }
}

