/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import net.fortuna.ical4j.model.property.LastModified;
import org.bedework.access.CurrentAccess;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwCollectionLastmod;
import org.bedework.calfacade.BwProperty;
import org.bedework.calfacade.CollectionInfo;
import org.bedework.calfacade.EventListEntry;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.NoWrap;
import org.bedework.calfacade.annotations.Wrapper;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.calfacade.annotations.ical.NoProxy;
import org.bedework.calfacade.base.BwShareableContainedDbentity;
import org.bedework.calfacade.base.CategorisedEntity;
import org.bedework.calfacade.base.CollatableEntity;
import org.bedework.calfacade.base.PropertiesEntity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.xml.FromXmlCallback;
import org.bedework.util.xml.tagdefs.AppleIcalTags;
import org.bedework.util.xml.tagdefs.AppleServerTags;
import org.bedework.util.xml.tagdefs.BedeworkServerTags;
import org.bedework.util.xml.tagdefs.CaldavTags;
import org.bedework.util.xml.tagdefs.NamespaceAbbrevs;
import org.bedework.util.xml.tagdefs.XcalTags;
import org.w3c.dom.Element;

@Wrapper(quotas=true)
@Dump(elementName="collection", keyFields={"path"})
@JsonIgnoreProperties(value={"aliasTarget", "aliasOrigin", "collectionInfo", "numProperties", "pwNeedsEncrypt", "tombstoned"})
public class BwCalendar
extends BwShareableContainedDbentity<BwCalendar>
implements CollatableEntity,
CategorisedEntity,
PropertiesEntity {
    public static final int minRefreshRateSeconds = 900;
    private String name;
    private String path;
    private String summary;
    private String description;
    private String mailListId;
    private int calType;
    public static final int calTypeUnknown = -1;
    public static final int calTypeFolder = 0;
    public static final int calTypeCalendarCollection = 1;
    public static final int calTypeTrash = 2;
    public static final int calTypeDeleted = 3;
    public static final int calTypeBusy = 4;
    public static final int calTypeInbox = 5;
    public static final int calTypeOutbox = 6;
    public static final int calTypeAlias = 7;
    public static final int calTypeExtSub = 8;
    public static final int calTypeResourceCollection = 9;
    public static final int calTypeNotifications = 10;
    public static final int calTypeEventList = 11;
    public static final int calTypePoll = 12;
    public static final int calTypePendingInbox = 13;
    public static final int calTypeAttachments = 14;
    public static final int calTypeTasks = 15;
    private static final boolean f = false;
    private static final boolean o = false;
    private static final boolean T = true;
    private static final CollectionInfo[] collectionInfo = new CollectionInfo[]{BwCalendar.ci(0, false, true, false, false, false, true, true, false, false, false, false), BwCalendar.ci(1, false, true, true, true, true, true, true, true, true, true, false), BwCalendar.ci(2, false, false, false, false, false, false, false, false, false, false, false), BwCalendar.ci(3, false, false, false, false, false, false, false, false, false, false, false), BwCalendar.ci(4, true, false, true, true, true, true, false, true, false, false, false), BwCalendar.ci(5, true, false, true, false, false, false, false, true, false, false, true), BwCalendar.ci(6, true, false, true, false, false, false, false, true, false, false, true), BwCalendar.ci(7, false, false, false, false, false, true, true, false, false, false, false), BwCalendar.ci(8, false, true, true, true, false, true, true, true, false, false, false), BwCalendar.ci(9, false, true, false, false, false, false, false, false, false, false, false), BwCalendar.ci(10, true, false, false, false, false, false, false, false, false, false, true), BwCalendar.ci(11, true, false, true, true, true, true, false, true, false, false, false), BwCalendar.ci(12, false, true, true, true, true, true, true, true, true, true, true), BwCalendar.ci(13, true, false, true, false, false, false, false, true, false, false, true), BwCalendar.ci(14, true, false, true, false, false, false, false, false, false, false, false), BwCalendar.ci(15, false, true, true, true, true, true, true, true, true, true, true)};
    private static final List<CollectionInfo> roCollectionInfo = List.of(collectionInfo);
    public static final Map<Integer, List<String>> entityTypes = Map.of(1, List.of("VEVENT"), 12, List.of("VPOLL"), 15, List.of("VTODO"));
    public static final String internalAliasUriPrefix = "bwcal://";
    private String created;
    private BwCollectionLastmod lastmod;
    private String filterExpr;
    public static final String tombstonedFilter = "--TOMBSTONED--";
    public static final String tombstonedSuffix = "(--TOMBSTONED--)";
    private Set<BwCategory> categories = null;
    private Set<BwProperty> properties;
    private String aliasUri;
    private boolean display = true;
    private boolean affectsFreeBusy;
    private boolean ignoreTransparency;
    private boolean unremoveable;
    private int refreshRate;
    private String lastRefresh;
    private String lastRefreshStatus;
    private String lastEtag;
    private String remoteId;
    private String remotePw;
    private BwCalendar aliasTarget;
    private BwCalendar aliasOrigin;
    private int aliasCalType;
    private boolean pwNeedsEncrypt;
    private List<String> supportedComponents;
    private Collection<BwCalendar> children;
    private List<String> vpollSupportedComponents;
    private Set<String> categoryHrefs;
    static final String subscriptionIdProperty = "org.bedework.subscriptionId";
    static final String eventListProperty = "org.bedework.eventlist";
    static final int maxEventListSize = 2500;
    private static FromXmlCallback fromXmlCb;

    public BwCalendar() {
        Date dt = new Date();
        this.setLastmod(new BwCollectionLastmod(this, dt));
        this.setCreated(DateTimeUtil.isoDateTimeUTC((Date)dt));
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    public void setPath(String val) {
        this.path = val;
        if (this.getLastmod() != null) {
            this.getLastmod().setPath(val);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setSummary(String val) {
        this.summary = val;
    }

    public String getSummary() {
        if (this.summary == null) {
            return this.getName();
        }
        return this.summary;
    }

    public void setDescription(String val) {
        this.description = val;
    }

    public String getDescription() {
        return this.description;
    }

    public void setMailListId(String val) {
        this.mailListId = val;
    }

    public String getMailListId() {
        return this.mailListId;
    }

    public void setCalType(int val) {
        this.calType = val;
    }

    public int getCalType() {
        return this.calType;
    }

    public void setCreated(String val) {
        this.created = val;
    }

    public String getCreated() {
        return this.created;
    }

    public void setLastmod(BwCollectionLastmod val) {
        this.lastmod = val;
    }

    @Dump(elementName="col-lastmod", compound=true)
    public BwCollectionLastmod getLastmod() {
        return this.lastmod;
    }

    public void setFilterExpr(String val) {
        this.filterExpr = val;
    }

    public String getFilterExpr() {
        return this.filterExpr;
    }

    public void setRefreshRate(int val) {
        this.refreshRate = val;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setLastRefresh(String val) {
        this.lastRefresh = val;
    }

    public String getLastRefresh() {
        return this.lastRefresh;
    }

    public void setLastRefreshStatus(String val) {
        this.lastRefreshStatus = val;
    }

    public String getLastRefreshStatus() {
        return this.lastRefreshStatus;
    }

    public void setLastEtag(String val) {
        this.lastEtag = val;
    }

    public String getLastEtag() {
        return this.lastEtag;
    }

    public void setRemoteId(String val) {
        this.remoteId = val;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemotePw(String val) {
        this.remotePw = val;
    }

    public String getRemotePw() {
        return this.remotePw;
    }

    @Override
    public void setCategories(Set<BwCategory> val) {
        this.categories = val;
    }

    @Override
    public Set<BwCategory> getCategories() {
        return this.categories;
    }

    @Override
    @NoDump
    public int getNumCategories() {
        Set<BwCategory> c = this.getCategories();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    public boolean addCategory(BwCategory val) {
        Set<BwCategory> cats = this.getCategories();
        if (cats == null) {
            cats = new TreeSet<BwCategory>();
            this.setCategories(cats);
        }
        if (!cats.contains(val)) {
            cats.add(val);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCategory(BwCategory val) {
        Set<BwCategory> cats = this.getCategories();
        if (cats == null) {
            return false;
        }
        return cats.remove(val);
    }

    @Override
    public boolean hasCategory(BwCategory val) {
        Set<BwCategory> cats = this.getCategories();
        if (cats == null) {
            return false;
        }
        return cats.contains(val);
    }

    @Override
    public Set<BwCategory> copyCategories() {
        if (this.getNumCategories() == 0) {
            return null;
        }
        return new TreeSet<BwCategory>(this.getCategories());
    }

    @Override
    public Set<BwCategory> cloneCategories() {
        if (this.getNumCategories() == 0) {
            return null;
        }
        TreeSet<BwCategory> ts = new TreeSet<BwCategory>();
        for (BwCategory cat : this.getCategories()) {
            ts.add((BwCategory)cat.clone());
        }
        return ts;
    }

    @NoWrap
    public void setAliasUri(String val) {
        this.aliasUri = val;
        if (val != null) {
            this.setCalType(7);
            if (this.getInternalAliasPath() == null) {
                this.setCalType(8);
            }
        }
    }

    public String getAliasUri() {
        return this.aliasUri;
    }

    public void setPwNeedsEncrypt(boolean val) {
        this.pwNeedsEncrypt = val;
    }

    @NoDump
    public boolean getPwNeedsEncrypt() {
        return this.pwNeedsEncrypt;
    }

    public void setDisplay(boolean val) {
        this.display = val;
    }

    public boolean getDisplay() {
        return this.display;
    }

    public void setAffectsFreeBusy(boolean val) {
        this.affectsFreeBusy = val;
    }

    public boolean getAffectsFreeBusy() {
        return this.affectsFreeBusy;
    }

    public void setIgnoreTransparency(boolean val) {
        this.ignoreTransparency = val;
    }

    public boolean getIgnoreTransparency() {
        return this.ignoreTransparency;
    }

    public void setUnremoveable(boolean val) {
        this.unremoveable = val;
    }

    public boolean getUnremoveable() {
        return this.unremoveable;
    }

    @Override
    public void setProperties(Set<BwProperty> val) {
        this.properties = val;
    }

    @Override
    @Dump(collectionElementName="property", compound=true)
    public Set<BwProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Set<BwProperty> getProperties(String name) {
        TreeSet<BwProperty> ps = new TreeSet<BwProperty>();
        if (this.getNumProperties() == 0) {
            return null;
        }
        for (BwProperty p : this.getProperties()) {
            if (!p.getName().equals(name)) continue;
            ps.add(p);
        }
        return ps;
    }

    @Override
    public void removeProperties(String name) {
        Set<BwProperty> ps = this.getProperties(name);
        if (ps == null) {
            return;
        }
        for (BwProperty p : ps) {
            this.removeProperty(p);
        }
    }

    @Override
    @NoDump
    public int getNumProperties() {
        Set<BwProperty> c = this.getProperties();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    public BwProperty findProperty(String name) {
        Set<BwProperty> props = this.getProperties();
        if (props == null) {
            return null;
        }
        for (BwProperty prop : props) {
            if (!name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    @Override
    public void addProperty(BwProperty val) {
        Set<BwProperty> c = this.getProperties();
        if (c == null) {
            c = new TreeSet<BwProperty>();
            this.setProperties(c);
        }
        c.add(val);
    }

    @Override
    public boolean removeProperty(BwProperty val) {
        Set<BwProperty> c = this.getProperties();
        if (c == null) {
            return false;
        }
        return c.remove(val);
    }

    @Override
    public Set<BwProperty> copyProperties() {
        if (this.getNumProperties() == 0) {
            return null;
        }
        return new TreeSet<BwProperty>(this.getProperties());
    }

    @Override
    public Set<BwProperty> cloneProperties() {
        if (this.getNumProperties() == 0) {
            return null;
        }
        TreeSet<BwProperty> ts = new TreeSet<BwProperty>();
        for (BwProperty p : this.getProperties()) {
            ts.add((BwProperty)p.clone());
        }
        return ts;
    }

    public void setSupportedComponents(List<String> val) {
        this.supportedComponents = val;
        if (Util.isEmpty(val)) {
            this.removeQproperty(CaldavTags.supportedCalendarComponentSet);
            return;
        }
        this.setQproperty(CaldavTags.supportedCalendarComponentSet, String.join((CharSequence)",", val));
    }

    @NoDump
    public List<String> getSupportedComponents() {
        if (this.supportedComponents == null) {
            this.supportedComponents = new ArrayList<String>();
            int ctype = this.getCalType();
            if (ctype == 12) {
                this.supportedComponents.add("VPOLL");
                return this.supportedComponents;
            }
            if (ctype == 15) {
                this.supportedComponents.add("VTODO");
                return this.supportedComponents;
            }
            if (ctype == 5) {
                this.supportedComponents.add("VPOLL");
                this.supportedComponents.add("VEVENT");
                this.supportedComponents.add("VTODO");
                this.supportedComponents.add("VAVAILABILITY");
                return this.supportedComponents;
            }
            if (ctype != 1 && ctype != 6 && ctype != 8) {
                return this.supportedComponents;
            }
            String slist = this.getQproperty(CaldavTags.supportedCalendarComponentSet);
            if (slist == null) {
                this.supportedComponents.add("VEVENT");
            } else {
                String[] ss = slist.split(",");
                this.supportedComponents.addAll(Arrays.asList(ss));
            }
        }
        return this.supportedComponents;
    }

    @NoDump
    public List<String> getVpollSupportedComponents() {
        if (this.vpollSupportedComponents == null) {
            this.vpollSupportedComponents = new ArrayList<String>();
            if (this.getCalType() != 12 && this.getCalType() != 5 && this.getCalType() != 6) {
                return this.vpollSupportedComponents;
            }
            String slist = this.getQproperty(CaldavTags.vpollSupportedComponentSet);
            if (slist == null) {
                this.vpollSupportedComponents.add("VEVENT");
            } else {
                String[] ss = slist.split(",");
                this.vpollSupportedComponents.addAll(Arrays.asList(ss));
            }
        }
        return this.vpollSupportedComponents;
    }

    public void setColor(String val) {
        if (Util.checkNull((String)val) == null) {
            BwProperty p = this.findProperty(AppleIcalTags.calendarColor.getLocalPart());
            if (p != null) {
                this.removeProperty(p);
            }
        } else {
            this.setProperty(AppleIcalTags.calendarColor.getLocalPart(), val);
        }
    }

    @NoDump
    public String getColor() {
        return this.getProperty(AppleIcalTags.calendarColor.getLocalPart());
    }

    public void setSubscriptionId(String val) {
        if (Util.checkNull((String)val) == null) {
            BwProperty p = this.findProperty(subscriptionIdProperty);
            if (p != null) {
                this.removeProperty(p);
            }
        } else {
            this.setProperty(subscriptionIdProperty, val);
        }
    }

    @NoDump
    public String getSubscriptionId() {
        return this.getProperty(subscriptionIdProperty);
    }

    public void setSynchAdminCreateEprops(boolean val) {
        this.setProperty(BedeworkServerTags.synchAdminCreateEpropsProperty.getLocalPart(), String.valueOf(val));
    }

    @NoDump
    public boolean getSynchAdminCreateEprops() {
        return Boolean.parseBoolean(this.getProperty(BedeworkServerTags.synchAdminCreateEpropsProperty.getLocalPart()));
    }

    public void setSynchXlocXcontacts(boolean val) {
        this.setProperty(BedeworkServerTags.synchXlocXcontacts.getLocalPart(), String.valueOf(val));
    }

    @NoDump
    public boolean getSynchXlocXcontacts() {
        return Boolean.parseBoolean(this.getProperty(BedeworkServerTags.synchXlocXcontacts.getLocalPart()));
    }

    public void setSynchXcategories(boolean val) {
        this.setProperty(BedeworkServerTags.synchXcategories.getLocalPart(), String.valueOf(val));
    }

    @NoDump
    public boolean getSynchXcategories() {
        return Boolean.parseBoolean(this.getProperty(BedeworkServerTags.synchXcategories.getLocalPart()));
    }

    public void setSynchDeleteSuppressed(boolean val) {
        this.setProperty(BedeworkServerTags.synchDeleteSuppressed.getLocalPart(), String.valueOf(val));
    }

    @NoDump
    public boolean getSynchDeleteSuppressed() {
        return Boolean.parseBoolean(this.getProperty(BedeworkServerTags.synchDeleteSuppressed.getLocalPart()));
    }

    public void setTimezone(String val) {
        if (val == null) {
            BwProperty p = this.findProperty(CaldavTags.calendarTimezone.getLocalPart());
            if (p != null) {
                this.removeProperty(p);
            }
        } else {
            this.setProperty(CaldavTags.calendarTimezone.getLocalPart(), val);
        }
    }

    @NoDump
    public String getTimezone() {
        return this.getProperty(CaldavTags.calendarTimezone.getLocalPart());
    }

    public void setSubscriptionTargetType(String val) {
        if (val == null) {
            String p = this.getQproperty(BedeworkServerTags.subscriptionTargetType);
            if (p != null) {
                this.removeQproperty(BedeworkServerTags.subscriptionTargetType);
            }
        } else {
            this.setQproperty(BedeworkServerTags.subscriptionTargetType, val);
        }
    }

    @NoDump
    public String getSubscriptionTargetType() {
        return this.getQproperty(BedeworkServerTags.subscriptionTargetType);
    }

    public void setLocationKey(String val) {
        if (val == null) {
            String p = this.getQproperty(XcalTags.xBedeworkLocationKey);
            if (p != null) {
                this.removeQproperty(XcalTags.xBedeworkLocationKey);
            }
        } else {
            this.setQproperty(XcalTags.xBedeworkLocationKey, val);
        }
    }

    @NoDump
    public String getLocationKey() {
        return this.getQproperty(XcalTags.xBedeworkLocationKey);
    }

    public void setOrgSyncPublicOnly(Boolean val) {
        if (val == null) {
            String p = this.getQproperty(BedeworkServerTags.orgSyncPublicOnly);
            if (p != null) {
                this.removeQproperty(BedeworkServerTags.orgSyncPublicOnly);
            }
        } else {
            this.setQproperty(BedeworkServerTags.orgSyncPublicOnly, String.valueOf(val));
        }
    }

    @NoDump
    public boolean getOrgSyncPublicOnly() {
        return Boolean.parseBoolean(this.getQproperty(BedeworkServerTags.orgSyncPublicOnly));
    }

    public void setIsTopicalArea(boolean val) {
        this.setProperty(BedeworkServerTags.isTopicalArea.getLocalPart(), String.valueOf(val));
    }

    @NoDump
    public boolean getIsTopicalArea() {
        return Boolean.parseBoolean(this.getProperty(BedeworkServerTags.isTopicalArea.getLocalPart()));
    }

    public void setQproperty(QName name, String val) {
        this.setProperty(NamespaceAbbrevs.prefixed((QName)name), val);
    }

    public String getQproperty(QName name) {
        return this.getProperty(NamespaceAbbrevs.prefixed((QName)name));
    }

    public void removeQproperty(QName name) {
        BwProperty p = this.findProperty(NamespaceAbbrevs.prefixed((QName)name));
        if (p != null) {
            this.removeProperty(p);
        }
    }

    public void setEventList(SortedSet<EventListEntry> val) {
        Object currentPath = null;
        ArrayList<String> vals = new ArrayList<String>();
        StringBuilder cur = new StringBuilder();
        for (EventListEntry ele : val) {
            String p = ele.getPath() + "/";
            if (cur.length() > 0) {
                cur.append("\t");
            }
            if (currentPath == null || !((String)currentPath).equals(p)) {
                cur.append(ele.getHref());
                currentPath = p;
            } else {
                cur.append(ele.getName());
            }
            if (cur.length() < 2500) continue;
            vals.add(cur.toString());
            currentPath = null;
            cur = new StringBuilder();
        }
        if (cur.length() > 0) {
            vals.add(cur.toString());
        }
        Set<BwProperty> bwprops = this.getProperties(eventListProperty);
        ArrayList<BwProperty> props = new ArrayList<BwProperty>();
        if (bwprops != null) {
            props.addAll(bwprops);
        }
        for (int i = 0; i < Math.max(vals.size(), props.size()); ++i) {
            String s = null;
            if (i < vals.size()) {
                s = (String)vals.get(i);
            }
            if (s == null) {
                this.removeProperty((BwProperty)props.get(i));
                continue;
            }
            if (i >= props.size()) {
                this.addProperty(new BwProperty(eventListProperty, s));
                continue;
            }
            BwProperty p = (BwProperty)props.get(i);
            p.setValue(s);
        }
    }

    @NoDump
    public SortedSet<EventListEntry> getEventList() {
        Set<BwProperty> props = this.getProperties(eventListProperty);
        TreeSet<EventListEntry> res = new TreeSet<EventListEntry>();
        if (props == null) {
            return res;
        }
        for (BwProperty prop : props) {
            String[] vals = prop.getValue().split("\t");
            String curPath = null;
            for (String s : vals) {
                if (s.startsWith("/")) {
                    EventListEntry ele = new EventListEntry(s);
                    curPath = ele.getPath();
                    res.add(ele);
                    continue;
                }
                res.add(new EventListEntry(curPath + s));
            }
        }
        return res;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.HREF, jname="href", required=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setHref(String val) {
        this.setPath(val);
    }

    @Override
    public String getHref() {
        return this.getPath();
    }

    @NoDump
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CTAG, jname="ctag")
    public String getEtag() {
        return "\"" + this.getLastmod().getTagValue() + "\"";
    }

    @NoDump
    @JsonIgnore
    public long getMicrosecsVersion() throws CalFacadeException {
        try {
            BwCollectionLastmod lm = this.getLastmod();
            long micros = new LastModified(lm.getTimestamp()).getDate().getTime();
            int seq = lm.getSequence();
            return micros * 1000000L + (long)seq;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    @NoDump
    public boolean getCalendarCollection() {
        return BwCalendar.collectionInfo[this.getCalType()].onlyCalEntities;
    }

    @NoDump
    public boolean getSpecial() {
        return BwCalendar.collectionInfo[this.getCalType()].special;
    }

    @NoDump
    public boolean getCanAlias() {
        return BwCalendar.collectionInfo[this.getCalType()].canAlias;
    }

    public void setAliasTarget(BwCalendar val) {
        this.aliasTarget = val;
    }

    @NoDump
    public BwCalendar getAliasTarget() {
        return this.aliasTarget;
    }

    public void setAliasOrigin(BwCalendar val) {
        this.aliasOrigin = val;
    }

    @NoDump
    public BwCalendar getAliasOrigin() {
        return this.aliasOrigin;
    }

    public void setAliasCalType(int val) {
        this.aliasCalType = val;
    }

    @NoDump
    public int getAliasCalType() {
        return this.aliasCalType;
    }

    public void setDisabled(boolean val) {
        throw new RuntimeException("org.bedework.wrapper.method.called");
    }

    @NoDump
    public boolean getDisabled() {
        return false;
    }

    @NoProxy
    @NoDump
    @JsonIgnore
    public BwCalendar getAliasedEntity() {
        BwCalendar coll;
        for (coll = this; coll != null && coll.getInternalAlias(); coll = coll.getAliasTarget()) {
        }
        return coll;
    }

    @NoProxy
    @NoDump
    public boolean getAlias() {
        return this.getInternalAlias() || this.getExternalSub();
    }

    @NoProxy
    @NoDump
    @NoWrap
    public boolean getInternalAlias() {
        return this.getCalType() == 7;
    }

    @NoProxy
    @NoDump
    @NoWrap
    public boolean getExternalSub() {
        return this.getCalType() == 8;
    }

    @NoProxy
    @NoDump
    public String getInternalAliasPath() {
        if (!this.getInternalAlias()) {
            return null;
        }
        String uri = this.getAliasUri();
        if (uri == null) {
            return null;
        }
        if (uri.startsWith(internalAliasUriPrefix)) {
            return uri.substring(internalAliasUriPrefix.length());
        }
        return null;
    }

    public void setChildren(Collection<BwCalendar> val) {
        this.children = val;
    }

    @NoProxy
    @NoDump
    public Collection<BwCalendar> getChildren() {
        return this.children;
    }

    @Override
    @NoProxy
    @NoWrap
    @NoDump
    public void setCategoryHrefs(Set<String> val) {
        this.categoryHrefs = val;
    }

    @Override
    @NoProxy
    @NoWrap
    @NoDump
    public Set<String> getCategoryHrefs() {
        return this.categoryHrefs;
    }

    @NoDump
    public CollectionInfo getCollectionInfo() {
        return this.getCollectionInfo(this.getCalType());
    }

    @NoDump
    @NoWrap
    public CollectionInfo getCollectionInfo(int type) {
        return collectionInfo[type];
    }

    @NoDump
    @NoWrap
    public static List<CollectionInfo> getAllCollectionInfo() {
        return roCollectionInfo;
    }

    public void tombstone() {
        if (this.getTombstoned()) {
            return;
        }
        this.setFilterExpr(tombstonedFilter);
    }

    @NoProxy
    @NoDump
    @NoWrap
    public boolean getShared() {
        return Boolean.parseBoolean(this.getQproperty(AppleServerTags.shared));
    }

    @NoProxy
    @NoDump
    @NoWrap
    public void setShared(boolean val) {
        if (val) {
            this.setQproperty(AppleServerTags.shared, "true");
        } else {
            this.removeQproperty(AppleServerTags.shared);
        }
    }

    @NoProxy
    @NoDump
    @NoWrap
    public boolean getSharedWritable() {
        return Boolean.parseBoolean(this.getQproperty(AppleServerTags.readWrite));
    }

    @NoProxy
    @NoDump
    @NoWrap
    public void setSharedWritable(boolean val) {
        if (val) {
            this.setQproperty(AppleServerTags.readWrite, "true");
        } else {
            this.removeQproperty(AppleServerTags.readWrite);
        }
    }

    @NoProxy
    @NoDump
    @NoWrap
    public boolean getTombstoned() {
        String f = this.getFilterExpr();
        return f != null && f.equals(tombstonedFilter);
    }

    public static boolean checkName(String val) {
        if (val == null || val.length() == 0) {
            return false;
        }
        if (!Character.isLetterOrDigit(val.charAt(0))) {
            return false;
        }
        for (int i = 1; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == ' ') continue;
            return false;
        }
        return true;
    }

    @NoDump
    public String getEncodedPath() {
        if (this.getPath() == null) {
            return null;
        }
        try {
            return URLEncoder.encode(this.getPath(), StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void updateLastmod(Timestamp val) {
        this.getLastmod().updateLastmod(val);
    }

    public void setProperty(String name, String val) {
        BwProperty prop = this.findProperty(name);
        if (prop == null) {
            if (val != null) {
                prop = new BwProperty(name, val);
                this.addProperty(prop);
            }
        } else if (val == null) {
            this.removeProperty(prop);
        } else {
            prop.setValue(val);
        }
    }

    public String getProperty(String name) {
        BwProperty prop = this.findProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public void setCurrentAccess(CurrentAccess val) {
        throw new RuntimeException("org.bedework.wrapper.method.called");
    }

    @NoDump
    @JsonIgnore
    public CurrentAccess getCurrentAccess() {
        throw new RuntimeException("org.bedework.wrapper.method.called");
    }

    public void setVirtualPath(String val) {
        throw new RuntimeException("org.bedework.wrapper.method.called");
    }

    @NoDump
    public String getVirtualPath() {
        return null;
    }

    public void setOpen(boolean val) {
    }

    @NoDump
    public boolean getOpen() {
        return false;
    }

    @Override
    @NoDump
    public String getCollateValue() {
        return this.getName();
    }

    public BwCalendar makeTombstoneCopy() {
        BwCalendar col = new BwCalendar();
        super.copyTo(col);
        col.setName(this.getName());
        col.setPath(this.getPath());
        col.setCalType(this.getCalType());
        col.setCreated(this.getCreated());
        col.setLastmod((BwCollectionLastmod)this.getLastmod().clone());
        col.setAliasUri(this.getAliasUri());
        return col;
    }

    @NoDump
    public static FromXmlCallback getRestoreCallback() {
        if (fromXmlCb == null) {
            fromXmlCb = new FromXmlCallback(){

                public boolean save(Element el, Object theObject, Object theValue) {
                    if ("col-lastmod".equals(el.getTagName())) {
                        ((BwCalendar)theObject).setLastmod((BwCollectionLastmod)theValue);
                        return true;
                    }
                    return false;
                }
            };
            fromXmlCb.addClassForName("col-lastmod", BwCollectionLastmod.class);
            fromXmlCb.addClassForName("property", BwProperty.class);
            fromXmlCb.addSkips(new String[]{"byteSize", "id", "seq"});
            fromXmlCb.addMapField("col-lastmod", "lastmod");
            fromXmlCb.addMapField("public", "publick");
        }
        return fromXmlCb;
    }

    @Override
    public int compareTo(BwCalendar that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        return this.getPath().compareTo(that.getPath());
    }

    @Override
    public int hashCode() {
        if (this.getPath() == null) {
            return 1;
        }
        return this.getPath().hashCode();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("name", (Object)this.getName());
        ts.append("path", (Object)this.getPath());
        ts.append("tombstoned", this.getTombstoned());
        ts.append("displayName", (Object)this.getSummary());
        ts.newLine();
        ts.append("description", (Object)this.getDescription());
        ts.append("calendarCollection", this.getCalendarCollection());
        ts.append("calType", this.getCalType());
        ts.append("created", (Object)this.getCreated());
        ts.append("lastmod", (Object)this.getLastmod());
        if (this.getNumCategories() > 0) {
            ts.append("categories", this.getCategories());
        }
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwCalendar cal = this.shallowClone();
        cal.setCategories(this.cloneCategories());
        cal.setProperties(this.cloneProperties());
        return cal;
    }

    public BwCalendar cloneWrapper() {
        throw new RuntimeException("org.bedework.wrapper.method.called");
    }

    public BwCalendar shallowClone() {
        BwCalendar cal = new BwCalendar();
        super.copyTo(cal);
        cal.setName(this.getName());
        cal.setPath(this.getPath());
        cal.setSummary(this.getSummary());
        cal.setDescription(this.getDescription());
        cal.setMailListId(this.getMailListId());
        cal.setCalType(this.getCalType());
        cal.setCreated(this.getCreated());
        BwCollectionLastmod lm = (BwCollectionLastmod)this.getLastmod().clone();
        lm.setDbEntity(cal);
        cal.setLastmod(lm);
        cal.setAliasUri(this.getAliasUri());
        cal.setDisplay(this.getDisplay());
        cal.setAffectsFreeBusy(this.getAffectsFreeBusy());
        cal.setIgnoreTransparency(this.getIgnoreTransparency());
        cal.setUnremoveable(this.getUnremoveable());
        cal.setRefreshRate(this.getRefreshRate());
        cal.setLastRefresh(this.getLastRefresh());
        cal.setLastEtag(this.getLastEtag());
        cal.setFilterExpr(this.getFilterExpr());
        if (!Util.isEmpty(this.getCategoryHrefs())) {
            TreeSet<String> uids = new TreeSet<String>(this.getCategoryHrefs());
            cal.setCategoryHrefs(uids);
        }
        return cal;
    }

    private static CollectionInfo ci(int collectionType, boolean special, boolean childrenAllowed, boolean indexable, boolean uniqueKey, boolean allowAnnotations, boolean allowFreeBusy, boolean canAlias, boolean onlyCalEntities, boolean scheduling, boolean shareable, boolean provision) {
        return new CollectionInfo(collectionType, special, childrenAllowed, indexable, uniqueKey, allowAnnotations, allowFreeBusy, canAlias, onlyCalEntities, scheduling, shareable, provision);
    }
}

