/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import org.bedework.calfacade.base.BwCloneable;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.base.Differable;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class BwAttendee
extends BwDbentity<BwAttendee>
implements BwCloneable,
Differable<BwAttendee> {
    public static final int typeAttendee = 0;
    public static final int typeVoter = 1;
    private String cn;
    private String cuType;
    private String delegatedFrom;
    private String delegatedTo;
    private String dir;
    private String language;
    private String member;
    private String sentBy;
    private boolean rsvp;
    private String role;
    private String partstat = "NEEDS-ACTION";
    private String attendeeUri;
    private int sequence;
    private String dtstamp;
    private int scheduleAgent;
    private String scheduleStatus;

    public void setType(int val) {
        String sb = this.getSentByVal();
        if (val == 0) {
            if (sb == null) {
                return;
            }
            if (!sb.startsWith(":")) {
                return;
            }
            String sbpart = sb.substring(sb.indexOf(":", 2));
            if (sbpart.length() == 0) {
                this.setSentByVal(null);
            } else {
                this.setSentByVal(sbpart);
            }
            return;
        }
        if (sb == null) {
            this.setSentByVal(":F0:");
            return;
        }
        if (!sb.startsWith(":")) {
            this.setSentByVal(":F0:" + sb);
        }
    }

    public int getType() {
        String sb = this.getSentByVal();
        if (sb == null || !sb.startsWith(":")) {
            return 0;
        }
        return 1;
    }

    public void setCn(String val) {
        this.cn = val;
    }

    public String getCn() {
        return this.cn;
    }

    public void setCuType(String val) {
        this.cuType = val;
    }

    public String getCuType() {
        return this.cuType;
    }

    public void setDelegatedFrom(String val) {
        this.delegatedFrom = val;
    }

    public String getDelegatedFrom() {
        return this.delegatedFrom;
    }

    public void setDelegatedTo(String val) {
        this.delegatedTo = val;
    }

    public String getDelegatedTo() {
        return this.delegatedTo;
    }

    public void setDir(String val) {
        this.dir = val;
    }

    public String getDir() {
        return this.dir;
    }

    public void setLanguage(String val) {
        this.language = val;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setMember(String val) {
        this.member = val;
    }

    public String getMember() {
        return this.member;
    }

    public void setRsvp(boolean val) {
        this.rsvp = val;
    }

    public boolean getRsvp() {
        return this.rsvp;
    }

    public void setRole(String val) {
        this.role = val;
    }

    public String getRole() {
        return this.role;
    }

    public void setPartstat(String val) {
        this.partstat = val;
    }

    public String getPartstat() {
        return this.partstat;
    }

    public void setSentBy(String val) {
        String sb = this.getSentByVal();
        if (sb == null || !sb.startsWith(":")) {
            this.setSentByVal(val);
            return;
        }
        String sbpart = val == null ? "" : val;
        this.setSentByVal(sb.substring(0, sb.indexOf(":", 2) + 1) + sbpart);
    }

    public String getSentBy() {
        String sb = this.getSentByVal();
        if (sb == null || !sb.startsWith(":")) {
            return sb;
        }
        String sbpart = sb.substring(sb.indexOf(":", 2) + 1);
        if (sbpart.length() == 0) {
            return null;
        }
        return sbpart;
    }

    public void setSentByVal(String val) {
        this.sentBy = val;
    }

    public String getSentByVal() {
        return this.sentBy;
    }

    public void setAttendeeUri(String val) {
        this.attendeeUri = val;
    }

    public String getAttendeeUri() {
        return this.attendeeUri;
    }

    public void setSequence(int val) {
        this.sequence = val;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setDtstamp(String val) {
        this.dtstamp = val;
    }

    public String getDtstamp() {
        return this.dtstamp;
    }

    public void setScheduleAgent(int val) {
        this.scheduleAgent = val;
    }

    public int getScheduleAgent() {
        return this.scheduleAgent;
    }

    public void setScheduleStatus(String val) {
        this.scheduleStatus = val;
    }

    public String getScheduleStatus() {
        return this.scheduleStatus;
    }

    public void setResponse(int val) {
        String sb = this.getSentByVal();
        if (sb == null) {
            this.setSentByVal(":F" + val + ":");
            return;
        }
        String sbpart = sb.substring(sb.indexOf(":", 2) + 1);
        String sipart = sb.substring(1, 2);
        this.setSentByVal(":" + sipart + val + ":" + sbpart);
    }

    public int getResponse() {
        String sb = this.getSentByVal();
        if (sb == null || !sb.startsWith(":")) {
            return 0;
        }
        return Integer.parseInt(sb.substring(2, sb.indexOf(":", 2)));
    }

    public void setStayInformed(boolean val) {
        String sb = this.getSentByVal();
        String sival = val ? "T" : "F";
        if (sb == null) {
            this.setSentByVal(":" + sival + "0:");
            return;
        }
        this.setSentByVal(":" + sival + sb.substring(2));
    }

    public boolean getStayInformed() {
        String sb = this.getSentByVal();
        if (sb == null || !sb.startsWith(":")) {
            return false;
        }
        return sb.charAt(1) == 'T';
    }

    public void copyTo(BwAttendee val) {
        val.setCn(this.getCn());
        val.setCuType(this.getCuType());
        val.setDelegatedFrom(this.getDelegatedFrom());
        val.setDelegatedTo(this.getDelegatedTo());
        val.setDir(this.getDir());
        val.setLanguage(this.getLanguage());
        val.setMember(this.getMember());
        val.setRsvp(this.getRsvp());
        val.setRole(this.getRole());
        val.setPartstat(this.getPartstat());
        val.setSentByVal(this.getSentByVal());
        val.setAttendeeUri(this.getAttendeeUri());
        val.setSequence(this.getSequence());
        val.setScheduleAgent(this.getScheduleAgent());
        val.setScheduleStatus(this.getScheduleStatus());
        val.setDtstamp(this.getDtstamp());
    }

    public boolean changedBy(BwAttendee val) {
        return this.changedBy(val, true);
    }

    public boolean changedBy(BwAttendee val, boolean checkPartStat) {
        return checkPartStat && Util.compareStrings((String)val.getPartstat(), (String)this.getPartstat()) != 0 || Util.compareStrings((String)val.getCn(), (String)this.getCn()) != 0 || Util.compareStrings((String)val.getCuType(), (String)this.getCuType()) != 0 || Util.compareStrings((String)val.getDelegatedFrom(), (String)this.getDelegatedFrom()) != 0 || Util.compareStrings((String)val.getDelegatedTo(), (String)this.getDelegatedTo()) != 0 || Util.compareStrings((String)val.getDir(), (String)this.getDir()) != 0 || Util.compareStrings((String)val.getLanguage(), (String)this.getLanguage()) != 0 || Util.compareStrings((String)val.getMember(), (String)this.getMember()) != 0 || Util.compareStrings((String)val.getRole(), (String)this.getRole()) != 0 || Util.compareStrings((String)val.getSentByVal(), (String)this.getSentByVal()) != 0 || Util.compareStrings((String)val.getAttendeeUri(), (String)this.getAttendeeUri()) != 0;
    }

    @Override
    public boolean differsFrom(BwAttendee val) {
        return Util.compareStrings((String)val.getPartstat(), (String)this.getPartstat()) != 0 || Util.compareStrings((String)val.getCn(), (String)this.getCn()) != 0 || Util.compareStrings((String)val.getCuType(), (String)this.getCuType()) != 0 || Util.compareStrings((String)val.getDelegatedFrom(), (String)this.getDelegatedFrom()) != 0 || Util.compareStrings((String)val.getDelegatedTo(), (String)this.getDelegatedTo()) != 0 || Util.compareStrings((String)val.getDir(), (String)this.getDir()) != 0 || Util.compareStrings((String)val.getLanguage(), (String)this.getLanguage()) != 0 || Util.compareStrings((String)val.getMember(), (String)this.getMember()) != 0 || Util.cmpBoolval((boolean)val.getRsvp(), (boolean)this.getRsvp()) != 0 || Util.compareStrings((String)val.getRole(), (String)this.getRole()) != 0 || Util.compareStrings((String)val.getSentByVal(), (String)this.getSentByVal()) != 0 || Util.compareStrings((String)val.getAttendeeUri(), (String)this.getAttendeeUri()) != 0 || Util.cmpIntval((int)val.getScheduleAgent(), (int)this.getScheduleAgent()) != 0;
    }

    @Override
    public int hashCode() {
        return this.getAttendeeUri().hashCode();
    }

    @Override
    public int compareTo(BwAttendee that) {
        if (this == that) {
            return 0;
        }
        return this.getAttendeeUri().compareTo(that.getAttendeeUri());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("type", this.getType());
        ts.append("cn", (Object)this.getCn());
        ts.append("cuType", (Object)this.getCuType());
        ts.append("delegatedFrom", (Object)this.getDelegatedFrom());
        ts.append("delegatedTo", (Object)this.getDelegatedTo());
        ts.newLine();
        ts.append("dir", (Object)this.getDir());
        ts.append("language", (Object)this.getLanguage());
        ts.append("member", (Object)this.getMember());
        ts.append("rsvp", this.getRsvp());
        ts.newLine();
        ts.append("role", (Object)this.getRole());
        ts.append("partstat", (Object)this.getPartstat());
        ts.append("sentBy", (Object)this.getSentBy());
        ts.append("attendeeUri", (Object)this.getAttendeeUri());
        ts.newLine();
        ts.append("sequence", this.getSequence());
        ts.append("dtstamp", (Object)this.getDtstamp());
        ts.newLine();
        ts.append("scheduleAgent", this.getScheduleAgent());
        ts.append("scheduleStatus", (Object)this.getScheduleStatus());
        if (this.getType() == 1) {
            ts.newLine();
            ts.append("response", this.getResponse());
            ts.append("stayInformed", this.getStayInformed());
        }
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwAttendee nobj = new BwAttendee();
        this.copyTo(nobj);
        return nobj;
    }
}

