/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.Serializable;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.fortuna.ical4j.model.TemporalAmountAdapter;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Trigger;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.ical.IcalProperties;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.calfacade.annotations.ical.NoProxy;
import org.bedework.calfacade.base.AttendeesEntity;
import org.bedework.calfacade.base.BwOwnedDbentity;
import org.bedework.calfacade.base.DescriptionEntity;
import org.bedework.calfacade.base.Differable;
import org.bedework.calfacade.base.SummaryEntity;
import org.bedework.calfacade.base.XpropsEntity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.BwDateTimeUtil;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;

@Dump(elementName="alarm", keyFields={"event"})
public class BwAlarm
extends BwOwnedDbentity<BwAlarm>
implements AttendeesEntity,
DescriptionEntity<BwString>,
SummaryEntity,
Differable<BwAlarm>,
XpropsEntity,
Serializable {
    public static final int alarmTypeAudio = 0;
    public static final int alarmTypeDisplay = 1;
    public static final int alarmTypeEmail = 2;
    public static final int alarmTypeProcedure = 3;
    public static final int alarmTypeNone = 4;
    public static final int alarmTypeOther = 5;
    public static final String[] alarmTypes = new String[]{"AUDIO", "DISPLAY", "EMAIL", "PROCEDURE", "NONE", "OTHER"};
    protected int alarmType;
    protected String trigger;
    protected boolean triggerStart;
    protected boolean triggerDateTime;
    protected String duration;
    protected int repeat;
    protected int repeatCount;
    protected boolean expired;
    protected String attach;
    private Set<BwString> summaries;
    private Set<BwString> descriptions;
    protected Set<BwAttendee> attendees;
    private List<BwXproperty> xproperties;
    protected Date triggerDate;

    public BwAlarm() {
    }

    private BwAlarm(String owner, int alarmType, TriggerVal trigger, String duration, int repeat, int repeatCount, boolean expired, String attach, String description, String summary, Set<BwAttendee> attendees) {
        this.setOwnerHref(owner);
        this.setPublick(false);
        this.alarmType = alarmType;
        this.trigger = trigger.trigger;
        this.triggerStart = trigger.triggerStart;
        this.triggerDateTime = trigger.triggerDateTime;
        this.duration = duration;
        this.repeat = repeat;
        this.repeatCount = repeatCount;
        this.expired = expired;
        this.attach = attach;
        this.addDescription(new BwString(null, description));
        this.addSummary(new BwString(null, summary));
        this.setAttendees(attendees);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ACTION, alarmProperty=true)
    public void setAlarmType(int val) {
        this.alarmType = val;
    }

    public int getAlarmType() {
        return this.alarmType;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.TRIGGER, alarmProperty=true)
    public void setTrigger(String val) {
        this.trigger = val;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTriggerStart(boolean val) {
        this.triggerStart = val;
    }

    public boolean getTriggerStart() {
        return this.triggerStart;
    }

    public void setTriggerDateTime(boolean val) {
        this.triggerDateTime = val;
    }

    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.TRIGGER_DATE_TIME, jname="triggerDateTime", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.NEXT_TRIGGER_DATE_TIME, jname="nextTrigger", alarmProperty=true)})
    public boolean getTriggerDateTime() {
        return this.triggerDateTime;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DURATION, alarmProperty=true)
    public void setDuration(String val) {
        this.duration = val;
    }

    public String getDuration() {
        return this.duration;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.REPEAT, alarmProperty=true)
    public void setRepeat(int val) {
        this.repeat = val;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeatCount(int val) {
        this.repeatCount = val;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setExpired(boolean val) {
        this.expired = val;
    }

    public boolean getExpired() {
        return this.expired;
    }

    public void setAttach(String val) {
        this.attach = val;
    }

    public String getAttach() {
        return this.attach;
    }

    @NoDump
    public int getEntityType() {
        return 1;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ATTENDEE, jname="attendee", adderName="attendee", alarmProperty=true)
    public void setAttendees(Set<BwAttendee> val) {
        this.attendees = val;
    }

    @Override
    @Dump(collectionElementName="attendee", compound=true)
    public Set<BwAttendee> getAttendees() {
        return this.attendees;
    }

    @Override
    @NoDump
    public int getNumAttendees() {
        Set<BwAttendee> as = this.getAttendees();
        if (as == null) {
            return 0;
        }
        return as.size();
    }

    @Override
    public void addAttendee(BwAttendee val) {
        Set<BwAttendee> as = this.getAttendees();
        if (as == null) {
            as = new TreeSet<BwAttendee>();
            this.setAttendees(as);
        }
        as.add(val);
    }

    @Override
    public boolean removeAttendee(BwAttendee val) {
        Set<BwAttendee> as = this.getAttendees();
        if (as == null) {
            return false;
        }
        return as.remove(val);
    }

    @Override
    public Set<BwAttendee> copyAttendees() {
        if (this.getNumAttendees() == 0) {
            return null;
        }
        return new TreeSet<BwAttendee>(this.getAttendees());
    }

    @Override
    public Set<BwAttendee> cloneAttendees() {
        if (this.getNumAttendees() == 0) {
            return null;
        }
        TreeSet<BwAttendee> ts = new TreeSet<BwAttendee>();
        for (BwAttendee att : this.getAttendees()) {
            ts.add((BwAttendee)att.clone());
        }
        return ts;
    }

    @Override
    public void setRecipients(Set<String> val) {
    }

    @Override
    public Set<String> getRecipients() {
        return null;
    }

    @Override
    @NoDump
    public int getNumRecipients() {
        return 0;
    }

    @Override
    public void addRecipient(String val) {
    }

    @Override
    public boolean removeRecipient(String val) {
        return false;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DESCRIPTION, jname="description", adderName="description", alarmProperty=true)
    public void setDescriptions(Set<BwString> val) {
        this.descriptions = val;
    }

    @Override
    @Dump(collectionElementName="description")
    public Set<BwString> getDescriptions() {
        return this.descriptions;
    }

    @Override
    @NoDump
    public int getNumDescriptions() {
        Set<BwString> rs = this.getDescriptions();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    @Override
    public void addDescription(String lang, String val) {
        this.addDescription(new BwString(lang, val));
    }

    @Override
    public void addDescription(BwString val) {
        Set<BwString> rs = this.getDescriptions();
        if (rs == null) {
            rs = new TreeSet<BwString>();
            this.setDescriptions(rs);
        }
        rs.add(val);
    }

    @Override
    public boolean removeDescription(BwString val) {
        Set<BwString> rs = this.getDescriptions();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }

    @Override
    public void updateDescriptions(String lang, String val) {
        BwString s = this.findDescription(lang);
        if (val == null) {
            if (s != null) {
                this.removeDescription(s);
            }
        } else if (s == null) {
            this.addDescription(lang, val);
        } else if (CalFacadeUtil.cmpObjval(val, s.getValue()) != 0) {
            this.removeDescription(s);
            this.addDescription(lang, val);
        }
    }

    @Override
    public BwString findDescription(String lang) {
        return BwString.findLang(lang, this.getDescriptions());
    }

    @Override
    public void setDescription(String val) {
        this.updateDescriptions(null, val);
    }

    @Override
    @NoDump
    public String getDescription() {
        BwString s = this.findDescription(null);
        if (s == null) {
            return null;
        }
        return s.getValue();
    }

    @Override
    public void setSummaries(Set<BwString> val) {
        this.summaries = val;
    }

    @Override
    @Dump(collectionElementName="summary")
    public Set<BwString> getSummaries() {
        return this.summaries;
    }

    @Override
    @NoDump
    public int getNumSummaries() {
        Set<BwString> rs = this.getSummaries();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    @Override
    public void addSummary(BwString val) {
        Set<BwString> rs = this.getSummaries();
        if (rs == null) {
            rs = new TreeSet<BwString>();
            this.setSummaries(rs);
        }
        rs.add(val);
    }

    @Override
    public boolean removeSummary(BwString val) {
        Set<BwString> c = this.getSummaries();
        if (c == null) {
            return false;
        }
        return c.remove(val);
    }

    @Override
    public void updateSummaries(String lang, String val) {
        BwString s = this.findSummary(lang);
        if (val == null) {
            if (s != null) {
                this.removeSummary(s);
            }
        } else if (s == null) {
            this.addSummary(new BwString(lang, val));
        } else if (CalFacadeUtil.cmpObjval(val, s.getValue()) != 0) {
            this.removeSummary(s);
            this.addSummary(new BwString(lang, val));
        }
    }

    @Override
    public BwString findSummary(String lang) {
        return BwString.findLang(lang, this.getSummaries());
    }

    @Override
    public void setSummary(String val) {
        this.updateSummaries(null, val);
    }

    @Override
    @NoProxy
    @NoDump
    public String getSummary() {
        BwString s = this.findSummary(null);
        if (s == null) {
            return null;
        }
        return s.getValue();
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.XPROP, jname="xprop", adderName="xproperty", nested=true, keyindex=PropertyIndex.PropertyInfoIndex.NAME, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true)
    public void setXproperties(List<BwXproperty> val) {
        this.xproperties = val;
    }

    @Override
    @Dump(collectionElementName="xproperty", compound=true)
    public List<BwXproperty> getXproperties() {
        return this.xproperties;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumXproperties() {
        List<BwXproperty> c = this.getXproperties();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    @NoProxy
    @NoDump
    public List<BwXproperty> getXproperties(String val) {
        ArrayList<BwXproperty> res = new ArrayList<BwXproperty>();
        List<BwXproperty> xs = this.getXproperties();
        if (xs == null) {
            return res;
        }
        for (BwXproperty x : xs) {
            if (!x.getName().equals(val)) continue;
            res.add(x);
        }
        return res;
    }

    @Override
    @NoProxy
    @NoDump
    public List<BwXproperty> getXicalProperties(String val) {
        ArrayList<BwXproperty> res = new ArrayList<BwXproperty>();
        List<BwXproperty> xs = this.getXproperties();
        if (xs == null) {
            return res;
        }
        for (BwXproperty x : xs) {
            List<BwXproperty.Xpar> xpars;
            BwXproperty.Xpar xp;
            if (!x.getName().equals("X-BEDEWORK-ICAL-PROP") || !(xp = (xpars = x.getParameters()).get(0)).getName().equals(val)) continue;
            res.add(x);
        }
        return res;
    }

    @Override
    @NoProxy
    @NoDump
    public int removeXproperties(String val) {
        List<BwXproperty> xs = this.getXproperties(val);
        if (xs.size() == 0) {
            return 0;
        }
        for (BwXproperty x : xs) {
            this.removeXproperty(x);
        }
        return xs.size();
    }

    @Override
    @NoProxy
    public void addXproperty(BwXproperty val) {
        List<BwXproperty> c = this.getXproperties();
        if (c == null) {
            c = new ArrayList<BwXproperty>();
            this.setXproperties(c);
        }
        if (!c.contains(val)) {
            c.add(val);
        }
    }

    @Override
    @NoProxy
    public void removeXproperty(BwXproperty val) {
        List<BwXproperty> c = this.getXproperties();
        if (c == null) {
            return;
        }
        c.remove(val);
    }

    @Override
    @NoProxy
    public List<BwXproperty> cloneXproperty() {
        if (this.getNumXproperties() == 0) {
            return null;
        }
        ArrayList<BwXproperty> xs = new ArrayList<BwXproperty>();
        for (BwXproperty x : this.getXproperties()) {
            xs.add((BwXproperty)x.clone());
        }
        return xs;
    }

    @NoDump
    public Date getNextTriggerDate(BwDateTime start, Date previousTrigger) throws CalFacadeException {
        if (previousTrigger == null) {
            this.triggerDate = null;
            return this.getTriggerDate(start);
        }
        if (this.repeat == 0) {
            return null;
        }
        if (this.repeatCount == this.repeat) {
            return null;
        }
        ++this.repeatCount;
        TemporalAmount dur = new Duration(null, this.duration).getDuration();
        this.triggerDate = new TemporalAmountAdapter(dur).getTime(previousTrigger);
        return this.triggerDate;
    }

    @NoDump
    public Date getTriggerDate(BwDateTime start) throws CalFacadeException {
        try {
            if (this.triggerDate != null) {
                return this.triggerDate;
            }
            Trigger tr = new Trigger();
            tr.setValue(this.getTrigger());
            Object dt = tr.getDateTime();
            if (dt == null) {
                TemporalAmount dur = tr.getDuration();
                if (start == null) {
                    throw new RuntimeException("No start date for alarm " + this);
                }
                dt = new TemporalAmountAdapter(dur).getTime(BwDateTimeUtil.getDate(start));
            }
            this.triggerDate = dt;
            return dt;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static BwAlarm audioAlarm(String owner, TriggerVal trigger, String duration, int repeat, String attach) {
        return new BwAlarm(owner, 0, trigger, duration, repeat, 0, false, attach, null, null, null);
    }

    public static BwAlarm displayAlarm(String owner, TriggerVal trigger, String duration, int repeat, String description) {
        return new BwAlarm(owner, 1, trigger, duration, repeat, 0, false, null, description, null, null);
    }

    public static BwAlarm emailAlarm(String owner, TriggerVal trigger, String duration, int repeat, String attach, String description, String summary, Set<BwAttendee> attendees) {
        return new BwAlarm(owner, 2, trigger, duration, repeat, 0, false, attach, description, summary, attendees);
    }

    public static BwAlarm procedureAlarm(String owner, TriggerVal trigger, String duration, int repeat, String attach, String description) {
        return new BwAlarm(owner, 3, trigger, duration, repeat, 0, false, attach, description, null, null);
    }

    public static BwAlarm noneAlarm(String owner, TriggerVal trigger, String duration, int repeat, String description) {
        return new BwAlarm(owner, 4, trigger, duration, repeat, 0, false, null, description, null, null);
    }

    public static BwAlarm otherAlarm(String owner, String action, TriggerVal trigger, String duration, int repeat, String description) {
        BwAlarm al = new BwAlarm(owner, 5, trigger, duration, repeat, 0, false, null, description, null, null);
        al.addXproperty(BwXproperty.makeIcalProperty("ACTION", null, action));
        return al;
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("type", (Object)alarmTypes[this.getAlarmType()]);
        if (this.getTriggerStart()) {
            ts.append("trigger(START)", (Object)this.getTrigger());
        } else {
            ts.append("trigger(END)", (Object)this.getTrigger());
        }
        if (this.getDuration() != null) {
            ts.append("duration", (Object)this.getDuration());
            ts.append("repeat", this.getRepeat());
        }
        if (this.getAlarmType() == 0) {
            if (this.getAttach() != null) {
                ts.append("attach", (Object)this.getAttach());
            }
        } else if (this.getAlarmType() == 1) {
            ts.append("description", (Object)this.getDescription());
        } else if (this.getAlarmType() == 2) {
            ts.append("description", (Object)this.getDescription());
            ts.append("summary", (Object)this.getSummary());
            ts.append("attendees", this.getAttendees());
            ts.append("attach", (Object)this.getAttach());
        } else if (this.getAlarmType() == 3) {
            ts.append("attach", (Object)this.getAttach());
            ts.append("description", (Object)this.getDescription());
        }
    }

    public boolean matches(BwAlarm that) {
        if (this.getAlarmType() != that.getAlarmType()) {
            return false;
        }
        if (that.getTrigger() == null) {
            return true;
        }
        if (this.getTriggerStart() != that.getTriggerStart()) {
            return false;
        }
        if (this.getTriggerDateTime() != that.getTriggerDateTime()) {
            return false;
        }
        if (!this.getTrigger().equals(that.getTrigger())) {
            return false;
        }
        if (that.getDuration() == null) {
            return true;
        }
        if (!this.getDuration().equals(that.getDuration())) {
            return false;
        }
        return this.getRepeat() == that.getRepeat();
    }

    public boolean changed(BwAlarm that) {
        if (this.compareEqFields(that) != 0) {
            return true;
        }
        if (CalFacadeUtil.cmpObjval(this.getTrigger(), that.getTrigger()) != 0) {
            return true;
        }
        if (Boolean.compare(this.getTriggerStart(), that.getTriggerStart()) != 0) {
            return true;
        }
        if (Boolean.compare(this.getTriggerDateTime(), that.getTriggerDateTime()) != 0) {
            return true;
        }
        if (CalFacadeUtil.cmpObjval(this.getDuration(), that.getDuration()) != 0) {
            return true;
        }
        if (this.getRepeat() != that.getRepeat()) {
            return true;
        }
        if (this.getAlarmType() == 0) {
            return CalFacadeUtil.cmpObjval(this.getAttach(), that.getAttach()) != 0;
        }
        if (this.getAlarmType() == 1) {
            return CalFacadeUtil.cmpObjval(this.getDescription(), that.getDescription()) != 0;
        }
        if (this.getAlarmType() == 2) {
            if (CalFacadeUtil.cmpObjval(this.getDescription(), that.getDescription()) != 0) {
                return true;
            }
            if (CalFacadeUtil.cmpObjval(this.getSummary(), that.getSummary()) != 0) {
                return true;
            }
            if (CalFacadeUtil.cmpObjval(this.getAttendees(), that.getAttendees()) != 0) {
                return true;
            }
            return CalFacadeUtil.cmpObjval(this.getAttach(), that.getAttach()) != 0;
        }
        if (this.getAlarmType() == 3) {
            if (CalFacadeUtil.cmpObjval(this.getAttach(), that.getAttach()) != 0) {
                return true;
            }
            return CalFacadeUtil.cmpObjval(this.getDescription(), that.getDescription()) != 0;
        }
        return false;
    }

    public int compareEqFields(BwAlarm that) {
        int res = CalFacadeUtil.cmpObjval(this.getOwnerHref(), that.getOwnerHref());
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.getAlarmType(), that.getAlarmType());
        if (res != 0) {
            return res;
        }
        res = CalFacadeUtil.cmpObjval(this.getTrigger(), that.getTrigger());
        if (res != 0) {
            return res;
        }
        res = Boolean.compare(this.getTriggerDateTime(), that.getTriggerDateTime());
        if (res != 0) {
            return res;
        }
        return Boolean.compare(this.getTriggerStart(), that.getTriggerStart());
    }

    @Override
    public boolean differsFrom(BwAlarm val) {
        return this.changed(val);
    }

    @Override
    public int compareTo(BwAlarm that) {
        if (this == that) {
            return 0;
        }
        return this.compareEqFields(that);
    }

    @Override
    public int hashCode() {
        int hc = 31 * this.getAlarmType();
        if (this.getOwnerHref() != null) {
            hc *= this.getOwnerHref().hashCode();
        }
        hc *= this.getTrigger().hashCode();
        if (this.getTriggerStart()) {
            hc *= 2;
        }
        return hc;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    @Override
    public Object clone() {
        try {
            TriggerVal trigger = new TriggerVal();
            trigger.trigger = this.getTrigger();
            trigger.triggerStart = this.getTriggerStart();
            trigger.triggerDateTime = this.getTriggerDateTime();
            BwAlarm a = new BwAlarm(null, this.getAlarmType(), trigger, this.getDuration(), this.getRepeat(), this.getRepeatCount(), this.getExpired(), this.getAttach(), this.getDescription(), this.getSummary(), this.cloneAttendees());
            a.setOwnerHref(this.getOwnerHref());
            return a;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static class TriggerVal {
        public String trigger;
        public boolean triggerStart;
        public boolean triggerDateTime;
    }
}

