/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.caldav.server;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.CurrentAccess;
import org.bedework.caldav.server.CalDAVEvent;
import org.bedework.caldav.server.CaldavBwNode;
import org.bedework.caldav.server.CaldavURI;
import org.bedework.caldav.server.sysinterface.SysIntf;
import org.bedework.util.misc.ToString;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.tagdefs.AppleServerTags;
import org.bedework.util.xml.tagdefs.CaldavTags;
import org.bedework.util.xml.tagdefs.ICalTags;
import org.bedework.webdav.servlet.shared.WebdavException;
import org.bedework.webdav.servlet.shared.WebdavNsIntf;
import org.bedework.webdav.servlet.shared.WebdavNsNode;
import org.w3c.dom.Element;

public class CaldavComponentNode
extends CaldavBwNode {
    private CalDAVEvent<?> event;
    private AccessPrincipal owner;
    private CurrentAccess currentAccess;
    private String entityName;
    private boolean isTimezone;
    private Calendar ical;
    private Component comp;
    private String compContentType;
    private String compString;
    private static final HashMap<QName, WebdavNsNode.PropertyTagEntry> propertyNames = new HashMap();

    public CaldavComponentNode(SysIntf sysi, int status, String uri) {
        super(true, sysi, uri);
        this.setStatus(status);
    }

    public CaldavComponentNode(CaldavURI cdURI, SysIntf sysi) throws WebdavException {
        super(cdURI, sysi);
        this.col = cdURI.getCol();
        this.collection = false;
        this.allowsGet = true;
        this.entityName = cdURI.getEntityName();
        this.event = cdURI.getEntity();
    }

    public CaldavComponentNode(CalDAVEvent<?> event, SysIntf sysi) {
        super(sysi, event.getParentPath(), false, event.getPath());
        this.allowsGet = true;
        this.entityName = event.getName();
        this.event = event;
    }

    public void init(boolean content) {
        if (!content) {
            return;
        }
        if (this.event == null && this.exists && this.entityName == null) {
            this.exists = false;
        }
    }

    public AccessPrincipal getOwner() {
        if (this.owner == null) {
            if (this.event == null) {
                return null;
            }
            this.owner = this.event.getOwner();
        }
        return this.owner;
    }

    public boolean removeProperty(Element val, WebdavNsNode.SetPropertyResult spr) {
        this.warn("Unimplemented - removeProperty");
        return false;
    }

    public boolean setProperty(Element val, WebdavNsNode.SetPropertyResult spr) throws WebdavException {
        return super.setProperty(val, spr);
    }

    public Component getComponent() throws WebdavException {
        this.init(true);
        try {
            if (this.event != null && this.comp == null) {
                ComponentList cl;
                if (this.ical == null) {
                    this.ical = this.getSysi().toCalendar(this.event, this.col.getCalType() == 2 || this.col.getCalType() == 3);
                }
                if ((cl = this.ical.getComponents()) == null || cl.isEmpty()) {
                    return null;
                }
                this.comp = (Component)cl.get(0);
            }
        }
        catch (Throwable t) {
            throw new WebdavException(t);
        }
        return this.comp;
    }

    public void update() throws WebdavException {
        if (this.event != null) {
            this.getSysi().updateEvent(this.event);
        }
    }

    public void setEntityName(String val) throws WebdavException {
        if (this.entityName != null) {
            throw new WebdavException("Cannot change entity name");
        }
        this.entityName = val;
        this.uri = this.uri + "/" + val;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean trailSlash() {
        return false;
    }

    @Override
    public boolean knownProperty(QName tag) {
        if (propertyNames.get(tag) != null) {
            return true;
        }
        return super.knownProperty(tag);
    }

    @Override
    public boolean generatePropertyValue(QName tag, WebdavNsIntf intf, boolean allProp) throws WebdavException {
        WebdavNsNode.PropVal pv = new WebdavNsNode.PropVal();
        XmlEmit xml = intf.getXmlEmit();
        if (propertyNames.get(tag) == null) {
            return super.generatePropertyValue(tag, intf, allProp);
        }
        if (this.isTimezone) {
            return this.generateTZPropertyValue(tag, intf, allProp);
        }
        CalDAVEvent<?> ev = this.checkEv(pv);
        if (ev == null) {
            return true;
        }
        return ev.generatePropertyValue(tag, xml);
    }

    public Collection<WebdavNsNode.PropertyTagEntry> getPropertyNames() throws WebdavException {
        ArrayList<WebdavNsNode.PropertyTagEntry> res = new ArrayList<WebdavNsNode.PropertyTagEntry>();
        res.addAll(super.getPropertyNames());
        res.addAll(propertyNames.values());
        return res;
    }

    public void setEvent(CalDAVEvent<?> val) {
        this.event = val;
    }

    public CalDAVEvent<?> getEvent() throws WebdavException {
        this.init(true);
        return this.event;
    }

    public Calendar getIcal() throws WebdavException {
        this.init(true);
        try {
            if (this.ical == null) {
                this.ical = this.getSysi().toCalendar(this.event, this.col.getCalType() == 2 || this.col.getCalType() == 3);
            }
        }
        catch (Throwable t) {
            throw new WebdavException(t);
        }
        return this.ical;
    }

    public String writeContent(XmlEmit xml, Writer wtr, String contentType) throws WebdavException {
        try {
            ArrayList evs = new ArrayList();
            evs.add(this.event);
            SysIntf.MethodEmitted method = this.col.getCalType() == 2 || this.col.getCalType() == 3 ? SysIntf.MethodEmitted.eventMethod : SysIntf.MethodEmitted.noMethod;
            return this.getSysi().writeCalendar(evs, method, xml, wtr, contentType);
        }
        catch (WebdavException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WebdavException(t);
        }
    }

    public String getContentString(String contentType) throws WebdavException {
        return this.getCompString(contentType);
    }

    public CurrentAccess getCurrentAccess() throws WebdavException {
        if (this.currentAccess != null) {
            return this.currentAccess;
        }
        if (this.event == null) {
            return null;
        }
        try {
            this.currentAccess = this.getSysi().checkAccess(this.event, 25, true);
        }
        catch (Throwable t) {
            throw new WebdavException(t);
        }
        return this.currentAccess;
    }

    public String getStagValue() throws WebdavException {
        this.init(true);
        CalDAVEvent<?> ev = this.getEvent();
        if (ev == null) {
            return null;
        }
        return ev.getScheduleTag();
    }

    public String getPrevStagValue() throws WebdavException {
        this.init(true);
        CalDAVEvent<?> ev = this.getEvent();
        if (ev == null) {
            return null;
        }
        return ev.getPrevScheduleTag();
    }

    public String getEtagValue(boolean strong) throws WebdavException {
        this.init(true);
        CalDAVEvent<?> ev = this.getEvent();
        if (ev == null) {
            return null;
        }
        String val = ev.getEtag();
        if (strong) {
            return val;
        }
        return "W/" + val;
    }

    public String getPrevEtagValue(boolean strong) throws WebdavException {
        this.init(true);
        CalDAVEvent<?> ev = this.getEvent();
        if (ev == null) {
            return null;
        }
        String val = ev.getPreviousEtag();
        if (strong) {
            return val;
        }
        return "W/" + val;
    }

    @Override
    public String getEtokenValue() throws WebdavException {
        return this.concatEtoken(this.getEtagValue(true), this.getStagValue());
    }

    @Override
    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("path", (Object)this.getPath());
        ts.append("entityName", (Object)this.entityName);
        return ts.toString();
    }

    public String getContentLang() {
        return "en";
    }

    public long getContentLen() throws WebdavException {
        return this.getCompString(this.getContentType()).length();
    }

    public String getContentType() {
        return "text/calendar;charset=utf-8";
    }

    public String getCreDate() throws WebdavException {
        this.init(false);
        CalDAVEvent<?> ev = this.getEvent();
        if (ev == null) {
            return null;
        }
        return ev.getCreated();
    }

    public String getDisplayname() {
        return this.getEntityName();
    }

    public String getLastmodDate() throws WebdavException {
        this.init(false);
        CalDAVEvent<?> ev = this.getEvent();
        if (ev == null) {
            return null;
        }
        try {
            return DateTimeUtil.fromISODateTimeUTCtoRfc822((String)ev.getLastmod());
        }
        catch (Throwable t) {
            throw new WebdavException(t);
        }
    }

    public boolean allowsSyncReport() {
        return false;
    }

    public boolean getDeleted() throws WebdavException {
        return this.getEvent().getDeleted();
    }

    private String getCompString(String contentType) throws WebdavException {
        String ctype = contentType;
        if (ctype == null) {
            ctype = this.getSysi().getDefaultContentType();
        }
        if (ctype.equals(this.compContentType)) {
            return this.compString;
        }
        this.getIcal();
        this.compContentType = ctype;
        this.compString = this.getSysi().toIcalString(this.ical, ctype);
        return this.compString;
    }

    private boolean generateTZPropertyValue(QName tag, WebdavNsIntf intf, boolean allProp) {
        if (tag.equals(ICalTags.tzid)) {
            return true;
        }
        if (tag.equals(ICalTags.tzname)) {
            return true;
        }
        if (tag.equals(ICalTags.tzoffsetfrom)) {
            return true;
        }
        if (tag.equals(ICalTags.tzoffsetto)) {
            return true;
        }
        return tag.equals(ICalTags.tzurl);
    }

    private CalDAVEvent<?> checkEv(WebdavNsNode.PropVal pv) throws WebdavException {
        CalDAVEvent<?> ev = this.getEvent();
        if (ev == null) {
            pv.notFound = true;
            return null;
        }
        return ev;
    }

    static {
        CaldavComponentNode.addPropEntry(propertyNames, (QName)CaldavTags.calendarData);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)CaldavTags.originator);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)CaldavTags.recipient);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)CaldavTags.scheduleTag, (boolean)true);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)AppleServerTags.scheduleChanges);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.attach);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.attendee);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.categories);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags._class);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.comment);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.contact);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.created);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.description);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.dtend);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.dtstamp);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.dtstart);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.duration);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.exdate);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.exrule);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.geo);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.lastModified);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.location);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.organizer);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.priority);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.rdate);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.recurrenceId);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.relatedTo);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.resources);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.requestStatus);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.rrule);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.sequence);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.status);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.summary);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.transp);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.trigger);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.uid);
        CaldavComponentNode.addPropEntry(propertyNames, (QName)ICalTags.url);
    }
}

