/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.style.util;

import java.io.Serializable;
import java.net.URL;
import org.beangle.style.util.Charsets$;
import org.beangle.style.util.Files$;
import org.beangle.style.util.MediaType;
import org.beangle.style.util.Strings$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;

public final class MediaTypes$ {
    public static final MediaTypes$ MODULE$ = new MediaTypes$();
    private static final Map<String, MediaType> types = MODULE$.readMediaTypes();

    public void main(String[] args) {
        Predef$.MODULE$.println(this.readMediaTypes());
    }

    private Map<String, MediaType> types() {
        return types;
    }

    private Map<String, MediaType> readMediaTypes() {
        ClassLoader me = this.getClass().getClassLoader();
        URL url = me.getResource("org/beangle/style/text.types");
        if (url == null) {
            return Predef$.MODULE$.Map().empty();
        }
        HashMap buf = new HashMap();
        Files$.MODULE$.readLines(url.openStream(), Charsets$.MODULE$.UTF_8()).foreach((Function1 & Serializable)line -> {
            MediaTypes$.$anonfun$readMediaTypes$1(buf, line);
            return BoxedUnit.UNIT;
        });
        return buf.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public MediaType get(String ext, MediaType defaultValue) {
        return (MediaType)this.types().getOrElse((Object)ext, (Function0 & Serializable)() -> defaultValue);
    }

    public Option<MediaType> get(String ext) {
        return this.types().get((Object)ext);
    }

    public Seq<MediaType> parse(String str) {
        if (str == null) {
            return (Seq)Seq$.MODULE$.empty();
        }
        ListBuffer mediaTypes = new ListBuffer();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(str, ',')), (Function1 & Serializable)token -> {
            MediaType mediaType;
            int commaIndex = token.indexOf(";");
            String mimetype = commaIndex > -1 ? token.substring(0, commaIndex).trim() : token.trim();
            Option option = MODULE$.types().get((Object)mimetype);
            if (option instanceof Some) {
                Some some = (Some)option;
                MediaType mt = (MediaType)some.value();
                mediaType = mediaTypes.$plus$eq((Object)mt);
            } else if (None$.MODULE$.equals(option)) {
                mediaType = new MediaType(mimetype);
            } else {
                throw new MatchError((Object)option);
            }
            return mediaType;
        });
        return mediaTypes.toList();
    }

    public static final /* synthetic */ void $anonfun$readMediaTypes$1(HashMap buf$1, String line) {
        block1: {
            if (!Strings$.MODULE$.isNotBlank(line) || line.startsWith("#")) break block1;
            String mimetypeStr = Strings$.MODULE$.substringBetween(line, "=", "exts").trim();
            Predef$.MODULE$.assert(!buf$1.contains((Object)mimetypeStr), (Function0 & Serializable)() -> new StringBuilder(20).append("duplicate mime type:").append(mimetypeStr).toString());
            MediaType mimetype = new MediaType(mimetypeStr);
            buf$1.put((Object)mimetypeStr, (Object)mimetype);
            String exts = Strings$.MODULE$.substringAfter(line, "exts").trim().substring(1);
            if (Strings$.MODULE$.isNotBlank(exts)) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(exts, ',')), (Function1 & Serializable)ext -> {
                    String extension = ext.trim();
                    Option exists = buf$1.get((Object)extension);
                    Predef$.MODULE$.assert(exists.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(15).append(new StringBuilder(10).append("exists ").append(extension).append(" = ").toString()).append(exists.get()).append(", the newer is ").append(mimetype).toString());
                    return buf$1.put((Object)extension, (Object)mimetype);
                });
            }
        }
    }

    private MediaTypes$() {
    }
}

