/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.repo.artifact;

import java.io.File;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.net.URL;
import org.beangle.commons.collection.Collections$;
import org.beangle.repo.artifact.Artifact;
import org.beangle.repo.artifact.Artifact$;
import org.beangle.repo.artifact.ArtifactDownloader;
import org.beangle.repo.artifact.DependencyResolver;
import org.beangle.repo.artifact.Layout$Maven2$;
import org.beangle.repo.artifact.Repo;
import org.beangle.repo.artifact.Repo$Local$;
import org.beangle.repo.artifact.Repo$Remote$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BeangleResolver$
implements DependencyResolver {
    public static final BeangleResolver$ MODULE$ = new BeangleResolver$();
    private static final String DependenciesFile = "META-INF/beangle/container.dependencies";
    private static final String WarDependenciesFile = new StringBuilder(17).append("/WEB-INF/classes/").append(MODULE$.DependenciesFile()).toString();

    public String DependenciesFile() {
        return DependenciesFile;
    }

    private String WarDependenciesFile() {
        return WarDependenciesFile;
    }

    public void main(String[] args) {
        block5: {
            if (args.length < 1) {
                Predef$.MODULE$.println((Object)"Usage:java org.beangle.repo.artifact.BeangleResolver dependency_file remote_url local_base");
                return;
            }
            String remote = Repo$Remote$.MODULE$.CentralURL();
            String local = null;
            if (args.length > 1) {
                remote = args[1];
            }
            if (args.length > 2) {
                local = args[2];
            }
            Repo.Remote remoteRepo = new Repo.Remote("remote", remote, Layout$Maven2$.MODULE$);
            Repo.Local localRepo = new Repo.Local(local, Repo$Local$.MODULE$.$lessinit$greater$default$2());
            String file = args[0];
            if (file.contains(":") && !file.contains("/") && !file.contains("\\")) {
                Artifact war = Artifact$.MODULE$.apply(file).packaging("war");
                new ArtifactDownloader(remoteRepo, localRepo).download((Iterable<Artifact>)((Iterable)new .colon.colon((Object)war, (List)Nil$.MODULE$)));
                if (!localRepo.exists(war)) {
                    Predef$.MODULE$.println((Object)new StringBuilder(15).append("Download error:").append(file).toString());
                    return;
                }
                file = localRepo.file(war).getAbsolutePath();
            }
            Iterable<Artifact> artifacts = this.resolve(file);
            new ArtifactDownloader(remoteRepo, localRepo).download(artifacts);
            Iterable missing = (Iterable)artifacts.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BeangleResolver$.$anonfun$main$1(localRepo, x$1)));
            if (!missing.nonEmpty()) break block5;
            Predef$.MODULE$.println((Object)new StringBuilder(16).append("Download error :").append(missing).toString());
        }
    }

    public Iterable<Artifact> resolve(String file) {
        File dependencyFile = new File(file);
        if (!dependencyFile.exists()) {
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("Cannot find ").append(file).toString());
            return List$.MODULE$.empty();
        }
        URL url = null;
        if (file.endsWith(".war")) {
            URL nestedUrl = new URL(new StringBuilder(10).append("jar:file:").append(dependencyFile.getAbsolutePath()).append("!").append(this.WarDependenciesFile()).toString());
            try {
                nestedUrl.openConnection().connect();
                url = nestedUrl;
            }
            catch (Throwable throwable) {}
        } else if (dependencyFile.isDirectory()) {
            File nestedFile = new File(new StringBuilder(0).append(file).append(this.WarDependenciesFile()).toString());
            if (nestedFile.isFile()) {
                url = nestedFile.toURI().toURL();
            }
        } else {
            url = dependencyFile.toURI().toURL();
        }
        return url == null ? List$.MODULE$.empty() : this.resolve(url);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<Artifact> resolve(URL resource) {
        void var2_2;
        Buffer artifacts = Collections$.MODULE$.newBuffer();
        if (resource == null) {
            return List$.MODULE$.empty();
        }
        try {
            InputStreamReader reader = new InputStreamReader(resource.openStream());
            LineNumberReader lr = new LineNumberReader(reader);
            String line = null;
            do {
                BoxedUnit boxedUnit;
                if ((line = lr.readLine()) != null && !line.isEmpty()) {
                    String[] infos = line.split(":");
                    boxedUnit = artifacts.$plus$eq((Object)new Artifact(infos[0], infos[1], infos[2], Artifact$.MODULE$.$lessinit$greater$default$4(), Artifact$.MODULE$.$lessinit$greater$default$5()));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            } while (line != null);
            lr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$main$1(Repo.Local localRepo$1, Artifact x$1) {
        return !localRepo$1.exists(x$1);
    }

    private BeangleResolver$() {
    }
}

