/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.repo.artifact;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.beangle.commons.codec.binary.Base64$;
import org.beangle.commons.collection.Collections$;
import org.beangle.repo.artifact.Artifact;
import org.beangle.repo.artifact.ArtifactDownloader$;
import org.beangle.repo.artifact.Diff$;
import org.beangle.repo.artifact.Product;
import org.beangle.repo.artifact.Repo;
import org.beangle.repo.artifact.downloader.Downloader;
import org.beangle.repo.artifact.downloader.RangeDownloader;
import org.beangle.repo.artifact.downloader.RangeDownloader$;
import org.beangle.repo.artifact.util.Delta$;
import org.beangle.repo.artifact.util.FileSize$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.javaapi.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005\u0005-t!\u0002\u000b\u0016\u0011\u0003qb!\u0002\u0011\u0016\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\"CA*\u0003E\u0005I\u0011AA+\r\u0011\u0001S\u0003A\u0017\t\u00119*!Q1A\u0005\n=B\u0001bN\u0003\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0015\u0011)\u0019!C\u0005s!AQ(\u0002B\u0001B\u0003%!\bC\u0003)\u000b\u0011\u0005a\bC\u0004B\u000b\t\u0007I\u0011\u0002\"\t\rY+\u0001\u0015!\u0003D\u0011\u001d9V\u00011A\u0005\u0002aCq\u0001X\u0003A\u0002\u0013\u0005Q\f\u0003\u0004d\u000b\u0001\u0006K!\u0017\u0005\u0006I\u0016!\t!\u001a\u0005\u0006U\u0016!\ta\u001b\u0005\u0006u\u0016!Ia\u001f\u0005\b\u0003\u007f)A\u0011BA!\u0003I\t%\u000f^5gC\u000e$Hi\\<oY>\fG-\u001a:\u000b\u0005Y9\u0012\u0001C1si&4\u0017m\u0019;\u000b\u0005aI\u0012\u0001\u0002:fa>T!AG\u000e\u0002\u000f\t,\u0017M\\4mK*\tA$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002 \u00035\tQC\u0001\nBeRLg-Y2u\t><h\u000e\\8bI\u0016\u00148CA\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AH\u0001\u0006CB\u0004H.\u001f\u000b\u0006Y\u00055\u0013q\n\t\u0003?\u0015\u0019\"!\u0002\u0012\u0002\rI,Wn\u001c;f+\u0005\u0001\u0004CA\u00195\u001d\ty\"'\u0003\u00024+\u0005!!+\u001a9p\u0013\t)dG\u0001\u0004SK6|G/\u001a\u0006\u0003gU\tqA]3n_R,\u0007%A\u0003m_\u000e\fG.F\u0001;!\t\t4(\u0003\u0002=m\t)Aj\\2bY\u00061An\\2bY\u0002\"2\u0001L A\u0011\u0015q#\u00021\u00011\u0011\u0015A$\u00021\u0001;\u0003)\u0001(o\u001c9feRLWm]\u000b\u0002\u0007B!A)S&L\u001b\u0005)%B\u0001$H\u0003\u001diW\u000f^1cY\u0016T!\u0001\u0013\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002K\u000b\n\u0019Q*\u00199\u0011\u00051\u001bfBA'R!\tqE%D\u0001P\u0015\t\u0001V$\u0001\u0004=e>|GOP\u0005\u0003%\u0012\na\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\u0019\u0019FO]5oO*\u0011!\u000bJ\u0001\faJ|\u0007/\u001a:uS\u0016\u001c\b%A\u0004wKJ\u0014wn]3\u0016\u0003e\u0003\"a\t.\n\u0005m##a\u0002\"p_2,\u0017M\\\u0001\fm\u0016\u0014(m\\:f?\u0012*\u0017\u000f\u0006\u0002_CB\u00111eX\u0005\u0003A\u0012\u0012A!\u00168ji\"9!MDA\u0001\u0002\u0004I\u0016a\u0001=%c\u0005Aa/\u001a:c_N,\u0007%A\u0007bkRDwN]5{CRLwN\u001c\u000b\u0004=\u001aD\u0007\"B4\u0011\u0001\u0004Y\u0015\u0001C;tKJt\u0017-\\3\t\u000b%\u0004\u0002\u0019A&\u0002\u0011A\f7o]<pe\u0012\f\u0001\u0002Z8x]2|\u0017\r\u001a\u000b\u0003=2DQ!\\\tA\u00029\f\u0011\"\u0019:uS\u001a\f7\r^:\u0011\u0007=$xO\u0004\u0002qe:\u0011a*]\u0005\u0002K%\u00111\u000fJ\u0001\ba\u0006\u001c7.Y4f\u0013\t)hO\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\t\u0019H\u0005\u0005\u0002 q&\u0011\u00110\u0006\u0002\t\u0003J$\u0018NZ1di\u0006QAm\u001c#po:dw.\u00193\u0015\ryc\u0018QAA\u000f\u0011\u0015i(\u00031\u0001\u007f\u0003!\u0001(o\u001c3vGR\u001c\bcA8u\u007fB\u0019q$!\u0001\n\u0007\u0005\rQCA\u0004Qe>$Wo\u0019;\t\u000f\u0005\u001d!\u00031\u0001\u0002\n\u0005AQ\r_3dkR|'\u000f\u0005\u0003\u0002\f\u0005eQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0014\u0005U\u0011\u0001B;uS2T!!a\u0006\u0002\t)\fg/Y\u0005\u0005\u00037\tiAA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u001d\tyB\u0005a\u0001\u0003C\t\u0001b\u001d;biV\u001cXm\u001d\t\t\u0003\u0017\t\u0019#a\n\u00024%!\u0011QEA\u0007\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003S\ty#\u0004\u0002\u0002,)!\u0011QFA\u000b\u0003\rqW\r^\u0005\u0005\u0003c\tYCA\u0002V%2\u0003B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003s)\u0012A\u00033po:dw.\u00193fe&!\u0011QHA\u001c\u0005)!un\u001e8m_\u0006$WM]\u0001\u0006g2,W\r\u001d\u000b\u0004=\u0006\r\u0003bBA#'\u0001\u0007\u0011qI\u0001\u000b[&dGn]3d_:$\u0007cA\u0012\u0002J%\u0019\u00111\n\u0013\u0003\u0007%sG\u000fC\u0003/\u0007\u0001\u00071\n\u0003\u0005\u0002R\r\u0001\n\u00111\u0001L\u0003\u0011\u0011\u0017m]3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*\"!a\u0016+\u0007-\u000bIf\u000b\u0002\u0002\\A!\u0011QLA4\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014!C;oG\",7m[3e\u0015\r\t)\u0007J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA5\u0003?\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ArtifactDownloader {
    private final Repo.Remote remote;
    private final Repo.Local local;
    private final scala.collection.mutable.Map<String, String> properties;
    private boolean verbose;

    public static String apply$default$2() {
        return ArtifactDownloader$.MODULE$.apply$default$2();
    }

    public static ArtifactDownloader apply(String string, String string2) {
        return ArtifactDownloader$.MODULE$.apply(string, string2);
    }

    private Repo.Remote remote() {
        return this.remote;
    }

    private Repo.Local local() {
        return this.local;
    }

    private scala.collection.mutable.Map<String, String> properties() {
        return this.properties;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    public void authorization(String username, String password) {
        this.properties().put((Object)"Authorization", (Object)new StringBuilder(6).append("Basic ").append(Base64$.MODULE$.encode(new StringBuilder(1).append(username).append(":").append(password).toString().getBytes())).toString());
    }

    public void download(Iterable<Artifact> artifacts) {
        ConcurrentHashMap<URL, Downloader> statuses = new ConcurrentHashMap<URL, Downloader>();
        ExecutorService executor = Executors.newFixedThreadPool(5);
        ArrayBuffer sha1s = new ArrayBuffer();
        ArrayBuffer diffs = new ArrayBuffer();
        artifacts.withFilter((Function1 & Serializable)artifact -> BoxesRunTime.boxToBoolean((boolean)ArtifactDownloader.$anonfun$download$1(this, artifact))).foreach((Function1 & Serializable)artifact -> {
            ArtifactDownloader.$anonfun$download$2(this, sha1s, diffs, artifact);
            return BoxedUnit.UNIT;
        });
        this.doDownload((Iterable<Product>)sha1s, executor, statuses);
        this.doDownload((Iterable<Product>)diffs, executor, statuses);
        ArrayBuffer newers = new ArrayBuffer();
        diffs.foreach((Function1 & Serializable)diff -> {
            BoxedUnit boxedUnit;
            File diffFile = this.local().file((Product)diff);
            if (diffFile.exists()) {
                if (this.verbose()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(9).append("Patching ").append(diff).toString());
                }
                Delta$.MODULE$.patch(this.local().url(diff.older()), this.local().url(diff.newer()), this.local().url((Product)diff));
                boxedUnit = newers.$plus$eq((Object)diff.newer());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        artifacts.foreach((Function1 & Serializable)artifact -> !this.local().file((Product)artifact).exists() ? newers.$plus$eq(artifact) : BoxedUnit.UNIT);
        this.doDownload((Iterable<Product>)newers, executor, statuses);
        newers.foreach((Function1 & Serializable)artifact -> {
            Object object;
            if (!this.local().verifySha1((Artifact)artifact)) {
                if (this.verbose()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(26).append("Error sha1 for ").append(artifact).append(",Remove it.").toString());
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.local().remove((Product)artifact));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        executor.shutdown();
    }

    private void doDownload(Iterable<Product> products, ExecutorService executor, ConcurrentHashMap<URL, Downloader> statuses) {
        block3: {
            if (products.size() <= 0) {
                return;
            }
            IntRef idx = IntRef.create((int)1);
            products.foreach((Function1 & Serializable)artifact -> {
                ArtifactDownloader.$anonfun$doDownload$1(this, idx, products, statuses, executor, artifact);
                return BoxedUnit.UNIT;
            });
            if (!this.verbose()) break block3;
            int i = 0;
            char[] splash = new char[]{'\\', '|', '/', '-'};
            int count = statuses.size();
            while (!statuses.isEmpty() && !executor.isTerminated()) {
                this.sleep(1000);
                Predef$.MODULE$.print((Object)"\r");
                scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
                sb.append(splash[i % 4]).append("  ");
                CollectionConverters$.MODULE$.asScala(statuses).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ArtifactDownloader.$anonfun$doDownload$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                    Downloader value;
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Downloader downloader = value = (Downloader)tuple2._2();
                    scala.collection.mutable.StringBuilder stringBuilder = sb.append(new StringBuilder(5).append(FileSize$.MODULE$.apply(downloader.downloaded())).append("/").append(FileSize$.MODULE$.apply(downloader.contentLength())).append("    ").toString());
                    return stringBuilder;
                });
                sb.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 100 - sb.length()));
                ++i;
                Predef$.MODULE$.print((Object)sb.toString());
            }
            if (count > 0) {
                Predef$.MODULE$.print((Object)"\n");
            }
        }
    }

    private void sleep(int millsecond) {
        try {
            Thread.sleep(millsecond);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$download$1(ArtifactDownloader $this, Artifact artifact) {
        return !$this.local().file(artifact).exists();
    }

    public static final /* synthetic */ void $anonfun$download$2(ArtifactDownloader $this, ArrayBuffer sha1s$1, ArrayBuffer diffs$1, Artifact artifact) {
        block0: {
            if (artifact.packaging().endsWith("sha1")) break block0;
            Artifact sha1 = artifact.sha1();
            Object object = !$this.local().file(sha1).exists() ? sha1s$1.$plus$eq((Object)sha1) : BoxedUnit.UNIT;
            $this.local().lastestBefore(artifact).foreach((Function1 & Serializable)lastest -> (ArrayBuffer)diffs$1.$plus$eq((Object)Diff$.MODULE$.apply((Artifact)lastest, artifact.version())));
        }
    }

    public static final /* synthetic */ void $anonfun$doDownload$1(ArtifactDownloader $this, IntRef idx$1, Iterable products$1, ConcurrentHashMap statuses$1, ExecutorService executor$1, Product artifact) {
        block0: {
            if ($this.local().file(artifact).exists()) break block0;
            int id = idx$1.elem++;
            RangeDownloader downloader = RangeDownloader$.MODULE$.apply(new StringBuilder(1).append(id).append("/").append(products$1.size()).toString(), $this.remote().url(artifact), $this.local().url(artifact));
            downloader.verbose_$eq($this.verbose());
            downloader.addProperties((Map<String, String>)$this.properties());
            statuses$1.put(downloader.url(), downloader);
            executor$1.execute(() -> {
                try {
                    try {
                        downloader.start();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    statuses$1.remove(downloader.url());
                }
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$doDownload$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public ArtifactDownloader(Repo.Remote remote, Repo.Local local) {
        this.remote = remote;
        this.local = local;
        this.properties = Collections$.MODULE$.newMap();
        this.verbose = true;
    }
}

