/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.repo.artifact.downloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.repo.artifact.downloader.AbstractDownloader;
import org.beangle.repo.artifact.downloader.Downloader;
import org.beangle.repo.artifact.downloader.RangeDownloader$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mr!\u0002\r\u001a\u0011\u0003!c!\u0002\u0014\u001a\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"\u0002\u0019\u0002\t\u0003\td\u0001\u0002\u0014\u001a\u0001MB\u0011b\u000e\u0003\u0003\u0002\u0003\u0006I\u0001O\"\t\u0013\u0011#!\u0011!Q\u0001\n\u0015k\u0005\"\u0003(\u0005\u0005\u0003\u0005\u000b\u0011B(V\u0011\u0015qC\u0001\"\u0001W\u0011\u001dQF\u00011A\u0005\u0002mCqa\u0018\u0003A\u0002\u0013\u0005\u0001\r\u0003\u0004g\t\u0001\u0006K\u0001\u0018\u0005\bO\u0012\u0001\r\u0011\"\u0001\\\u0011\u001dAG\u00011A\u0005\u0002%Daa\u001b\u0003!B\u0013a\u0006b\u00027\u0005\u0001\u0004%\t!\u001c\u0005\bm\u0012\u0001\r\u0011\"\u0001x\u0011\u0019IH\u0001)Q\u0005]\"9!\u0010\u0002b\u0001\n\u0013Y\bbBA\u0005\t\u0001\u0006I\u0001 \u0005\b\u0003\u0017!A\u0011AA\u0007\u0011\u001d\t9\u0002\u0002C\u0001\u00033Aq!!\n\u0005\t#\n9\u0003C\u0007\u0002*\u0011\u0001\n1!A\u0001\n\u0013\tY#T\u0001\u0010%\u0006tw-\u001a#po:dw.\u00193fe*\u0011!dG\u0001\u000bI><h\u000e\\8bI\u0016\u0014(B\u0001\u000f\u001e\u0003!\t'\u000f^5gC\u000e$(B\u0001\u0010 \u0003\u0011\u0011X\r]8\u000b\u0005\u0001\n\u0013a\u00022fC:<G.\u001a\u0006\u0002E\u0005\u0019qN]4\u0004\u0001A\u0011Q%A\u0007\u00023\ty!+\u00198hK\u0012{wO\u001c7pC\u0012,'o\u0005\u0002\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0013\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fI\ni#a\f\u00022A\u0011Q\u0005B\n\u0003\tQ\u0002\"!J\u001b\n\u0005YJ\"AE!cgR\u0014\u0018m\u0019;E_^tGn\\1eKJ\fAA\\1nKB\u0011\u0011\b\u0011\b\u0003uy\u0002\"a\u000f\u0016\u000e\u0003qR!!P\u0012\u0002\rq\u0012xn\u001c;?\u0013\ty$&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003\n\u0013aa\u0015;sS:<'BA +\u0013\t9T'A\u0002ve2\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u00079,GOC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%aA+S\u0019&\u0011A)N\u0001\tY>\u001c\u0017\r^5p]B\u0011\u0001kU\u0007\u0002#*\u0011!+S\u0001\u0003S>L!\u0001V)\u0003\t\u0019KG.Z\u0005\u0003\u001dV\"BAM,Y3\")q\u0007\u0003a\u0001q!)A\t\u0003a\u0001\u000b\")a\n\u0003a\u0001\u001f\u00069A\u000f\u001b:fC\u0012\u001cX#\u0001/\u0011\u0005%j\u0016B\u00010+\u0005\rIe\u000e^\u0001\fi\"\u0014X-\u00193t?\u0012*\u0017\u000f\u0006\u0002bIB\u0011\u0011FY\u0005\u0003G*\u0012A!\u00168ji\"9QMCA\u0001\u0002\u0004a\u0016a\u0001=%c\u0005AA\u000f\u001b:fC\u0012\u001c\b%\u0001\u0003ti\u0016\u0004\u0018\u0001C:uKB|F%Z9\u0015\u0005\u0005T\u0007bB3\u000e\u0003\u0003\u0005\r\u0001X\u0001\u0006gR,\u0007\u000fI\u0001\tKb,7-\u001e;peV\ta\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005ML\u0015\u0001B;uS2L!!\u001e9\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\fA\"\u001a=fGV$xN]0%KF$\"!\u0019=\t\u000f\u0015\u0004\u0012\u0011!a\u0001]\u0006IQ\r_3dkR|'\u000fI\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cX#\u0001?\u0011\u000bu\f)\u0001\u000f\u001d\u000e\u0003yT1a`A\u0001\u0003\u001diW\u000f^1cY\u0016T1!a\u0001+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u000fq(aA'ba\u0006Y\u0001O]8qKJ$\u0018.Z:!\u0003-\tG\r\u001a)s_B,'\u000f^=\u0015\r\u0005=\u0011\u0011CA\n\u001b\u0005!\u0001\"B\u001c\u0015\u0001\u0004A\u0004BBA\u000b)\u0001\u0007\u0001(A\u0003wC2,X-A\u0007bI\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003\u001f\tY\u0002C\u0004\u0002\u001eU\u0001\r!a\b\u0002\u000bA\u0014x\u000e]:\u0011\r\u0005\u0005\u00121\u0005\u001d9\u001b\t\t\t!\u0003\u0003\u0002\b\u0005\u0005\u0011a\u00033po:dw.\u00193j]\u001e$\u0012!Y\u0001\ngV\u0004XM\u001d\u0013ve2,\u0012!\u0012\u0005\u0006o\r\u0001\r\u0001\u000f\u0005\u0006\t\u000e\u0001\r\u0001\u000f\u0005\u0006\u001d\u000e\u0001\r\u0001\u000f")
public class RangeDownloader
extends AbstractDownloader {
    private int threads = 20;
    private int step = 102400;
    private ExecutorService executor = Executors.newFixedThreadPool(this.threads());
    private final scala.collection.mutable.Map<String, String> properties = Collections$.MODULE$.newMap();

    public static RangeDownloader apply(String string, String string2, String string3) {
        return RangeDownloader$.MODULE$.apply(string, string2, string3);
    }

    private /* synthetic */ URL super$url() {
        return super.url();
    }

    public int threads() {
        return this.threads;
    }

    public void threads_$eq(int x$1) {
        this.threads = x$1;
    }

    public int step() {
        return this.step;
    }

    public void step_$eq(int x$1) {
        this.step = x$1;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    private scala.collection.mutable.Map<String, String> properties() {
        return this.properties;
    }

    public RangeDownloader addProperty(String name, String value) {
        this.properties().put((Object)name, (Object)value);
        return this;
    }

    public RangeDownloader addProperties(Map<String, String> props) {
        this.properties().$plus$plus$eq(props);
        return this;
    }

    @Override
    public void downloading() {
        AbstractDownloader.ResourceStatus urlStatus = this.access();
        if (urlStatus.length() < 0L) {
            Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(2).append("\r").append(HttpUtils$.MODULE$.toString(urlStatus.status())).append(" ").append(this.super$url()).toString());
            return;
        }
        if (urlStatus.length() < 102400L || !urlStatus.supportRange()) {
            if (this.verbose()) {
                Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(15).append("Downloading ").append(urlStatus.target()).append("[").append(urlStatus.length()).append("b]").toString());
            }
            super.defaultDownloading(urlStatus.target().openConnection());
            return;
        }
        if (this.verbose()) {
            Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(18).append("Range-Downloading ").append(this.super$url()).toString());
        }
        this.status_$eq(new Downloader.Status(urlStatus.length()));
        if (this.status().total() > Integer.MAX_VALUE) {
            throw new RuntimeException(new StringBuilder(27).append("Cannot download ").append(super.url()).append(" with size ").append(this.status().total()).toString());
        }
        int total = (int)this.status().total();
        byte[] totalbuffer = (byte[])Array$.MODULE$.ofDim(total, (ClassTag)ClassTag$.MODULE$.Byte());
        LongRef lastModified = LongRef.create((long)urlStatus.lastModified());
        int begin = 0;
        ArrayList<Callable<Integer>> tasks = new ArrayList<Callable<Integer>>();
        while ((long)begin < this.status().total()) {
            int start = begin;
            int end = start + this.step() - 1 >= total ? total - 1 : start + this.step() - 1;
            tasks.add(() -> {
                HttpURLConnection connection = (HttpURLConnection)urlStatus.target().openConnection();
                connection.setRequestProperty("RANGE", new StringBuilder(7).append("bytes=").append(start).append("-").append(end).toString());
                this.properties().foreach((Function1 & Serializable)e -> {
                    connection.setRequestProperty((String)e._1(), (String)e._2());
                    return BoxedUnit.UNIT;
                });
                InputStream input = connection.getInputStream();
                if (lastModified$1.elem == 0L) {
                    lastModified$1.elem = connection.getLastModified();
                }
                byte[] buffer = (byte[])Array$.MODULE$.ofDim(1024, (ClassTag)ClassTag$.MODULE$.Byte());
                int n = input.read(buffer);
                int next = start;
                boolean tooMore = false;
                while (-1 != n && !tooMore) {
                    if (next + n - 1 > end) {
                        n = end - next + 1;
                        tooMore = true;
                    }
                    System.arraycopy(buffer, 0, totalbuffer, next, n);
                    this.status().count().addAndGet(n);
                    next += n;
                    n = input.read(buffer);
                }
                IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
                return Predef$.MODULE$.int2Integer(end);
            });
            begin += this.step();
        }
        try {
            this.executor().invokeAll(tasks);
            this.executor().shutdown();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.status().count().get() != this.status().total()) {
            throw new RuntimeException(new StringBuilder(33).append("Download error: expect ").append(this.status().total()).append(" but get ").append(this.status().count().get()).append(".").toString());
        }
        FileOutputStream output = new FileOutputStream(super.location());
        output.write(totalbuffer, 0, total);
        Object object = lastModified.elem > 0L ? BoxesRunTime.boxToBoolean((boolean)super.location().setLastModified(lastModified.elem)) : BoxedUnit.UNIT;
        IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{output}));
        this.finish(super.url(), System.currentTimeMillis() - this.startAt());
    }

    public RangeDownloader(String name, URL url, File location) {
        super(name, url, location);
    }
}

