/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.repo.artifact;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.beangle.commons.codec.binary.Base64$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.repo.artifact.Artifact;
import org.beangle.repo.artifact.ArtifactDownloader$;
import org.beangle.repo.artifact.Diff$;
import org.beangle.repo.artifact.Product;
import org.beangle.repo.artifact.Repo;
import org.beangle.repo.artifact.downloader.Downloader;
import org.beangle.repo.artifact.downloader.RangeDownloader;
import org.beangle.repo.artifact.downloader.RangeDownloader$;
import org.beangle.repo.artifact.util.Delta$;
import org.beangle.repo.artifact.util.FileSize$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.javaapi.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005mt!\u0002\u000b\u0016\u0011\u0003qb!\u0002\u0011\u0016\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\"CA2\u0003E\u0005I\u0011AA3\r\u0011\u0001S\u0003A\u0017\t\u0011Y*!Q1A\u0005\n]B\u0001bP\u0003\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0001\u0016\u0011)\u0019!C\u0005\u0003\"AQ)\u0002B\u0001B\u0003%!\tC\u0003)\u000b\u0011\u0005a\tC\u0004J\u000b\t\u0007I\u0011\u0002&\t\ry+\u0001\u0015!\u0003L\u0011\u001dyV\u00011A\u0005\u0002\u0001Dq\u0001Z\u0003A\u0002\u0013\u0005Q\r\u0003\u0004l\u000b\u0001\u0006K!\u0019\u0005\u0006Y\u0016!\t!\u001c\u0005\u0006e\u0016!\ta\u001d\u0005\b\u0003\u000b)A\u0011BA\u0004\u0011\u001d\ty%\u0002C\u0005\u0003#\n!#\u0011:uS\u001a\f7\r\u001e#po:dw.\u00193fe*\u0011acF\u0001\tCJ$\u0018NZ1di*\u0011\u0001$G\u0001\u0005e\u0016\u0004xN\u0003\u0002\u001b7\u00059!-Z1oO2,'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005}\tQ\"A\u000b\u0003%\u0005\u0013H/\u001b4bGR$un\u001e8m_\u0006$WM]\n\u0003\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f\u0003\u0015\t\u0007\u000f\u001d7z)\u0015a\u0013QLA0!\tyRaE\u0002\u0006E9\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u000f1|wmZ5oO*\u00111'G\u0001\bG>lWn\u001c8t\u0013\t)\u0004GA\u0004M_\u001e<\u0017N\\4\u0002\rI,Wn\u001c;f+\u0005A\u0004CA\u001d=\u001d\ty\"(\u0003\u0002<+\u0005!!+\u001a9p\u0013\tidH\u0001\u0004SK6|G/\u001a\u0006\u0003wU\tqA]3n_R,\u0007%A\u0003m_\u000e\fG.F\u0001C!\tI4)\u0003\u0002E}\t)Aj\\2bY\u00061An\\2bY\u0002\"2\u0001L$I\u0011\u00151$\u00021\u00019\u0011\u0015\u0001%\u00021\u0001C\u0003)\u0001(o\u001c9feRLWm]\u000b\u0002\u0017B!A*U*T\u001b\u0005i%B\u0001(P\u0003\u001diW\u000f^1cY\u0016T!\u0001\u0015\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002S\u001b\n\u0019Q*\u00199\u0011\u0005Q[fBA+Z!\t1F%D\u0001X\u0015\tAV$\u0001\u0004=e>|GOP\u0005\u00035\u0012\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!\fJ\u0001\faJ|\u0007/\u001a:uS\u0016\u001c\b%A\u0004wKJ\u0014wn]3\u0016\u0003\u0005\u0004\"a\t2\n\u0005\r$#a\u0002\"p_2,\u0017M\\\u0001\fm\u0016\u0014(m\\:f?\u0012*\u0017\u000f\u0006\u0002gSB\u00111eZ\u0005\u0003Q\u0012\u0012A!\u00168ji\"9!NDA\u0001\u0002\u0004\t\u0017a\u0001=%c\u0005Aa/\u001a:c_N,\u0007%A\u0007bkRDwN]5{CRLwN\u001c\u000b\u0004M:\u0004\b\"B8\u0011\u0001\u0004\u0019\u0016\u0001C;tKJt\u0017-\\3\t\u000bE\u0004\u0002\u0019A*\u0002\u0011A\f7o]<pe\u0012\f\u0001\u0002Z8x]2|\u0017\r\u001a\u000b\u0003MRDQ!^\tA\u0002Y\f\u0011\"\u0019:uS\u001a\f7\r^:\u0011\u0007]dxP\u0004\u0002yu:\u0011a+_\u0005\u0002K%\u00111\u0010J\u0001\ba\u0006\u001c7.Y4f\u0013\tihP\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tYH\u0005E\u0002 \u0003\u0003I1!a\u0001\u0016\u0005!\t%\u000f^5gC\u000e$\u0018A\u00033p\t><h\u000e\\8bIR9a-!\u0003\u0002\u0016\u00055\u0002bBA\u0006%\u0001\u0007\u0011QB\u0001\taJ|G-^2ugB!q\u000f`A\b!\ry\u0012\u0011C\u0005\u0004\u0003')\"a\u0002)s_\u0012,8\r\u001e\u0005\b\u0003/\u0011\u0002\u0019AA\r\u0003!)\u00070Z2vi>\u0014\b\u0003BA\u000e\u0003Si!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0012\u0003K\tA!\u001e;jY*\u0011\u0011qE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u0005u!aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u000f\u0005=\"\u00031\u0001\u00022\u0005A1\u000f^1ukN,7\u000f\u0005\u0005\u0002\u001c\u0005M\u0012qGA\"\u0013\u0011\t)$!\b\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\u0011\ti$!\n\u0002\u00079,G/\u0003\u0003\u0002B\u0005m\"aA+S\u0019B!\u0011QIA&\u001b\t\t9EC\u0002\u0002JU\t!\u0002Z8x]2|\u0017\rZ3s\u0013\u0011\ti%a\u0012\u0003\u0015\u0011{wO\u001c7pC\u0012,'/A\u0003tY\u0016,\u0007\u000fF\u0002g\u0003'Bq!!\u0016\u0014\u0001\u0004\t9&\u0001\u0006nS2d7/Z2p]\u0012\u00042aIA-\u0013\r\tY\u0006\n\u0002\u0004\u0013:$\b\"\u0002\u001c\u0004\u0001\u0004\u0019\u0006\u0002CA1\u0007A\u0005\t\u0019A*\u0002\t\t\f7/Z\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\r\u0016\u0004'\u0006%4FAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UD%\u0001\u0006b]:|G/\u0019;j_:LA!!\u001f\u0002p\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ArtifactDownloader
implements Logging {
    private final Repo.Remote remote;
    private final Repo.Local local;
    private final scala.collection.mutable.Map<String, String> properties;
    private boolean verbose;
    private Logger logger;

    public static String apply$default$2() {
        return ArtifactDownloader$.MODULE$.apply$default$2();
    }

    public static ArtifactDownloader apply(String string, String string2) {
        return ArtifactDownloader$.MODULE$.apply(string, string2);
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Repo.Remote remote() {
        return this.remote;
    }

    private Repo.Local local() {
        return this.local;
    }

    private scala.collection.mutable.Map<String, String> properties() {
        return this.properties;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    public void authorization(String username, String password) {
        this.properties().put((Object)"Authorization", (Object)new StringBuilder(6).append("Basic ").append(Base64$.MODULE$.encode(new StringBuilder(1).append(username).append(":").append(password).toString().getBytes())).toString());
    }

    public void download(Iterable<Artifact> artifacts) {
        ConcurrentHashMap<URL, Downloader> statuses = new ConcurrentHashMap<URL, Downloader>();
        ExecutorService executor = Executors.newFixedThreadPool(5);
        ArrayBuffer sha1s = new ArrayBuffer();
        ArrayBuffer diffs = new ArrayBuffer();
        artifacts.withFilter((Function1 & Serializable)artifact -> BoxesRunTime.boxToBoolean((boolean)ArtifactDownloader.$anonfun$download$1(this, artifact))).foreach((Function1 & Serializable)artifact -> {
            ArtifactDownloader.$anonfun$download$2(this, sha1s, diffs, artifact);
            return BoxedUnit.UNIT;
        });
        this.doDownload((Iterable<Product>)sha1s, executor, statuses);
        this.doDownload((Iterable<Product>)diffs, executor, statuses);
        ArrayBuffer newers = new ArrayBuffer();
        diffs.foreach((Function1 & Serializable)diff -> {
            BoxedUnit boxedUnit;
            File diffFile = this.local().file((Product)diff);
            if (diffFile.exists()) {
                if (this.verbose()) {
                    Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(9).append("Patching ").append(diff).toString());
                }
                Delta$.MODULE$.patch(this.local().url(diff.older()), this.local().url(diff.newer()), this.local().url((Product)diff));
                boxedUnit = newers.$plus$eq((Object)diff.newer());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        artifacts.foreach((Function1 & Serializable)artifact -> !this.local().file((Product)artifact).exists() ? newers.$plus$eq(artifact) : BoxedUnit.UNIT);
        this.doDownload((Iterable<Product>)newers, executor, statuses);
        newers.foreach((Function1 & Serializable)artifact -> {
            Object object;
            if (this.verbose()) {
                Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(9).append("Verifing ").append(artifact.sha1()).toString());
            }
            if (!this.local().verifySha1((Artifact)artifact)) {
                if (this.verbose()) {
                    Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(26).append("Error sha1 for ").append(artifact).append(",Remove it.").toString());
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.local().remove((Product)artifact));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        executor.shutdown();
    }

    private void doDownload(Iterable<Product> products, ExecutorService executor, ConcurrentHashMap<URL, Downloader> statuses) {
        block2: {
            if (products.size() <= 0) {
                return;
            }
            IntRef idx = IntRef.create((int)1);
            products.foreach((Function1 & Serializable)artifact -> {
                ArtifactDownloader.$anonfun$doDownload$1(this, idx, products, statuses, executor, artifact);
                return BoxedUnit.UNIT;
            });
            int i = 0;
            char[] splash = new char[]{'\\', '|', '/', '-'};
            int count = statuses.size();
            while (!statuses.isEmpty() && !executor.isTerminated()) {
                this.sleep(500);
                Predef$.MODULE$.print((Object)"\r");
                scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
                sb.append(splash[i % 4]).append("  ");
                CollectionConverters$.MODULE$.asScala(statuses).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ArtifactDownloader.$anonfun$doDownload$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                    Downloader value;
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Downloader downloader = value = (Downloader)tuple2._2();
                    scala.collection.mutable.StringBuilder stringBuilder = sb.append(new StringBuilder(5).append(FileSize$.MODULE$.apply(downloader.downloaded())).append("/").append(FileSize$.MODULE$.apply(downloader.contentLength())).append("    ").toString());
                    return stringBuilder;
                });
                sb.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 100 - sb.length()));
                ++i;
                Predef$.MODULE$.print((Object)sb.toString());
            }
            if (count <= 0) break block2;
            Predef$.MODULE$.print((Object)"\n");
        }
    }

    private void sleep(int millsecond) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$download$1(ArtifactDownloader $this, Artifact artifact) {
        return !$this.local().file(artifact).exists();
    }

    public static final /* synthetic */ void $anonfun$download$2(ArtifactDownloader $this, ArrayBuffer sha1s$1, ArrayBuffer diffs$1, Artifact artifact) {
        Object object;
        if (!artifact.packaging().endsWith("sha1")) {
            Artifact sha1 = artifact.sha1();
            object = !$this.local().file(sha1).exists() ? sha1s$1.$plus$eq((Object)sha1) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        $this.local().lastestBefore(artifact).foreach((Function1 & Serializable)lastest -> (ArrayBuffer)diffs$1.$plus$eq((Object)Diff$.MODULE$.apply((Artifact)lastest, artifact.version())));
    }

    public static final /* synthetic */ void $anonfun$doDownload$1(ArtifactDownloader $this, IntRef idx$1, Iterable products$1, ConcurrentHashMap statuses$1, ExecutorService executor$1, Product artifact) {
        block0: {
            if ($this.local().file(artifact).exists()) break block0;
            int id = idx$1.elem++;
            RangeDownloader downloader = RangeDownloader$.MODULE$.apply(new StringBuilder(1).append(id).append("/").append(products$1.size()).toString(), $this.remote().url(artifact), $this.local().url(artifact));
            downloader.verbose_$eq($this.verbose());
            downloader.addProperties((Map<String, String>)$this.properties());
            statuses$1.put(downloader.url(), downloader);
            executor$1.execute(() -> {
                try {
                    try {
                        downloader.start();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    statuses$1.remove(downloader.url());
                }
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$doDownload$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public ArtifactDownloader(Repo.Remote remote, Repo.Local local) {
        this.remote = remote;
        this.local = local;
        Logging.$init$((Logging)this);
        this.properties = Collections$.MODULE$.newMap();
        this.verbose = true;
        Statics.releaseFence();
    }
}

