/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.udt;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.beangle.commons.lang.IDEnum;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;

public class IDEnumType
implements EnhancedUserType,
DynamicParameterizedType,
LoggableUserType,
Serializable {
    private Class<? extends IDEnum> enumClass;

    public String objectToSQLString(Object value) {
        return String.valueOf(((IDEnum)value).getId());
    }

    public String toXMLString(Object value) {
        return String.valueOf(((IDEnum)value).getId());
    }

    public Object fromXMLString(String xmlValue) {
        return null;
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        return value.toString();
    }

    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        this.enumClass = reader.getReturnedClass().asSubclass(IDEnum.class);
    }

    public int[] sqlTypes() {
        return new int[]{4};
    }

    public Class<? extends IDEnum> returnedClass() {
        return this.enumClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        int id = rs.getInt(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        for (IDEnum value : this.returnedClass().getEnumConstants()) {
            if (id != value.getId()) continue;
            return value;
        }
        throw new IllegalStateException("unknown enum  " + this.returnedClass().getName() + " id:" + id);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 4);
        } else {
            st.setInt(index, ((IDEnum)value).getId());
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

