/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.inject.Resources;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.text.inflector.Pluralizer;
import org.beangle.commons.text.inflector.en.EnNounPluralizer;
import org.beangle.orm.hibernate.TableNamePattern;
import org.beangle.orm.hibernate.TableNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableNamingStrategy
implements TableNamingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTableNamingStrategy.class);
    private int entityTableMaxLength = 25;
    private int relationTableMaxLength = 30;
    private Pluralizer pluralizer = new EnNounPluralizer();
    private final List<TableNamePattern> patterns = new ArrayList<TableNamePattern>();
    private final Map<String, TableNamePattern> packagePatterns = CollectUtils.newHashMap();

    public void addConfig(URL url) {
        this.loadProperties(url);
        Collections.sort(this.patterns);
    }

    /*
     * WARNING - void declaration
     */
    private void loadProperties(URL url) {
        try {
            logger.debug("loading {}", (Object)url);
            InputStream is = url.openStream();
            Properties props = new Properties();
            if (null != is) {
                props.load(is);
            }
            for (String string : props.keySet()) {
                TableNamePattern pattern;
                void var5_6;
                String schemaPrefix = props.getProperty(string).trim();
                String schema = null;
                String prefix = null;
                String abbreviationStr = null;
                String annotation = null;
                int commaIndex = schemaPrefix.indexOf(44);
                if (commaIndex < 0 || commaIndex + 1 == schemaPrefix.length()) {
                    schema = schemaPrefix;
                } else if (commaIndex == 0) {
                    prefix = schemaPrefix.substring(1);
                } else {
                    schema = Strings.substringBefore((String)schemaPrefix, (String)",");
                    prefix = Strings.substringAfter((String)schemaPrefix, (String)",");
                }
                if (null != System.getProperty("beangle.data.orm.global_schema")) {
                    schema = System.getProperty("beangle.data.orm.global_schema");
                }
                if (Strings.contains(prefix, (CharSequence)",")) {
                    abbreviationStr = Strings.substringAfter((String)prefix, (String)",").toLowerCase();
                    prefix = Strings.substringBefore((String)prefix, (String)",");
                }
                if (string.contains("@")) {
                    annotation = Strings.substringAfter((String)string, (String)"@");
                    String string2 = Strings.substringBefore((String)string, (String)"@");
                }
                String patternKey = var5_6;
                if (null != annotation) {
                    patternKey = (String)patternKey + "@" + Strings.substringAfterLast((String)annotation, (String)".");
                }
                if (null == (pattern = this.packagePatterns.get(patternKey))) {
                    pattern = new TableNamePattern((String)var5_6, schema, prefix);
                    this.packagePatterns.put(patternKey, pattern);
                    this.patterns.add(pattern);
                } else {
                    pattern.setSchema(schema);
                    pattern.setPrefix(prefix);
                }
                if (null != abbreviationStr) {
                    String[] pairs;
                    for (String pair : pairs = Strings.split((String)abbreviationStr, (String)";")) {
                        String longName = Strings.substringBefore((String)pair, (String)"=");
                        String shortName = Strings.substringAfter((String)pair, (String)"=");
                        pattern.abbreviations.put(longName, shortName);
                    }
                }
                if (null == annotation) continue;
                try {
                    pattern.annotation = Class.forName(annotation);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            is.close();
        }
        catch (IOException e) {
            logger.error("property load error", (Throwable)e);
        }
    }

    @Override
    public String getSchema(String clazzName) {
        try {
            TableNamePattern pattern = this.getPattern(Class.forName(clazzName));
            return null == pattern ? null : pattern.schema;
        }
        catch (ClassNotFoundException e) {
            logger.info("Cannot find class " + clazzName);
            return null;
        }
    }

    public TableNamePattern getPattern(Class<?> clazz) {
        TableNamePattern last = null;
        String className = clazz.getName();
        for (TableNamePattern pattern : this.patterns) {
            if (className.indexOf(pattern.getPackageName()) != 0) continue;
            if (null != pattern.annotation) {
                if (!clazz.isAnnotationPresent(pattern.annotation)) continue;
                last = pattern;
                continue;
            }
            last = pattern;
        }
        return last;
    }

    @Override
    public boolean isMultiSchema() {
        Set schemas = CollectUtils.newHashSet();
        for (TableNamePattern pattern : this.patterns) {
            schemas.add(null == pattern.getSchema() ? "" : pattern.getSchema());
        }
        return schemas.size() > 1;
    }

    public List<TableNamePattern> getPatterns() {
        return this.patterns;
    }

    public void setResources(Resources resources) {
        if (null != resources) {
            for (URL url : resources.getAllPaths()) {
                this.addConfig(url);
            }
            logger.info("Table name pattern: -> \n{}", (Object)this);
        }
    }

    public String toString() {
        int maxlength = 0;
        for (TableNamePattern pattern : this.patterns) {
            if (pattern.getPackageName().length() <= maxlength) continue;
            maxlength = pattern.getPackageName().length();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.patterns.size(); ++i) {
            TableNamePattern pattern = this.patterns.get(i);
            Object packageName = pattern.getPackageName();
            if (null != pattern.annotation) {
                packageName = (String)packageName + "@" + pattern.annotation.getSimpleName();
            }
            sb.append(Strings.rightPad((String)packageName, (int)maxlength, (char)' ')).append(" : [").append(pattern.getSchema());
            sb.append(" , ").append(pattern.getPrefix());
            if (!pattern.abbreviations.isEmpty()) {
                sb.append(" , ").append(pattern.abbreviations);
            }
            sb.append(']');
            if (i >= this.patterns.size() - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public String classToTableName(Class<?> clazz) {
        TableNamePattern pattern;
        String className = clazz.getName();
        if (className.endsWith("Bean")) {
            className = Strings.substringBeforeLast((String)className, (String)"Bean");
        }
        Object tableName = DefaultTableNamingStrategy.addUnderscores(DefaultTableNamingStrategy.unqualify(className));
        if (null != this.pluralizer) {
            tableName = this.pluralizer.pluralize((String)tableName);
        }
        if (null != (pattern = this.getPattern(clazz))) {
            tableName = pattern.prefix + (String)tableName;
        }
        if (((String)tableName).length() > this.entityTableMaxLength && null != pattern) {
            for (Map.Entry<String, String> pairEntry : pattern.abbreviations.entrySet()) {
                tableName = Strings.replace((String)tableName, (String)pairEntry.getKey(), (String)pairEntry.getValue());
            }
        }
        return tableName;
    }

    @Override
    public String collectionToTableName(Class<?> entityClass, String tableName, String collectionName) {
        TableNamePattern pattern = this.getPattern(entityClass);
        Object collectionTableName = tableName + "_" + DefaultTableNamingStrategy.addUnderscores(DefaultTableNamingStrategy.unqualify(collectionName));
        if (((String)collectionTableName).length() > this.relationTableMaxLength && null != pattern) {
            for (Map.Entry<String, String> pairEntry : pattern.abbreviations.entrySet()) {
                collectionTableName = Strings.replace((String)collectionTableName, (String)pairEntry.getKey(), (String)pairEntry.getValue());
            }
        }
        return collectionTableName;
    }

    protected static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? qualifiedName : qualifiedName.substring(loc + 1);
    }

    protected static String addUnderscores(String name) {
        return Strings.unCamel((String)name.replace('.', '_'), (char)'_');
    }

    public void setPluralizer(Pluralizer pluralizer) {
        this.pluralizer = pluralizer;
    }

    public void setEntityTableMaxLength(int entityTableMaxLength) {
        this.entityTableMaxLength = entityTableMaxLength;
    }

    public void setRelationTableMaxLength(int relationTableMaxLength) {
        this.relationTableMaxLength = relationTableMaxLength;
    }
}

