/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.udt;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;

public class WeekState
implements Serializable,
Comparable<WeekState> {
    private static final long serialVersionUID = 1L;
    public static final WeekState Zero = new WeekState(0L);
    public final long value;

    public WeekState(long value) {
        this.value = value;
    }

    public static WeekState of(int weekIndex) {
        return new WeekState(1L << weekIndex);
    }

    public static WeekState of(int[] weekIndecies) {
        long v = 0L;
        for (int index : weekIndecies) {
            v |= 1L << index;
        }
        return new WeekState(v);
    }

    public static WeekState of(List<Integer> weekIndecies) {
        long v = 0L;
        for (int index : weekIndecies) {
            v |= 1L << index;
        }
        return new WeekState(v);
    }

    @Override
    public int compareTo(WeekState o) {
        if (this.value > o.value) {
            return -1;
        }
        if (this.value == o.value) {
            return 0;
        }
        return 1;
    }

    public WeekState(String value) {
        this(Long.valueOf(value, 2));
    }

    public int getFirst() {
        String str = this.toString();
        return str.length() - str.lastIndexOf(49) - 1;
    }

    public int getLast() {
        String str = this.toString();
        return str.length() - str.indexOf(49) - 1;
    }

    public int getWeeks() {
        return Strings.count((String)this.toString(), (String)"1");
    }

    public List<Integer> getWeekList() {
        String weekstr = this.toString();
        List weekList = CollectUtils.newArrayList();
        if (this.value > 0L) {
            for (int i = weekstr.length() - 1; i >= 0; --i) {
                if (weekstr.charAt(i) != '1') continue;
                weekList.add(weekstr.length() - i - 1);
            }
            return weekList;
        }
        return Collections.emptyList();
    }

    public boolean isOccupied(int week) {
        return (this.value & 1L << week) > 0L;
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return this.value == ((WeekState)obj).value;
    }

    public WeekState bitand(WeekState other) {
        return new WeekState(this.value & other.value);
    }

    public WeekState bitor(WeekState other) {
        return new WeekState(this.value | other.value);
    }

    public WeekState bitxor(WeekState other) {
        return new WeekState(this.value ^ other.value);
    }

    public String toString() {
        return Long.toBinaryString(this.value);
    }

    public String toReverseString() {
        return new StringBuilder(Long.toBinaryString(this.value)).reverse().toString();
    }
}

