/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.tool;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.beangle.commons.entity.orm.AbstractPersistModule;
import org.beangle.commons.entity.orm.EntityPersistConfig;
import org.beangle.commons.io.IOs;
import org.beangle.commons.lang.ClassLoaders;
import org.beangle.orm.hibernate.DefaultTableNamingStrategy;
import org.beangle.orm.hibernate.RailsNamingStrategy;
import org.beangle.orm.hibernate.tool.DdlGenerator;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ConfigBuilder {
    public static Configuration build(Configuration cfg) throws Exception {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(DdlGenerator.class.getClassLoader());
        DefaultTableNamingStrategy tableNamingStrategy = new DefaultTableNamingStrategy();
        for (Resource resource : resolver.getResources("classpath*:META-INF/beangle/table.properties")) {
            tableNamingStrategy.addConfig(resource.getURL());
        }
        RailsNamingStrategy namingStrategy = new RailsNamingStrategy();
        namingStrategy.setTableNamingStrategy(tableNamingStrategy);
        cfg.setNamingStrategy((NamingStrategy)namingStrategy);
        for (Resource resource : resolver.getResources("classpath*:META-INF/hibernate.cfg.xml")) {
            cfg.configure(resource.getURL());
        }
        for (Resource resource : resolver.getResources("classpath*:META-INF/beangle/persist*.properties")) {
            Object module;
            InputStream is = resource.getURL().openStream();
            Properties props = new Properties();
            if (null != is) {
                props.load(is);
            }
            if (null == (module = props.remove("module"))) continue;
            Class moduleClass = ClassLoaders.loadClass((String)module.toString());
            ConfigBuilder.addPersistInfo(cfg, ((AbstractPersistModule)moduleClass.newInstance()).getConfig());
            Enumeration<?> enumer = props.propertyNames();
            while (enumer.hasMoreElements()) {
                String propertyName = (String)enumer.nextElement();
                cfg.setProperty(propertyName, props.getProperty(propertyName));
            }
            IOs.close((Closeable)is);
        }
        cfg.buildMappings();
        return cfg;
    }

    private static void addPersistInfo(Configuration cfg, EntityPersistConfig epconfig) {
        for (EntityPersistConfig.EntityDefinition definition : epconfig.getEntites()) {
            cfg.addAnnotatedClass(definition.getClazz());
            if (null == definition.getCacheUsage()) continue;
            String region = null == definition.getCacheRegion() ? definition.getEntityName() : definition.getCacheRegion();
            cfg.setCacheConcurrencyStrategy(definition.getEntityName(), definition.getCacheUsage(), region, true);
        }
        for (EntityPersistConfig.EntityDefinition definition : epconfig.getCollections()) {
            if (null == definition.getCacheUsage()) continue;
            String role = epconfig.getEntity(definition.getClazz()).getEntityName() + "." + definition.getProperty();
            Object region = null == definition.getCacheRegion() ? role : definition.getCacheRegion();
            cfg.setCollectionCacheConcurrencyStrategy(role, definition.getCacheUsage(), (String)region);
        }
    }
}

