/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate;

import java.io.Serializable;
import org.beangle.commons.lang.Strings;
import org.beangle.orm.hibernate.TableNamingStrategy;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.NamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailsNamingStrategy
implements NamingStrategy,
Serializable {
    private static final long serialVersionUID = -2656604564223895758L;
    private static final Logger logger = LoggerFactory.getLogger(RailsNamingStrategy.class);
    private static final int MaxLength = 30;
    private TableNamingStrategy tableNamingStrategy;

    public String classToTableName(String className) {
        String tableName = null;
        try {
            tableName = this.tableNamingStrategy.classToTableName(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (tableName.length() > 30) {
            logger.warn("{}'s length greate than 30!", (Object)tableName);
        }
        logger.debug("Mapping entity[{}] to {}", (Object)className, (Object)tableName);
        return tableName;
    }

    public String tableName(String tableName) {
        return tableName;
    }

    public String columnName(String columnName) {
        if (columnName.length() > 30) {
            logger.warn("{}'s length greate than 30!", (Object)columnName);
        }
        return columnName;
    }

    public String logicalColumnName(String columnName, String propertyName) {
        return Strings.isNotEmpty((CharSequence)columnName) ? columnName : this.propertyToColumnName(propertyName);
    }

    public String propertyToColumnName(String propertyName) {
        return RailsNamingStrategy.addUnderscores(RailsNamingStrategy.unqualify(propertyName));
    }

    public String joinKeyColumnName(String joinedColumn, String joinedTable) {
        return this.columnName(joinedColumn);
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        String header;
        String string = header = null == propertyName ? propertyTableName : RailsNamingStrategy.unqualify(propertyName);
        if (header == null) {
            throw new AssertionFailure("NamingStrategy not properly filled");
        }
        header = this.isManyToOne() ? RailsNamingStrategy.addUnderscores(header) : RailsNamingStrategy.addUnderscores(propertyTableName);
        return header + "_" + referencedColumnName;
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        String ownerTable = null;
        Class<?> entityClass = null;
        try {
            entityClass = Class.forName(ownerEntity);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ownerTable = Character.isUpperCase(ownerEntityTable.charAt(0)) ? this.tableNamingStrategy.classToTableName(entityClass) : this.tableName(ownerEntityTable);
        String tblName = this.tableNamingStrategy.collectionToTableName(entityClass, ownerTable, propertyName);
        if (tblName.length() > 30) {
            logger.warn("{}'s length greate than 30!", (Object)tblName);
        }
        return tblName;
    }

    public String logicalCollectionTableName(String tableName, String ownerEntityTable, String associatedEntityTable, String propertyName) {
        if (tableName == null) {
            return ownerEntityTable + "_" + (associatedEntityTable == null ? RailsNamingStrategy.unqualify(propertyName) : associatedEntityTable);
        }
        return tableName;
    }

    public String logicalCollectionColumnName(String columnName, String propertyName, String referencedColumn) {
        return Strings.isNotEmpty((CharSequence)columnName) ? columnName : RailsNamingStrategy.unqualify(propertyName) + "_" + referencedColumn;
    }

    public void setTableNamingStrategy(TableNamingStrategy tableNamingStrategy) {
        this.tableNamingStrategy = tableNamingStrategy;
    }

    public TableNamingStrategy getTableNamingStrategy() {
        return this.tableNamingStrategy;
    }

    protected static String addUnderscores(String name) {
        return Strings.unCamel((String)name.replace('.', '_'), (char)'_');
    }

    protected static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? qualifiedName : qualifiedName.substring(loc + 1);
    }

    private boolean isManyToOne() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length >= 9) {
            for (int i = 6; i <= 8; ++i) {
                if (!trace[i].getClassName().equals("org.hibernate.cfg.ToOneFkSecondPass")) continue;
                return true;
            }
        }
        return false;
    }
}

