/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;

class TableNamePattern
implements Comparable<TableNamePattern> {
    String packageName;
    String schema;
    String prefix;
    Class<? extends Annotation> annotation;
    Map<String, String> abbreviations = CollectUtils.newHashMap();

    public TableNamePattern(String packageName, String schemaName, String prefix) {
        this.packageName = packageName;
        this.schema = schemaName;
        this.prefix = null == prefix ? "" : prefix;
    }

    @Override
    public int compareTo(TableNamePattern other) {
        int rs = this.packageName.compareTo(other.packageName);
        if (rs == 0) {
            if (null != this.annotation && null == other.annotation) {
                return 1;
            }
            if (null == this.annotation && null != other.annotation) {
                return -1;
            }
            return 0;
        }
        return rs;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schemaName) {
        this.schema = schemaName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[package:").append(this.packageName).append(", schema:").append(this.schema);
        sb.append(", prefix:").append(this.prefix).append(']');
        sb.append(", abbreviations:").append(this.abbreviations).append(']');
        return sb.toString();
    }
}

