/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate;

import org.beangle.orm.hibernate.internal.SessionHolder;
import org.beangle.orm.hibernate.internal.SessionUtils;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class SessionSynchronization
implements TransactionSynchronization,
Ordered {
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private boolean holderActive = true;

    public SessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
    }

    private Session getCurrentSession() {
        return this.sessionHolder.getSession();
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.getCurrentSession().disconnect();
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }
    }

    public void flush() {
        try {
            this.getCurrentSession().flush();
        }
        catch (HibernateException ex) {
            throw SessionUtils.convertHibernateAccessException(ex);
        }
    }

    public void beforeCommit(boolean readOnly) throws DataAccessException {
        Session session;
        if (!readOnly && !FlushMode.isManualFlushMode((FlushMode)(session = this.getCurrentSession()).getFlushMode())) {
            try {
                session.flush();
            }
            catch (HibernateException ex) {
                throw SessionUtils.convertHibernateAccessException(ex);
            }
        }
    }

    public void beforeCompletion() {
        Session session = this.sessionHolder.getSession();
        if (this.sessionHolder.getPreviousFlushMode() != null) {
            session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
        }
        session.disconnect();
    }

    public void afterCommit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        try {
            if (status != 0) {
                this.sessionHolder.getSession().clear();
            }
        }
        finally {
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }
}

