/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.beangle.commons.bean.Disposable;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.entity.orm.AbstractPersistModule;
import org.beangle.commons.entity.orm.EntityPersistConfig;
import org.beangle.commons.io.IOs;
import org.beangle.commons.lang.ClassLoaders;
import org.beangle.commons.lang.reflect.Reflections;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.orm.hibernate.BeangleSessionContext;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class SessionFactoryBean
implements FactoryBean<SessionFactory>,
Initializing,
Disposable,
BeanClassLoaderAware {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<? extends Configuration> configurationClass = Configuration.class;
    private DataSource dataSource;
    private Resource staticHbm;
    private Resource[] configLocations;
    private Resource[] persistLocations;
    private NamingStrategy namingStrategy;
    private Properties hibernateProperties;
    private SessionFactory sessionFactory;
    private ClassLoader beanClassLoader = ClassLoaders.getDefaultClassLoader();
    private Configuration configuration;

    public void setConfigLocations(Resource[] configLocations) {
        this.configLocations = configLocations;
    }

    public void setPersistLocations(Resource[] persistLocations) {
        this.persistLocations = persistLocations;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public Properties getHibernateProperties() {
        if (this.hibernateProperties == null) {
            this.hibernateProperties = new Properties();
        }
        return this.hibernateProperties;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    private void staticInit() throws Exception {
        this.configuration.addCacheableFile(this.staticHbm.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dynamicInit() throws Exception {
        if (this.namingStrategy != null) {
            this.configuration.setNamingStrategy(this.namingStrategy);
        }
        if (null != this.configLocations) {
            for (Resource resource : this.configLocations) {
                this.configuration.configure(resource.getURL());
            }
        }
        if (null != this.persistLocations) {
            for (Resource resource : this.persistLocations) {
                Object module;
                InputStream is = resource.getURL().openStream();
                Properties props = new Properties();
                if (null != is) {
                    props.load(is);
                }
                if (null == (module = props.remove("module"))) {
                    this.logger.warn("Cannot find module in {}", (Object)resource.getURL());
                    continue;
                }
                Class moduleClass = ClassLoaders.loadClass((String)module.toString());
                this.addPersistInfo(((AbstractPersistModule)moduleClass.newInstance()).getConfig());
                Enumeration<?> enumer = props.propertyNames();
                while (enumer.hasMoreElements()) {
                    String propertyName = (String)enumer.nextElement();
                    this.configuration.setProperty(propertyName, props.getProperty(propertyName));
                }
                IOs.close((Closeable)is);
            }
        }
    }

    protected void processProperties() {
        if (this.hibernateProperties == null) {
            this.hibernateProperties = new Properties();
        }
        Properties sysProps = System.getProperties();
        Enumeration<?> keys = sysProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("hibernate.")) continue;
            String value = sysProps.getProperty(key);
            boolean override = this.hibernateProperties.containsKey(key);
            this.hibernateProperties.put(key, value);
            if (!override) continue;
            this.logger.info("Override hibernate property {}={}", (Object)key, (Object)value);
        }
        this.configuration.getProperties().put("hibernate.classLoader.application", this.beanClassLoader);
        this.configuration.setProperty("hibernate.current_session_context_class", BeangleSessionContext.class.getName());
        if (this.dataSource != null) {
            this.configuration.getProperties().put("hibernate.connection.datasource", this.dataSource);
        }
        String useJdbcMetaName = "hibernate.temp.use_jdbc_metadata_defaults";
        if (this.hibernateProperties.containsKey("hibernate.dialect") && !this.hibernateProperties.containsKey("hibernate.temp.use_jdbc_metadata_defaults")) {
            this.hibernateProperties.put("hibernate.temp.use_jdbc_metadata_defaults", "false");
        }
        this.configuration.addProperties(this.hibernateProperties);
    }

    public void init() throws Exception {
        boolean staticInit = null != this.staticHbm;
        try {
            this.staticHbm.getFile();
        }
        catch (IOException e) {
            staticInit = false;
        }
        this.configuration = staticInit ? new Configuration() : this.newConfiguration();
        this.processProperties();
        if (staticInit) {
            this.staticInit();
        } else {
            this.dynamicInit();
        }
        Stopwatch watch = new Stopwatch(true);
        final ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings((Map)this.configuration.getProperties()).buildServiceRegistry();
        this.configuration.setSessionFactoryObserver(new SessionFactoryObserver(){
            private static final long serialVersionUID = 1L;

            public void sessionFactoryCreated(SessionFactory factory) {
            }

            public void sessionFactoryClosed(SessionFactory factory) {
                ServiceRegistryBuilder.destroy((ServiceRegistry)serviceRegistry);
            }
        });
        this.sessionFactory = this.configuration.buildSessionFactory(serviceRegistry);
        this.logger.info("Building Hibernate SessionFactory in {}", (Object)watch);
    }

    private void addPersistInfo(EntityPersistConfig epconfig) {
        for (EntityPersistConfig.EntityDefinition definition : epconfig.getEntites()) {
            this.configuration.addAnnotatedClass(definition.getClazz());
            this.logger.debug("Add annotation {}", (Object)definition.getClazz());
            if (null == definition.getCacheUsage()) continue;
            String region = null == definition.getCacheRegion() ? definition.getEntityName() : definition.getCacheRegion();
            this.configuration.setCacheConcurrencyStrategy(definition.getEntityName(), definition.getCacheUsage(), region, true);
        }
        for (EntityPersistConfig.EntityDefinition definition : epconfig.getCollections()) {
            if (null == definition.getCacheUsage()) continue;
            String role = epconfig.getEntity(definition.getClazz()).getEntityName() + "." + definition.getProperty();
            String region = null == definition.getCacheRegion() ? role : definition.getCacheRegion();
            this.configuration.setCollectionCacheConcurrencyStrategy(role, definition.getCacheUsage(), region);
        }
    }

    protected Configuration newConfiguration() throws HibernateException {
        return (Configuration)Reflections.newInstance(this.configurationClass);
    }

    public void destroy() throws HibernateException {
        this.logger.info("Closing Hibernate SessionFactory");
        this.sessionFactory.close();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public SessionFactory getObject() {
        return this.sessionFactory;
    }

    public Class<? extends SessionFactory> getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : SessionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setConfigurationClass(Class<? extends Configuration> configurationClass) {
        this.configurationClass = configurationClass;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setStaticHbm(Resource staticHbm) {
        this.staticHbm = staticHbm;
    }
}

