/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate;

import org.beangle.orm.hibernate.SessionSynchronization;
import org.beangle.orm.hibernate.internal.SessionHolder;
import org.beangle.orm.hibernate.internal.SessionUtils;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class BeangleSessionContext
implements CurrentSessionContext {
    private final SessionFactoryImplementor sessionFactory;

    public BeangleSessionContext(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Session currentSession() throws HibernateException {
        SessionHolder sessionHolder = SessionUtils.currentSession((SessionFactory)this.sessionFactory);
        Session session = sessionHolder.getSession();
        if (TransactionSynchronizationManager.isSynchronizationActive() && !sessionHolder.isSynchronizedWithTransaction()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SessionSynchronization(sessionHolder, (SessionFactory)this.sessionFactory));
            sessionHolder.setSynchronizedWithTransaction(true);
            FlushMode flushMode = session.getFlushMode();
            if (FlushMode.isManualFlushMode((FlushMode)flushMode) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                session.setFlushMode(FlushMode.AUTO);
                sessionHolder.setPreviousFlushMode(flushMode);
            }
        }
        return session;
    }
}

