/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.tool;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.orm.hibernate.SessionFactoryBean;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorAggregator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator {
    private static final Logger logger = LoggerFactory.getLogger(SchemaValidator.class);
    private SessionFactoryBean sessionFactoryBean;
    private StringBuilder reporter = new StringBuilder();

    public String validate() {
        Connection connection = null;
        try {
            connection = this.sessionFactoryBean.getDataSource().getConnection();
            logger.info("fetching database metadata");
            Configuration config = this.sessionFactoryBean.getConfiguration();
            Dialect dialect = Dialect.getDialect((Properties)this.sessionFactoryBean.getHibernateProperties());
            DatabaseMetadata meta = new DatabaseMetadata(connection, dialect, config, false);
            String string = this.validateSchema(config, dialect, meta);
            return string;
        }
        catch (SQLException sqle) {
            logger.error("could not get database metadata", (Throwable)sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String validateSchema(Configuration config, Dialect dialect, DatabaseMetadata databaseMetadata) {
        String defaultCatalog = this.sessionFactoryBean.getHibernateProperties().getProperty("hibernate.default_catalog");
        String defaultSchema = this.sessionFactoryBean.getHibernateProperties().getProperty("hibernate.default_schema");
        Mapping mapping = config.buildMapping();
        Iterator<IdentifierGenerator> iter = config.getTableMappings();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            TableMetadata tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema() == null ? defaultSchema : table.getSchema(), table.getCatalog() == null ? defaultCatalog : table.getCatalog(), table.isQuoted());
            if (tableInfo == null) {
                this.reporter.append("Missing table: " + table.getName() + "\n");
                continue;
            }
            this.validateColumns(table, dialect, mapping, tableInfo);
        }
        iter = this.iterateGenerators(config, dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            throw new HibernateException("Missing sequence or table: " + key);
        }
        return null;
    }

    private void validateColumns(Table table, Dialect dialect, Mapping mapping, TableMetadata tableInfo) {
        Iterator iter = table.getColumnIterator();
        Set processed = CollectUtils.newHashSet();
        String tableName = Table.qualify((String)tableInfo.getCatalog(), (String)tableInfo.getSchema(), (String)tableInfo.getName());
        while (iter.hasNext()) {
            boolean typesMatch;
            Column col = (Column)iter.next();
            ColumnMetadata columnInfo = tableInfo.getColumnMetadata(col.getName());
            if (columnInfo == null) {
                this.reporter.append("Missing column: " + col.getName() + " in " + tableName);
                continue;
            }
            boolean bl = typesMatch = col.getSqlType(dialect, mapping).toLowerCase().startsWith(columnInfo.getTypeName().toLowerCase()) || columnInfo.getTypeCode() == col.getSqlTypeCode(mapping);
            if (!typesMatch) {
                this.reporter.append("Wrong column type in " + tableName + " for column " + col.getName() + ". Found: " + columnInfo.getTypeName().toLowerCase() + ", expected: " + col.getSqlType(dialect, mapping));
            }
            processed.add(columnInfo);
        }
        try {
            Field field = tableInfo.getClass().getField("columns");
            Set allColumns = CollectUtils.newHashSet(((Map)field.get(tableInfo)).values());
            allColumns.removeAll(processed);
            if (!allColumns.isEmpty()) {
                for (ColumnMetadata col : allColumns) {
                    this.reporter.append("Extra column " + col.getName() + " in " + tableName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Iterator<IdentifierGenerator> iterateGenerators(Configuration config, Dialect dialect) throws MappingException {
        IdentifierGenerator ig;
        TreeMap<Object, IdentifierGenerator> generators = new TreeMap<Object, IdentifierGenerator>();
        String defaultCatalog = this.sessionFactoryBean.getHibernateProperties().getProperty("hibernate.default_catalog");
        String defaultSchema = this.sessionFactoryBean.getHibernateProperties().getProperty("hibernate.default_schema");
        Iterator pcIter = config.getClassMappings();
        while (pcIter.hasNext()) {
            PersistentClass pc = (PersistentClass)pcIter.next();
            if (pc.isInherited()) continue;
            ig = pc.getIdentifier().createIdentifierGenerator((IdentifierGeneratorFactory)config.getIdentifierGeneratorFactory(), dialect, defaultCatalog, defaultSchema, (RootClass)pc);
            if (ig instanceof PersistentIdentifierGenerator) {
                generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
                continue;
            }
            if (!(ig instanceof IdentifierGeneratorAggregator)) continue;
            ((IdentifierGeneratorAggregator)ig).registerPersistentGenerators(generators);
        }
        Iterator collIter = config.getCollectionMappings();
        while (collIter.hasNext()) {
            Collection collection = (Collection)collIter.next();
            if (!collection.isIdentified() || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator((IdentifierGeneratorFactory)config.getIdentifierGeneratorFactory(), dialect, defaultCatalog, defaultSchema, null)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }

    public void setSessionFactoryBean(SessionFactoryBean sessionFactoryBean) {
        this.sessionFactoryBean = sessionFactoryBean;
    }
}

