/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.tool;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.orm.hibernate.internal.OverrideConfiguration;
import org.beangle.orm.hibernate.tool.ConfigBuilder;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.type.CustomType;
import org.hibernate.type.EnumType;
import org.hibernate.type.Type;

public class HbmGenerator {
    private org.hibernate.cfg.Configuration hbconfig = null;
    private Configuration freemarkerConfig;

    public void gen(String file) throws Exception {
        this.hbconfig = new OverrideConfiguration();
        this.hbconfig.getProperties().put("hibernate.dialect", new Oracle10gDialect());
        ConfigBuilder.build(this.hbconfig);
        this.freemarkerConfig = new Configuration();
        this.freemarkerConfig.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/"));
        Iterator iter = this.hbconfig.getClassMappings();
        List pcs = CollectUtils.newArrayList();
        while (iter.hasNext()) {
            PersistentClass pc = (PersistentClass)iter.next();
            Class cls = pc.getMappedClass();
            Iterator pi = pc.getPropertyIterator();
            while (pi.hasNext()) {
                NotNull notnull;
                Size size;
                Property p = (Property)pi.next();
                if (p.getColumnSpan() != 1) continue;
                Column column = (Column)p.getColumnIterator().next();
                if (column.getLength() == 255 && (size = this.findAnnotation(cls, Size.class, p.getName())) != null) {
                    column.setLength(size.max());
                }
                if (!column.isNullable() || (notnull = this.findAnnotation(cls, NotNull.class, p.getName())) == null) continue;
                column.setNullable(false);
            }
            if (pc.getClassName().contains(".example.")) continue;
            pcs.add(pc);
        }
        Map data = CollectUtils.newHashMap();
        data.put("classes", pcs);
        data.put("generator", this);
        Template freemarkerTemplate = this.freemarkerConfig.getTemplate("/hbm.ftl");
        FileWriter fw = new FileWriter("/tmp/hibernate.hbm.xml");
        freemarkerTemplate.process((Object)data, (Writer)fw);
    }

    private <T extends Annotation> T findAnnotation(Class<?> cls, Class<T> annotationClass, String name) {
        Class<?> curr = cls;
        T ann = null;
        while (ann == null && curr != null && !curr.equals(Object.class)) {
            ann = this.findAnnotationLocal(curr, annotationClass, name);
            curr = curr.getSuperclass();
        }
        return ann;
    }

    private <T extends Annotation> T findAnnotationLocal(Class<?> cls, Class<T> annotationClass, String name) {
        T ann = null;
        try {
            Field field = cls.getDeclaredField(name);
            ann = field.getAnnotation(annotationClass);
        }
        catch (Exception field) {
            // empty catch block
        }
        if (ann == null) {
            Method method = null;
            try {
                method = cls.getMethod("get" + Strings.capitalize((String)name), new Class[0]);
                ann = method.getAnnotation(annotationClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ann == null && method == null) {
                try {
                    method = cls.getMethod("is" + Strings.capitalize((String)name), new Class[0]);
                    ann = method.getAnnotation(annotationClass);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ann;
    }

    public boolean isToOne(Value value) {
        return value instanceof ToOne;
    }

    public boolean isOneToMany(Value value) {
        return value instanceof OneToMany;
    }

    public boolean isManyToMany(Value value) {
        return value instanceof ManyToOne;
    }

    public boolean isCollection(Value value) {
        return value instanceof Collection;
    }

    public boolean isSet(Value value) {
        return value instanceof Set;
    }

    public boolean isCustomType(Type type) {
        return type instanceof CustomType;
    }

    public boolean isEnumType(CustomType type) {
        return type.getUserType() instanceof EnumType;
    }

    public static void main(String[] args) throws Exception {
        new HbmGenerator().gen("/tmp");
    }
}

