/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.tool;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.comment.Messages;
import org.beangle.commons.lang.ClassLoaders;
import org.beangle.commons.lang.Locales;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.SystemInfo;
import org.beangle.orm.hibernate.internal.OverrideConfiguration;
import org.beangle.orm.hibernate.tool.ConfigBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;

public class DdlGenerator {
    private Configuration configuration = null;
    private Dialect dialect;
    private List<String> tables = new ArrayList<String>(50);
    private List<String> sequences = new ArrayList<String>(50);
    private List<String> comments = new ArrayList<String>(50);
    private List<String> constraints = new ArrayList<String>(50);
    private List<String> indexes = new ArrayList<String>(50);
    private Messages messages;
    private String defaultCatalog;
    private String defaultSchema;
    private Mapping mapping;
    private Set<Table> processed = CollectUtils.newHashSet();
    private Map<String, List<List<String>>> files = CollectUtils.newHashMap();

    public DdlGenerator(Dialect dialect, Locale locale) {
        this.dialect = dialect;
        this.messages = Messages.build((Locale)locale);
        this.files.put("1-tables.sql", Arrays.asList(this.tables, this.constraints, this.indexes));
        this.files.put("2-sequences.sql", Arrays.asList(this.sequences));
        this.files.put("3-comments.sql", Arrays.asList(this.comments));
    }

    public void gen(String fileName, String packageName) throws Exception {
        String[] lines;
        IdentifierGenerator ig;
        this.configuration = ConfigBuilder.build(new OverrideConfiguration());
        this.mapping = this.configuration.buildMapping();
        this.defaultCatalog = this.configuration.getProperties().getProperty("hibernate.default_catalog");
        this.defaultSchema = this.configuration.getProperties().getProperty("hibernate.default_schema");
        this.configuration.getProperties().put("hibernate.dialect", this.dialect);
        Iterator iterpc = this.configuration.getClassMappings();
        while (iterpc.hasNext()) {
            PersistentClass pc = (PersistentClass)iterpc.next();
            Class clazz = pc.getMappedClass();
            if (Strings.isNotBlank((CharSequence)packageName) && !clazz.getPackage().getName().startsWith(packageName)) continue;
            pc.getTable().setComment(this.messages.get(clazz, clazz.getSimpleName()));
            this.commentProperty(clazz, pc.getTable(), pc.getIdentifierProperty());
            this.commentProperties(clazz, pc.getTable(), pc.getPropertyIterator());
            if (pc instanceof RootClass && (ig = pc.getIdentifier().createIdentifierGenerator((IdentifierGeneratorFactory)this.configuration.getIdentifierGeneratorFactory(), this.dialect, this.defaultCatalog, this.defaultSchema, (RootClass)pc)) instanceof PersistentIdentifierGenerator) {
                lines = ((PersistentIdentifierGenerator)ig).sqlCreateStrings(this.dialect);
                this.sequences.addAll(Arrays.asList(lines));
            }
            this.generateTableSql(pc.getTable());
        }
        Iterator itercm = this.configuration.getCollectionMappings();
        while (itercm.hasNext()) {
            IndexedCollection idxCol;
            Value idx;
            Collection col = (Collection)itercm.next();
            if (Strings.isNotBlank((CharSequence)packageName) && !col.getRole().startsWith(packageName)) continue;
            if (col.isIdentified() && (ig = ((IdentifierCollection)col).getIdentifier().createIdentifierGenerator((IdentifierGeneratorFactory)this.configuration.getIdentifierGeneratorFactory(), this.dialect, this.defaultCatalog, this.defaultSchema, null)) instanceof PersistentIdentifierGenerator) {
                lines = ((PersistentIdentifierGenerator)ig).sqlCreateStrings(this.dialect);
                this.sequences.addAll(Arrays.asList(lines));
            }
            if (col.isOneToMany()) continue;
            Table table = col.getCollectionTable();
            String owner = col.getTable().getComment();
            Class<?> ownerClass = col.getOwner().getMappedClass();
            String colName = Strings.substringAfter((String)col.getRole(), (String)(String.valueOf(col.getOwnerEntityName()) + "."));
            if (colName.contains(".")) {
                ownerClass = this.getPropertyType(col.getOwner(), Strings.substringBeforeLast((String)colName, (String)"."));
            }
            table.setComment(String.valueOf(owner) + "-" + this.messages.get(ownerClass, Strings.substringAfterLast((String)col.getRole(), (String)".")));
            Column keyColumn = table.getColumn((Column)col.getKey().getColumnIterator().next());
            if (keyColumn != null) {
                keyColumn.setComment(String.valueOf(owner) + " ID");
            }
            if (col instanceof IndexedCollection && (idx = (idxCol = (IndexedCollection)col).getIndex()) instanceof ToOne) {
                this.commentToOne((ToOne)idx, (Column)idx.getColumnIterator().next());
            }
            if (col.getElement() instanceof ManyToOne) {
                Column valueColumn = (Column)col.getElement().getColumnIterator().next();
                this.commentToOne((ToOne)((ManyToOne)col.getElement()), valueColumn);
            } else if (col.getElement() instanceof Component) {
                Component cp = (Component)col.getElement();
                this.commentProperties(cp.getComponentClass(), table, cp.getPropertyIterator());
            }
            this.generateTableSql(col.getCollectionTable());
        }
        Set commentSet = CollectUtils.newHashSet(this.comments);
        this.comments.clear();
        this.comments.addAll(commentSet);
        for (String key : this.files.keySet()) {
            List<List<String>> sqls = this.files.get(key);
            FileWriter writer = new FileWriter(String.valueOf(fileName) + "/" + key, false);
            this.writes(writer, sqls);
            writer.flush();
            writer.close();
        }
    }

    private Class<?> getPropertyType(PersistentClass pc, String propertyString) {
        String[] properties = Strings.split((String)propertyString, (char)'.');
        Property p = pc.getProperty(properties[0]);
        Component cp = (Component)p.getValue();
        int i = 1;
        while (i < properties.length) {
            p = cp.getProperty(properties[i]);
            cp = (Component)p.getValue();
            ++i;
        }
        return cp.getComponentClass();
    }

    private void commentToOne(ToOne toOne, Column column) {
        String entityName = toOne.getReferencedEntityName();
        PersistentClass referClass = this.configuration.getClassMapping(entityName);
        if (referClass != null) {
            column.setComment(String.valueOf(referClass.getTable().getComment()) + " ID");
        }
    }

    private void commentProperty(Class<?> clazz, Table table, Property p) {
        if (p == null) {
            return;
        }
        if (p.getColumnSpan() == 1) {
            Column column = (Column)p.getColumnIterator().next();
            if (this.isForeignColumn(table, column)) {
                column.setComment(String.valueOf(this.messages.get(clazz, p.getName())) + " ID");
            } else {
                column.setComment(this.messages.get(clazz, p.getName()));
            }
        } else if (p.getColumnSpan() > 1) {
            Component pc = (Component)p.getValue();
            Class columnOwnerClass = pc.getComponentClass();
            this.commentProperties(columnOwnerClass, table, pc.getPropertyIterator());
        }
    }

    private void commentProperties(Class<?> clazz, Table table, Iterator<Property> ip) {
        while (ip.hasNext()) {
            this.commentProperty(clazz, table, ip.next());
        }
    }

    private void generateTableSql(Table table) {
        if (!table.isPhysicalTable()) {
            return;
        }
        Iterator commentIter = table.sqlCommentStrings(this.dialect, this.defaultCatalog, this.defaultSchema);
        while (commentIter.hasNext()) {
            this.comments.add((String)commentIter.next());
        }
        if (this.processed.contains(table)) {
            return;
        }
        this.processed.add(table);
        this.tables.add(table.sqlCreateString(this.dialect, this.mapping, this.defaultCatalog, this.defaultSchema));
        Iterator subIter = table.getUniqueKeyIterator();
        while (subIter.hasNext()) {
            UniqueKey uk = (UniqueKey)subIter.next();
            String constraintString = uk.sqlCreateString(this.dialect, this.mapping, this.defaultCatalog, this.defaultSchema);
            if (constraintString == null) continue;
            this.constraints.add(constraintString);
        }
        Iterator idxIter = table.getIndexIterator();
        while (idxIter.hasNext()) {
            Index index = (Index)idxIter.next();
            this.indexes.add(index.sqlCreateString(this.dialect, this.mapping, this.defaultCatalog, this.defaultSchema));
        }
        if (this.dialect.hasAlterTable()) {
            Iterator fkIter = table.getForeignKeyIterator();
            while (fkIter.hasNext()) {
                ForeignKey fk = (ForeignKey)fkIter.next();
                if (!fk.isPhysicalConstraint()) continue;
                this.constraints.add(fk.sqlCreateString(this.dialect, this.mapping, this.defaultCatalog, this.defaultSchema));
            }
        }
    }

    private boolean isForeignColumn(Table table, Column column) {
        Iterator fkIter = table.getForeignKeyIterator();
        while (fkIter.hasNext()) {
            ForeignKey fk = (ForeignKey)fkIter.next();
            if (!fk.isPhysicalConstraint() || !fk.getColumns().contains(column)) continue;
            return true;
        }
        return false;
    }

    private void writes(Writer writer, List<List<String>> contentList) throws IOException {
        for (List<String> contents : contentList) {
            Collections.sort(contents);
            for (String script : contents) {
                writer.write(script);
                writer.write(";\n");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Usage: DdlGenerator org.hibernate.dialect.Oracle10gDialect /tmp zh_CN");
            return;
        }
        String dir = SystemInfo.getTmpDir();
        if (args.length > 1) {
            dir = args[1];
        }
        Locale locale = Locale.getDefault();
        if (args.length > 2) {
            locale = Locales.toLocale((String)args[2]);
        }
        String pattern = null;
        if (args.length > 3) {
            pattern = args[3];
        }
        new DdlGenerator((Dialect)ClassLoaders.loadClass((String)args[0]).newInstance(), locale).gen(dir, pattern);
    }
}

