/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.tool;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.beangle.commons.entity.orm.AbstractPersistModule;
import org.beangle.commons.entity.orm.EntityPersistConfig;
import org.beangle.commons.io.IOs;
import org.beangle.commons.lang.ClassLoaders;
import org.beangle.orm.hibernate.DefaultTableNamingStrategy;
import org.beangle.orm.hibernate.RailsNamingStrategy;
import org.beangle.orm.hibernate.tool.DdlGenerator;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ConfigBuilder {
    public static Configuration build(Configuration cfg) throws Exception {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(DdlGenerator.class.getClassLoader());
        DefaultTableNamingStrategy tableNamingStrategy = new DefaultTableNamingStrategy();
        Resource[] resourceArray = resolver.getResources("classpath*:META-INF/beangle/table.properties");
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            tableNamingStrategy.addConfig(resource.getURL());
            ++n2;
        }
        RailsNamingStrategy namingStrategy = new RailsNamingStrategy();
        namingStrategy.setTableNamingStrategy(tableNamingStrategy);
        cfg.setNamingStrategy((NamingStrategy)namingStrategy);
        Resource[] resourceArray2 = resolver.getResources("classpath*:META-INF/hibernate.cfg.xml");
        int n3 = resourceArray2.length;
        n = 0;
        while (n < n3) {
            Resource resource = resourceArray2[n];
            cfg.configure(resource.getURL());
            ++n;
        }
        resourceArray2 = resolver.getResources("classpath*:META-INF/beangle/persist*.properties");
        n3 = resourceArray2.length;
        n = 0;
        while (n < n3) {
            Object module;
            Resource resource = resourceArray2[n];
            InputStream is = resource.getURL().openStream();
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
            }
            if ((module = props.remove("module")) != null) {
                Class moduleClass = ClassLoaders.loadClass((String)module.toString());
                ConfigBuilder.addPersistInfo(cfg, ((AbstractPersistModule)moduleClass.newInstance()).getConfig());
                Enumeration<?> enumer = props.propertyNames();
                while (enumer.hasMoreElements()) {
                    String propertyName = (String)enumer.nextElement();
                    cfg.setProperty(propertyName, props.getProperty(propertyName));
                }
                IOs.close((Closeable)is);
            }
            ++n;
        }
        cfg.buildMappings();
        return cfg;
    }

    private static void addPersistInfo(Configuration cfg, EntityPersistConfig epconfig) {
        for (EntityPersistConfig.EntityDefinition definition : epconfig.getEntites()) {
            cfg.addAnnotatedClass(definition.getClazz());
            if (definition.getCacheUsage() == null) continue;
            String region = definition.getCacheRegion() == null ? definition.getEntityName() : definition.getCacheRegion();
            cfg.setCacheConcurrencyStrategy(definition.getEntityName(), definition.getCacheUsage(), region, true);
        }
        for (EntityPersistConfig.EntityDefinition definition : epconfig.getCollections()) {
            if (definition.getCacheUsage() == null) continue;
            String role = String.valueOf(epconfig.getEntity(definition.getClazz()).getEntityName()) + "." + definition.getProperty();
            String region = definition.getCacheRegion() == null ? role : definition.getCacheRegion();
            cfg.setCollectionCacheConcurrencyStrategy(role, definition.getCacheUsage(), region);
        }
    }
}

