/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.internal;

import java.util.Map;
import javax.sql.DataSource;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.orm.hibernate.internal.SessionHolder;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PropertyValueException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.UncategorizedDataAccessException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class SessionUtils {
    private static Logger logger = LoggerFactory.getLogger(SessionUtils.class);
    private static final ThreadLocal<Map<SessionFactory, Boolean>> threadBinding = new ThreadLocal();

    public static DataSource getDataSource(SessionFactory factory) {
        SessionFactoryImplementor factoryImpl = (SessionFactoryImplementor)factory;
        if (MultiTenancyStrategy.NONE == factoryImpl.getSettings().getMultiTenancyStrategy()) {
            return (DataSource)((ConnectionProvider)factoryImpl.getServiceRegistry().getService(ConnectionProvider.class)).unwrap(DataSource.class);
        }
        return (DataSource)((MultiTenantConnectionProvider)factoryImpl.getServiceRegistry().getService(MultiTenantConnectionProvider.class)).unwrap(DataSource.class);
    }

    public static void enableBinding(SessionFactory factory) {
        Map maps = threadBinding.get();
        if (maps == null) {
            maps = CollectUtils.newHashMap();
            threadBinding.set(maps);
        }
        maps.put(factory, Boolean.TRUE);
    }

    public static boolean isEnableBinding(SessionFactory factory) {
        Map<SessionFactory, Boolean> maps = threadBinding.get();
        if (maps == null) {
            return false;
        }
        return maps.get(factory) != null;
    }

    public static void disableBinding(SessionFactory factory) {
        Map<SessionFactory, Boolean> maps = threadBinding.get();
        if (maps != null) {
            maps.remove(factory);
        }
    }

    public static SessionHolder openSession(SessionFactory factory) throws DataAccessResourceFailureException, IllegalStateException {
        try {
            SessionHolder holder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)factory));
            Session session = null;
            if (holder == null) {
                session = factory.openSession();
                session.setFlushMode(FlushMode.MANUAL);
                holder = new SessionHolder(session);
                if (SessionUtils.isEnableBinding(factory)) {
                    TransactionSynchronizationManager.bindResource((Object)factory, (Object)((Object)holder));
                }
            }
            return holder;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
    }

    public static SessionHolder currentSession(SessionFactory factory) {
        return (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)factory));
    }

    public static void closeSession(SessionFactory factory) {
        try {
            SessionHolder holder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)factory));
            if (holder != null) {
                TransactionSynchronizationManager.unbindResource((Object)factory);
                holder.getSession().close();
            }
        }
        catch (HibernateException ex) {
            logger.debug("Could not close Hibernate Session", (Throwable)ex);
        }
        catch (Throwable ex) {
            logger.debug("Unexpected exception on closing Hibernate Session", ex);
        }
    }

    public static void closeSession(Session session) {
        try {
            SessionHolder holder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)session.getSessionFactory()));
            if (holder != null) {
                TransactionSynchronizationManager.unbindResource((Object)session.getSessionFactory());
            }
            session.close();
        }
        catch (HibernateException ex) {
            logger.debug("Could not close Hibernate Session", (Throwable)ex);
        }
        catch (Throwable ex) {
            logger.debug("Unexpected exception on closing Hibernate Session", ex);
        }
    }

    public static String toString(Session session) {
        return String.valueOf(session.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(session));
    }

    public static DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SQLGrammarException) {
            SQLGrammarException jdbcEx = (SQLGrammarException)ex;
            return new InvalidDataAccessResourceUsageException(String.valueOf(ex.getMessage()) + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof LockAcquisitionException) {
            LockAcquisitionException jdbcEx = (LockAcquisitionException)ex;
            return new CannotAcquireLockException(String.valueOf(ex.getMessage()) + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException jdbcEx = (ConstraintViolationException)ex;
            return new DataIntegrityViolationException(String.valueOf(ex.getMessage()) + "; SQL [" + jdbcEx.getSQL() + "]; constraint [" + jdbcEx.getConstraintName() + "]", (Throwable)ex);
        }
        if (ex instanceof DataException) {
            DataException jdbcEx = (DataException)ex;
            return new DataIntegrityViolationException(String.valueOf(ex.getMessage()) + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof NonUniqueObjectException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        return new UncategorizedDataAccessException(ex.getMessage(), ex){};
    }
}

