/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.internal;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Entity;
import org.beangle.orm.hibernate.internal.OverrideConfiguration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistentClassMerger {
    private static Logger logger = LoggerFactory.getLogger(OverrideConfiguration.class);
    private static Field subPropertyField = PersistentClassMerger.getField("subclassProperties");
    private static Field declarePropertyField = PersistentClassMerger.getField("declaredProperties");
    private static Field subclassField = PersistentClassMerger.getField("subclasses");
    private static final boolean mergeSupport = subPropertyField != null && declarePropertyField != null && subclassField != null;

    PersistentClassMerger() {
    }

    private static Field getField(String name) {
        try {
            Field field = PersistentClass.class.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            logger.error("Cannot access PersistentClass " + name + " field ,Override Mapping will be disabled", (Throwable)e);
            return null;
        }
    }

    public static void merge(PersistentClass sub, PersistentClass parent) {
        if (!mergeSupport) {
            throw new RuntimeException("Merge not supported!");
        }
        String className = sub.getClassName();
        MappedSuperclass msc = new MappedSuperclass(parent.getSuperMappedSuperclass(), null);
        Class parentClass = parent.getMappedClass();
        msc.setMappedClass(parentClass);
        parent.setSuperMappedSuperclass(msc);
        parent.setClassName(className);
        parent.setProxyInterfaceName(className);
        if (parent instanceof RootClass && !parentClass.getSuperclass().isAnnotationPresent(Entity.class)) {
            ((RootClass)parent).setDiscriminator(null);
            ((RootClass)parent).setPolymorphic(false);
            Iterator iter = parent.getTable().getColumnIterator();
            while (iter.hasNext()) {
                if (!((Column)iter.next()).getName().equalsIgnoreCase("dtype")) continue;
                iter.remove();
                break;
            }
        }
        try {
            List declareProperties = (List)declarePropertyField.get(parent);
            for (Property p : declareProperties) {
                msc.addDeclaredProperty(p);
            }
            ((List)subPropertyField.get(parent)).clear();
            ((List)subclassField.get(parent)).clear();
        }
        catch (Exception declareProperties) {
            // empty catch block
        }
        try {
            Iterator pIter = sub.getPropertyIterator();
            while (pIter.hasNext()) {
                Property p;
                p = (Property)pIter.next();
                parent.addProperty(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info("{} replace {}.", (Object)sub.getClassName(), (Object)parent.getClassName());
    }

    public static boolean isMergesupport() {
        return mergeSupport;
    }
}

