/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.CollectionType;
import org.beangle.commons.entity.metadata.ComponentType;
import org.beangle.commons.entity.metadata.EntityType;
import org.beangle.commons.entity.metadata.IdentifierType;
import org.beangle.commons.entity.metadata.impl.AbstractEntityContext;
import org.beangle.commons.lang.time.Stopwatch;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.MapType;
import org.hibernate.type.SetType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class HibernateEntityContext
extends AbstractEntityContext {
    private final Logger logger = LoggerFactory.getLogger(HibernateEntityContext.class);
    private final Map<String, CollectionType> collectionTypes = CollectUtils.newHashMap();

    public String getEntityName(Object target) {
        if (target instanceof HibernateProxy) {
            return ((HibernateProxy)target).getHibernateLazyInitializer().getEntityName();
        }
        return this.getEntityType(target.getClass()).getEntityName();
    }

    public void initFrom(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory);
        Stopwatch watch = new Stopwatch().start();
        Map classMetadatas = sessionFactory.getAllClassMetadata();
        int entityCount = this.entityTypes.size();
        int collectionCount = this.collectionTypes.size();
        for (ClassMetadata cm : classMetadatas.values()) {
            this.buildEntityType(sessionFactory, cm.getEntityName());
        }
        this.logger.info("Find {} entities,{} collections from hibernate in {}", new Object[]{this.entityTypes.size() - entityCount, this.collectionTypes.size() - collectionCount, watch});
        if (this.logger.isDebugEnabled()) {
            this.loggerTypeInfo();
        }
        this.collectionTypes.clear();
    }

    private void loggerTypeInfo() {
        List names = CollectUtils.newArrayList(this.entityTypes.keySet());
        Collections.sort(names);
        for (String entityName : names) {
            EntityType entityType = (EntityType)this.entityTypes.get(entityName);
            this.logger.debug("entity:{}-->{}", (Object)entityType.getEntityName(), (Object)entityType.getEntityClass().getName());
            this.logger.debug("propertyType size:{}", (Object)entityType.getPropertyTypes().size());
        }
        names.clear();
        names.addAll(this.collectionTypes.keySet());
        Collections.sort(names);
        for (String collectionName : names) {
            CollectionType collectionType = this.collectionTypes.get(collectionName);
            this.logger.debug("collection:{}", (Object)collectionType.getName());
            this.logger.debug("class:{}", (Object)collectionType.getCollectionClass());
            this.logger.debug("elementType:{}", (Object)collectionType.getElementType().getReturnedClass());
        }
    }

    private EntityType buildEntityType(SessionFactory sessionFactory, String entityName) {
        EntityType entityType = (EntityType)this.entityTypes.get(entityName);
        if (entityType == null) {
            ClassMetadata cm = sessionFactory.getClassMetadata(entityName);
            if (cm == null) {
                this.logger.error("Cannot find ClassMetadata for {}", (Object)entityName);
                return null;
            }
            entityType = new EntityType(cm.getEntityName(), cm.getMappedClass(), cm.getIdentifierPropertyName(), (org.beangle.commons.entity.metadata.Type)new IdentifierType(cm.getIdentifierType().getReturnedClass()));
            this.entityTypes.put(cm.getEntityName(), entityType);
            Map propertyTypes = entityType.getPropertyTypes();
            String[] ps = cm.getPropertyNames();
            int i = 0;
            while (i < ps.length) {
                Type type = cm.getPropertyType(ps[i]);
                if (type.isEntityType()) {
                    propertyTypes.put(ps[i], this.buildEntityType(sessionFactory, type.getName()));
                } else if (type.isComponentType()) {
                    propertyTypes.put(ps[i], this.buildComponentType(sessionFactory, entityName, ps[i]));
                } else if (type.isCollectionType()) {
                    propertyTypes.put(ps[i], this.buildCollectionType(sessionFactory, this.defaultCollectionClass(type), String.valueOf(entityName) + "." + ps[i]));
                }
                ++i;
            }
        }
        return entityType;
    }

    private CollectionType buildCollectionType(SessionFactory sessionFactory, Class<?> collectionClass, String role) {
        CollectionMetadata cm = sessionFactory.getCollectionMetadata(role);
        if (cm == null) {
            return null;
        }
        Type type = cm.getElementType();
        EntityType elementType = null;
        if (type.isEntityType()) {
            elementType = (EntityType)this.entityTypes.get(type.getName());
            if (elementType == null) {
                elementType = this.buildEntityType(sessionFactory, type.getName());
            }
        } else {
            elementType = new EntityType(type.getReturnedClass());
        }
        CollectionType collectionType = new CollectionType();
        collectionType.setElementType((org.beangle.commons.entity.metadata.Type)elementType);
        collectionType.setArray(cm.isArray());
        collectionType.setCollectionClass(collectionClass);
        if (!this.collectionTypes.containsKey(collectionType.getName())) {
            this.collectionTypes.put(collectionType.getName(), collectionType);
        }
        return collectionType;
    }

    private ComponentType buildComponentType(SessionFactory sessionFactory, String entityName, String propertyName) {
        org.beangle.commons.entity.metadata.Type propertyType;
        EntityType entityType = (EntityType)this.entityTypes.get(entityName);
        if (entityType != null && (propertyType = (org.beangle.commons.entity.metadata.Type)entityType.getPropertyTypes().get(propertyName)) != null) {
            return (ComponentType)propertyType;
        }
        ClassMetadata cm = sessionFactory.getClassMetadata(entityName);
        org.hibernate.type.ComponentType hcType = (org.hibernate.type.ComponentType)cm.getPropertyType(propertyName);
        String[] propertyNames = hcType.getPropertyNames();
        ComponentType cType = new ComponentType(hcType.getReturnedClass());
        Map propertyTypes = cType.getPropertyTypes();
        int j = 0;
        while (j < propertyNames.length) {
            Type type = cm.getPropertyType(String.valueOf(propertyName) + "." + propertyNames[j]);
            if (type.isEntityType()) {
                propertyTypes.put(propertyNames[j], this.buildEntityType(sessionFactory, type.getName()));
            } else if (type.isComponentType()) {
                propertyTypes.put(propertyNames[j], this.buildComponentType(sessionFactory, entityName, String.valueOf(propertyName) + "." + propertyNames[j]));
            } else if (type.isCollectionType()) {
                propertyTypes.put(propertyNames[j], this.buildCollectionType(sessionFactory, this.defaultCollectionClass(type), String.valueOf(entityName) + "." + propertyName + "." + propertyNames[j]));
            }
            ++j;
        }
        return cType;
    }

    private Class<?> defaultCollectionClass(Type collectionType) {
        if (collectionType.isAnyType()) {
            return null;
        }
        if (SetType.class.isAssignableFrom(collectionType.getClass())) {
            return HashSet.class;
        }
        if (MapType.class.isAssignableFrom(collectionType.getClass())) {
            return HashMap.class;
        }
        return ArrayList.class;
    }
}

