/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate;

import java.util.Properties;
import org.beangle.commons.lang.Strings;
import org.beangle.orm.hibernate.TableNamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSeqGenerator
extends SequenceStyleGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TableSeqGenerator.class);
    public static TableNamingStrategy namingStrategy;
    private static final int MaxLength = 30;
    private String sequencePattern = "seq_{table}";

    public void configure(Type type, Properties params, Dialect dialect) {
        if (Strings.isEmpty((CharSequence)params.getProperty("sequence_name"))) {
            String tableName = params.getProperty("target_table");
            String pk = params.getProperty("target_column");
            if (tableName != null) {
                String schema;
                String entityName;
                String seqName = Strings.replace((String)this.sequencePattern, (String)"{table}", (String)tableName);
                if ((seqName = Strings.replace((String)seqName, (String)"{pk}", (String)pk)).length() > 30) {
                    logger.warn("{}'s length >=30, wouldn't be supported in some db!", (Object)seqName);
                }
                if ((entityName = params.getProperty("entity_name")) != null && namingStrategy != null && (schema = namingStrategy.getSchema(entityName)) != null) {
                    seqName = String.valueOf(schema) + "." + seqName;
                }
                params.setProperty("sequence_name", seqName);
            }
        }
        super.configure(type, params, dialect);
    }

    public String getSequencePattern() {
        return this.sequencePattern;
    }

    public void setSequencePattern(String sequencePattern) {
        this.sequencePattern = sequencePattern;
    }
}

