/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.inject.Resources;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.text.inflector.Pluralizer;
import org.beangle.commons.text.inflector.en.EnNounPluralizer;
import org.beangle.orm.hibernate.TableNamePattern;
import org.beangle.orm.hibernate.TableNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableNamingStrategy
implements TableNamingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTableNamingStrategy.class);
    private int entityTableMaxLength = 25;
    private int relationTableMaxLength = 30;
    private Pluralizer pluralizer = new EnNounPluralizer();
    private final List<TableNamePattern> patterns = new ArrayList<TableNamePattern>();
    private final Map<String, TableNamePattern> packagePatterns = CollectUtils.newHashMap();

    public void addConfig(URL url) {
        this.loadProperties(url);
        Collections.sort(this.patterns);
    }

    private void loadProperties(URL url) {
        try {
            logger.debug("loading {}", (Object)url);
            InputStream is = url.openStream();
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
            }
            for (String string : props.keySet()) {
                String[] pairs;
                TableNamePattern pattern;
                String schemaPrefix = props.getProperty(string).trim();
                String schema = null;
                String prefix = null;
                String abbreviationStr = null;
                int commaIndex = schemaPrefix.indexOf(44);
                if (commaIndex < 0 || commaIndex + 1 == schemaPrefix.length()) {
                    schema = schemaPrefix;
                } else if (commaIndex == 0) {
                    prefix = schemaPrefix.substring(1);
                } else {
                    schema = Strings.substringBefore((String)schemaPrefix, (String)",");
                    prefix = Strings.substringAfter((String)schemaPrefix, (String)",");
                }
                if (Strings.contains(prefix, (CharSequence)",")) {
                    abbreviationStr = Strings.substringAfter(prefix, (String)",").toLowerCase();
                    prefix = Strings.substringBefore((String)prefix, (String)",");
                }
                if ((pattern = this.packagePatterns.get(string)) == null) {
                    pattern = new TableNamePattern(string, schema, prefix);
                    this.packagePatterns.put(string, pattern);
                    this.patterns.add(pattern);
                } else {
                    pattern.setSchema(schema);
                    pattern.setPrefix(prefix);
                }
                if (abbreviationStr == null) continue;
                String[] stringArray = pairs = Strings.split((String)abbreviationStr, (String)";");
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String longName = Strings.substringBefore((String)pair, (String)"=");
                    String shortName = Strings.substringAfter((String)pair, (String)"=");
                    pattern.abbreviations.put(longName, shortName);
                    ++n2;
                }
            }
            is.close();
        }
        catch (IOException e) {
            logger.error("property load error", (Throwable)e);
        }
    }

    @Override
    public String getSchema(String packageName) {
        String schemaName = null;
        for (TableNamePattern pattern : this.patterns) {
            if (packageName.indexOf(pattern.getPackageName()) != 0) continue;
            schemaName = pattern.getSchema();
        }
        return schemaName;
    }

    public TableNamePattern getPattern(String packageName) {
        TableNamePattern last = null;
        for (TableNamePattern pattern : this.patterns) {
            if (packageName.indexOf(pattern.getPackageName()) != 0) continue;
            last = pattern;
        }
        return last;
    }

    public String getPrefix(String packageName) {
        String prefix = null;
        for (TableNamePattern pattern : this.patterns) {
            if (packageName.indexOf(pattern.getPackageName()) != 0) continue;
            prefix = pattern.getPrefix();
        }
        return prefix;
    }

    @Override
    public boolean isMultiSchema() {
        Set schemas = CollectUtils.newHashSet();
        for (TableNamePattern pattern : this.patterns) {
            schemas.add(pattern.getSchema() == null ? "" : pattern.getSchema());
        }
        return schemas.size() > 1;
    }

    public List<TableNamePattern> getPatterns() {
        return this.patterns;
    }

    public void setResources(Resources resources) {
        if (resources != null) {
            for (URL url : resources.getAllPaths()) {
                this.addConfig(url);
            }
            logger.info("Table name pattern: -> \n{}", (Object)this);
        }
    }

    public String toString() {
        int maxlength = 0;
        for (TableNamePattern pattern : this.patterns) {
            if (pattern.getPackageName().length() <= maxlength) continue;
            maxlength = pattern.getPackageName().length();
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.patterns.size()) {
            TableNamePattern pattern = this.patterns.get(i);
            sb.append(Strings.rightPad((String)pattern.getPackageName(), (int)maxlength, (char)' ')).append(" : [").append(pattern.getSchema());
            sb.append(" , ").append(pattern.getPrefix());
            if (!pattern.abbreviations.isEmpty()) {
                sb.append(" , ").append(pattern.abbreviations);
            }
            sb.append(']');
            if (i < this.patterns.size() - 1) {
                sb.append('\n');
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String classToTableName(String className) {
        TableNamePattern pattern;
        if (className.endsWith("Bean")) {
            className = Strings.substringBeforeLast((String)className, (String)"Bean");
        }
        String tableName = DefaultTableNamingStrategy.addUnderscores(DefaultTableNamingStrategy.unqualify(className));
        if (this.pluralizer != null) {
            tableName = this.pluralizer.pluralize(tableName);
        }
        if ((pattern = this.getPattern(className)) != null) {
            tableName = String.valueOf(pattern.prefix) + tableName;
        }
        if (tableName.length() > this.entityTableMaxLength && pattern != null) {
            for (Map.Entry<String, String> pairEntry : pattern.abbreviations.entrySet()) {
                tableName = Strings.replace((String)tableName, (String)pairEntry.getKey(), (String)pairEntry.getValue());
            }
        }
        return tableName;
    }

    @Override
    public String collectionToTableName(String className, String tableName, String collectionName) {
        TableNamePattern pattern = this.getPattern(className);
        String collectionTableName = String.valueOf(tableName) + "_" + DefaultTableNamingStrategy.addUnderscores(DefaultTableNamingStrategy.unqualify(collectionName));
        if (collectionTableName.length() > this.relationTableMaxLength && pattern != null) {
            for (Map.Entry<String, String> pairEntry : pattern.abbreviations.entrySet()) {
                collectionTableName = Strings.replace((String)collectionTableName, (String)pairEntry.getKey(), (String)pairEntry.getValue());
            }
        }
        return collectionTableName;
    }

    protected static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? qualifiedName : qualifiedName.substring(loc + 1);
    }

    protected static String addUnderscores(String name) {
        return Strings.unCamel((String)name.replace('.', '_'), (char)'_');
    }

    public void setPluralizer(Pluralizer pluralizer) {
        this.pluralizer = pluralizer;
    }

    public void setEntityTableMaxLength(int entityTableMaxLength) {
        this.entityTableMaxLength = entityTableMaxLength;
    }

    public void setRelationTableMaxLength(int relationTableMaxLength) {
        this.relationTableMaxLength = relationTableMaxLength;
    }
}

