/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.sql.DataSource;
import org.beangle.commons.io.Files$;
import org.beangle.commons.lang.Consoles$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.jdbc.ds.DataSourceUtils$;
import org.beangle.jdbc.ds.DatasourceConfig;
import org.beangle.jdbc.engine.UrlFormat;
import org.beangle.jdbc.script.OracleParser$;
import org.beangle.jdbc.script.Runner;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.xml.Node;
import scala.xml.XML$;

public final class Sql$
implements Logging,
Serializable {
    private static Logger logger;
    private static DatasourceConfig datasource;
    private static ListBuffer datasources;
    private static String workdir;
    private static String sqlDir;
    public static final Sql$ MODULE$;

    private Sql$() {
    }

    static {
        MODULE$ = new Sql$();
        Logging.$init$((Logging)MODULE$);
        datasources = new ListBuffer();
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Sql$.class);
    }

    public DatasourceConfig datasource() {
        return datasource;
    }

    public void datasource_$eq(DatasourceConfig x$1) {
        datasource = x$1;
    }

    public ListBuffer<DatasourceConfig> datasources() {
        return datasources;
    }

    public void datasources_$eq(ListBuffer<DatasourceConfig> x$1) {
        datasources = x$1;
    }

    public String workdir() {
        return workdir;
    }

    public void workdir_$eq(String x$1) {
        workdir = x$1;
    }

    public String sqlDir() {
        return sqlDir;
    }

    public void sqlDir_$eq(String x$1) {
        sqlDir = x$1;
    }

    public void main(String[] args) {
        this.workdir_$eq(args.length == 0 ? SystemInfo$.MODULE$.user().dir() : args[0]);
        this.read();
        this.sqlDir_$eq(this.workdir() + Files$.MODULE$.$div() + "sql" + Files$.MODULE$.$div());
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.sqlFiles());
        if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
            Predef$.MODULE$.println((Object)("Cannot find sql files in " + this.sqlDir()));
            return;
        }
        if (this.datasources().isEmpty()) {
            Logger$.MODULE$.info$extension(this.logger(), this::main$$anonfun$1);
            return;
        }
        if (this.datasources().size() == 1) {
            this.datasource_$eq((DatasourceConfig)this.datasources().head());
        }
        Predef$.MODULE$.println((Object)"Sql executor:help ls exec exit(quit/q)");
        Consoles$.MODULE$.shell(this::main$$anonfun$2, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exit", "quit", "q"})), (Function1)(JProcedure1 & Serializable)x$1 -> {
            String string = x$1;
            if ("ls".equals(string)) {
                this.info();
                return;
            }
            if ("help".equals(string)) {
                this.printHelp();
                return;
            }
            String t = string;
            if (t.startsWith("use")) {
                this.use(Numbers$.MODULE$.toInt(Strings$.MODULE$.trim(Strings$.MODULE$.substringAfter(t, "use")), 0));
                return;
            }
            if (t.startsWith("exec")) {
                this.exec(Strings$.MODULE$.trim(Strings$.MODULE$.substringAfter(t, "exec")));
                return;
            }
            if (Strings$.MODULE$.isNotEmpty((CharSequence)t)) {
                Predef$.MODULE$.println((Object)(t + ": command not found..."));
                return;
            }
        });
    }

    public String[] sqlFiles() {
        File file = new File(this.sqlDir());
        if (file.exists()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])file.list());
            Object[] files = (String[])ArrayOps$.MODULE$.withFilter$extension(object, (Function1 & Serializable)f -> f.endsWith(".sql")).map((Function1 & Serializable)f -> f, ClassTag$.MODULE$.apply(String.class));
            Object object2 = Predef$.MODULE$.refArrayOps(files);
            return (String[])ArrayOps$.MODULE$.sorted$extension(object2, (Ordering)Ordering.String$.MODULE$);
        }
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public void exec(String file) {
        if (Strings$.MODULE$.isBlank((CharSequence)file)) {
            Predef$.MODULE$.println((Object)"Usage exec all or exec file1 file2");
            return;
        }
        String fileName = file;
        String string = file;
        String string2 = "all";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            fileName = Predef$.MODULE$.wrapRefArray((Object[])this.sqlFiles()).mkString(" ");
        }
        ListBuffer urls = new ListBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(fileName, " "));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)name -> {
            File f = new File(this.sqlDir() + (String)(name.endsWith(".sql") ? name : name + ".sql"));
            if (f.exists()) {
                return urls.$plus$eq((Object)f.toURI().toURL());
            }
            Predef$.MODULE$.println((Object)("file " + f.getAbsolutePath() + " doesn't exists"));
            return BoxedUnit.UNIT;
        });
        Runner runner = new Runner(OracleParser$.MODULE$, (Seq<URL>)urls.toSeq());
        if (this.datasource() == null) {
            this.use(-1);
        }
        if (this.datasource() == null || urls.isEmpty()) {
            Predef$.MODULE$.println((Object)"Execute sql aborted.");
            return;
        }
        this.config(this.datasource());
        if (this.datasource().password() == null) {
            this.datasource().password_$eq(Consoles$.MODULE$.readPassword("enter datasource [%1$s] %2$s password:", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.datasource().name(), this.datasource().user()})));
        }
        DataSource ds = DataSourceUtils$.MODULE$.build(this.datasource().driver(), this.datasource().user(), this.datasource().password(), (Map<String, String>)this.datasource().props());
        runner.execute(ds, true);
    }

    public String exec$default$1() {
        return null;
    }

    public void printHelp() {
        Predef$.MODULE$.println((Object)"Avaliable command:\n  ls                        print datasource and sql file\n  exec [sqlfile1,sqlfile2]  execute simple file\n  exec all                  execute all sql file\n  help              print this help conent");
    }

    public void use(int index) {
        if (this.datasources().isEmpty()) {
            Predef$.MODULE$.println((Object)"datasource is empty");
            return;
        }
        if (index > -1) {
            this.datasource_$eq((DatasourceConfig)this.datasources().apply(index));
            return;
        }
        String selectName = Consoles$.MODULE$.prompt("choose datasource index?", null, (Function1 & Serializable)name -> {
            Integer result = Numbers$.MODULE$.convert2Int(name, null);
            return result != null && Predef$.MODULE$.Integer2int(result) > -1 && Predef$.MODULE$.Integer2int(result) < this.datasources().size();
        });
        this.datasource_$eq((DatasourceConfig)this.datasources().apply(Numbers$.MODULE$.toInt(selectName, Numbers$.MODULE$.toInt$default$2())));
    }

    public int use$default$1() {
        return 0;
    }

    public void info() {
        ListBuffer infos = new ListBuffer();
        IntRef index = IntRef.create((int)0);
        this.datasources().foreach((Function1)(JProcedure1 & Serializable)ds -> {
            int n;
            DatasourceConfig datasourceConfig = ds;
            DatasourceConfig datasourceConfig2 = this.datasource();
            String prefix = !(datasourceConfig != null ? !datasourceConfig.equals(datasourceConfig2) : datasourceConfig2 != null) ? "[*] " : "[" + index$1.elem + "] ";
            infos.$plus$eq((Object)(prefix + ds.name()));
            index$1.elem = n = index$1.elem + 1;
        });
        Predef$.MODULE$.println((Object)("Data sources:\n" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), 50)));
        Predef$.MODULE$.println((Object)infos.mkString("\n"));
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)("Sql files:\n" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), 50)));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.wrapRefArray((Object[])this.sqlFiles()).mkString(" "));
    }

    private void config(DatasourceConfig resource) {
        block4: {
            block6: {
                String url;
                block5: {
                    url = (String)resource.props().get((Object)"url").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    if (url != null) break block4;
                    UrlFormat format = new UrlFormat(url);
                    if (format.params().nonEmpty()) {
                        List<String> params = format.params();
                        HashMap values = new HashMap();
                        params.foreach((Function1 & Serializable)param -> values.put(param, (Object)Consoles$.MODULE$.prompt("enter " + param + ":", Consoles$.MODULE$.prompt$default$2())));
                        url = format.fill((scala.collection.immutable.Map<String, String>)values.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                        resource.props().put((Object)"url", (Object)url);
                    }
                    if (resource.user() == null) break block5;
                    String string = resource.user();
                    String string2 = "<username>";
                    if (string != null ? !string.equals(string2) : string2 != null) break block6;
                }
                resource.user_$eq(Consoles$.MODULE$.prompt("enter datasource " + url + " username:", Consoles$.MODULE$.prompt$default$2()));
                return;
            }
            return;
        }
    }

    private void read() {
        if (this.workdir() == null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        File target = new File(this.workdir() + Files$.MODULE$.$div() + "datasources.xml");
        if (target.exists()) {
            Logger$.MODULE$.info$extension(this.logger(), () -> this.read$$anonfun$1(target));
            XML$.MODULE$.load((InputStream)new FileInputStream(target)).$bslash$bslash("datasource").foreach((Function1 & Serializable)elem -> (ListBuffer)this.datasources().$plus$eq((Object)DataSourceUtils$.MODULE$.parseXml((Node)elem)));
            return;
        }
    }

    private final String main$$anonfun$1() {
        return "Cannot find datasource";
    }

    private final String main$$anonfun$2() {
        String prefix = this.datasource() != null ? this.datasource().name() : "sql";
        return prefix + " >";
    }

    private final String read$$anonfun$1(File target$1) {
        return "Read config file " + target$1.getName();
    }
}

