/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.query;

import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.Statement;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.io.IOs$;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.query.JdbcExecutor$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.ScalaRunTime$;

public class ResultSetIterator
implements Iterator<Object[]>,
Closeable {
    private final ResultSet rs;
    private Object[] nextRecord;
    private final int[] types;
    private final String[] columnNames;
    private final int[] columnDisplaySizes;

    public ResultSetIterator(ResultSet rs, Engine engine) {
        this.rs = rs;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.types = JdbcExecutor$.MODULE$.getColumnTypes(rs, engine);
        this.columnNames = JdbcExecutor$.MODULE$.getColumnNames(rs);
        this.columnDisplaySizes = JdbcExecutor$.MODULE$.getColumnDisplaySizes(rs);
        this.readNext();
    }

    public Object[] nextRecord() {
        return this.nextRecord;
    }

    public void nextRecord_$eq(Object[] x$1) {
        this.nextRecord = x$1;
    }

    public int[] types() {
        return this.types;
    }

    public String[] columnNames() {
        return this.columnNames;
    }

    public int[] columnDisplaySizes() {
        return this.columnDisplaySizes;
    }

    private void readNext() {
        if (this.rs.next()) {
            this.nextRecord_$eq(JdbcExecutor$.MODULE$.convert(this.rs, this.types()));
            return;
        }
        this.nextRecord_$eq(null);
        this.close();
    }

    public boolean hasNext() {
        return this.nextRecord() != null;
    }

    public Object[] next() {
        Object[] previous = this.nextRecord();
        this.readNext();
        return previous;
    }

    @Override
    public void close() throws Exception {
        Statement smt = this.rs.getStatement();
        if (smt == null) {
            IOs$.MODULE$.close((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{this.rs}));
        } else {
            IOs$.MODULE$.close((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{this.rs, smt, smt.getConnection()}));
        }
    }

    public Seq<Object[]> listAll() {
        Buffer buffer;
        Buffer buf = Collections$.MODULE$.newBuffer();
        try {
            while (this.hasNext()) {
                buf.$plus$eq((Object)this.next());
            }
            buffer = buf;
        }
        finally {
            this.close();
        }
        return buffer;
    }
}

