/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.query;

import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.jdbc.DefaultSqlTypeMapping;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.engine.Engines$;
import org.beangle.jdbc.meta.SqlType$;
import org.beangle.jdbc.query.JdbcExecutor$;
import org.beangle.jdbc.query.ParamSetter$;
import org.beangle.jdbc.query.ResultSetIterator;
import org.beangle.jdbc.query.Statement;
import org.beangle.jdbc.query.TypeParamSetter$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class JdbcExecutor
implements Logging {
    private Logger logger;
    private final DataSource dataSource;
    private final Engine engine;
    private final DefaultSqlTypeMapping sqlTypeMapping;
    private boolean showSql;
    private int fetchSize;

    public static Object[] convert(ResultSet resultSet, int[] nArray) {
        return JdbcExecutor$.MODULE$.convert(resultSet, nArray);
    }

    public static int[] getColumnDisplaySizes(ResultSet resultSet) {
        return JdbcExecutor$.MODULE$.getColumnDisplaySizes(resultSet);
    }

    public static String[] getColumnNames(ResultSet resultSet) {
        return JdbcExecutor$.MODULE$.getColumnNames(resultSet);
    }

    public static int[] getColumnTypes(ResultSet resultSet, Engine engine) {
        return JdbcExecutor$.MODULE$.getColumnTypes(resultSet, engine);
    }

    public JdbcExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
        this.engine = Engines$.MODULE$.forDataSource(dataSource);
        this.sqlTypeMapping = new DefaultSqlTypeMapping(this.engine);
        this.showSql = false;
        this.fetchSize = 1000;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public DefaultSqlTypeMapping sqlTypeMapping() {
        return this.sqlTypeMapping;
    }

    public boolean showSql() {
        return this.showSql;
    }

    public void showSql_$eq(boolean x$1) {
        this.showSql = x$1;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize_$eq(int x$1) {
        this.fetchSize = x$1;
    }

    public <T> Option<T> unique(String sql, scala.collection.immutable.Seq<Object> params) {
        Seq<Object[]> rs = this.query(sql, params);
        if (rs.isEmpty()) {
            return None$.MODULE$;
        }
        Object[] o = (Object[])rs.head();
        Object object = Predef$.MODULE$.genericArrayOps((Object)o);
        return Some$.MODULE$.apply(ArrayOps$.MODULE$.head$extension(object));
    }

    public Option<Object> queryForInt(String sql) {
        Option num = this.unique(sql, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Number n = (Number)((Some)option).value();
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n.intValue()));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Option<Object> queryForLong(String sql) {
        Option num = this.unique(sql, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Number n = (Number)((Some)option).value();
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)n.longValue()));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public <T> T useConnection(Function1<Connection, T> f) {
        Object object;
        try (Connection conn = this.dataSource.getConnection();){
            object = f.apply((Object)conn);
        }
        return (T)object;
    }

    public Statement statement(String sql) {
        return new Statement(sql, this);
    }

    public ResultSetIterator iterate(String sql, scala.collection.immutable.Seq<Object> params) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        Connection conn = this.dataSource.getConnection();
        conn.setAutoCommit(false);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setFetchSize(this.fetchSize());
        TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), (Seq<Object>)params).apply(stmt);
        ResultSet rs = stmt.executeQuery();
        return new ResultSetIterator(rs, this.engine);
    }

    public Seq<Object[]> query(String sql, scala.collection.immutable.Seq<Object> params) {
        return this.query(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), (Seq<Object>)params));
    }

    public Seq<Object[]> query(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        return (Seq)this.useConnection((Function1 & Serializable)conn -> {
            PreparedStatement stmt = conn.prepareStatement(sql);
            setter.apply((Object)stmt);
            return new ResultSetIterator(stmt.executeQuery(), this.engine).listAll();
        });
    }

    public Seq<Object[]> fetch(String sql, PageLimit limit, scala.collection.immutable.Seq<Object> params) {
        return this.fetch(sql, limit, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), (Seq<Object>)params));
    }

    public Seq<Object[]> fetch(String sql, PageLimit limit, Function1<PreparedStatement, BoxedUnit> setter) {
        Tuple2<String, List<Object>> rs = this.engine.limit(sql, limit.pageSize() * (limit.pageIndex() - 1), limit.pageSize());
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + rs._1()));
        }
        return (Seq)this.useConnection((Function1 & Serializable)conn -> {
            PreparedStatement stmt = conn.prepareStatement((String)rs._1());
            setter.apply((Object)stmt);
            IntRef start = IntRef.create((int)(stmt.getParameterMetaData().getParameterCount() - ((SeqOps)rs._2()).size()));
            ((List)rs._2()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                int n;
                stmt.setInt(start$1.elem + 1, i);
                start$1.elem = n = start$1.elem + 1;
            });
            return new ResultSetIterator(stmt.executeQuery(), this.engine).listAll();
        });
    }

    public int update(String sql, scala.collection.immutable.Seq<Object> params) {
        return this.update(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), (Seq<Object>)params));
    }

    public int update(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        PreparedStatement stmt = null;
        Connection conn = this.dataSource.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        int rows = 0;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                setter.apply((Object)stmt);
                rows = stmt.executeUpdate();
                stmt.close();
                stmt = null;
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return rows;
    }

    public scala.collection.immutable.Seq<Object> batch(String sql, Seq<Object> datas, Seq<Object> types) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        ObjectRef stmt = ObjectRef.create(null);
        Connection conn = this.dataSource.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        ListBuffer rows = new ListBuffer();
        ObjectRef curParam = ObjectRef.create(null);
        try {
            try {
                PreparedStatement preparedStatement = conn.prepareStatement(sql);
                stmt.elem = preparedStatement;
                preparedStatement = null;
                datas.foreach((Function1)(JProcedure1 & Serializable)param -> {
                    Object object;
                    curParam$1.elem = object = param;
                    object = null;
                    ParamSetter$.MODULE$.setParams((PreparedStatement)stmt$2.elem, (Seq<Object>)Predef$.MODULE$.genericWrapArray(param), types);
                    ((PreparedStatement)stmt$2.elem).addBatch();
                });
                rows.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapIntArray(((PreparedStatement)stmt.elem).executeBatch()));
                conn.commit();
            }
            catch (BatchUpdateException be) {
                this.rollback(conn);
                this.rethrow2(be.getNextException() == null ? be : be.getNextException(), sql, types, curParam.elem);
            }
            catch (SQLException e) {
                this.rollback(conn);
                this.rethrow2(e, sql, types, curParam.elem);
            }
        }
        finally {
            ((PreparedStatement)stmt.elem).close();
            conn.close();
        }
        return rows.toList();
    }

    private void rollback(Connection conn) {
        try {
            conn.rollback();
        }
        catch (Exception exception) {}
    }

    public void rethrow(SQLException cause, String sql, scala.collection.immutable.Seq<Object> params) {
        StringBuffer msg = new StringBuffer(cause.getMessage() == null ? "" : cause.getMessage());
        msg.append(" Query: ").append(sql).append(" Parameters: ");
        StringBuffer stringBuffer = params == null ? msg.append("[]") : msg.append(Strings$.MODULE$.join(params, ","));
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    public void rethrow2(SQLException cause, String sql, Seq<Object> types, Object params) {
        StringBuffer msg = new StringBuffer(cause.getMessage() == null ? "" : cause.getMessage());
        msg.append(" Query: ").append(sql).append(" Parameters: (");
        StringBuffer stringBuffer = params == null ? msg.append("[]") : msg.append(Strings$.MODULE$.join((Iterable)Predef$.MODULE$.genericWrapArray(params), ","));
        IntRef l = IntRef.create((int)0);
        Object object = Predef$.MODULE$.genericArrayOps(params);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object == null) {
                int n;
                l$1.elem = n = l$1.elem + 0;
                return;
            }
            if (object instanceof String) {
                int n;
                String s = (String)object;
                l$1.elem = n = l$1.elem + s.length();
                return;
            }
        });
        Predef$.MODULE$.println((Object)("string length is " + l.elem));
        msg.append(") Parameter types: (").append(Strings$.MODULE$.join((Iterable)types.map((Function1 & Serializable)typeCode -> SqlType$.MODULE$.typeName(BoxesRunTime.unboxToInt((Object)typeCode))), ",")).append(')');
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }
}

