/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.meta;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.meta.Column;
import org.beangle.jdbc.meta.Constraint$;
import org.beangle.jdbc.meta.ForeignKey;
import org.beangle.jdbc.meta.Identifier;
import org.beangle.jdbc.meta.Identifier$;
import org.beangle.jdbc.meta.Index;
import org.beangle.jdbc.meta.PrimaryKey;
import org.beangle.jdbc.meta.Relation;
import org.beangle.jdbc.meta.Schema;
import org.beangle.jdbc.meta.Table$;
import org.beangle.jdbc.meta.TableRef;
import org.beangle.jdbc.meta.UniqueKey;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class Table
extends Relation {
    private boolean phantom;
    private Option primaryKey = None$.MODULE$;
    private final ListBuffer uniqueKeys = new ListBuffer();
    private final ListBuffer foreignKeys = new ListBuffer();
    private final ListBuffer indexes = new ListBuffer();

    public static Table apply(Schema schema, String string) {
        return Table$.MODULE$.apply(schema, string);
    }

    public static String qualify(Schema schema, Identifier identifier) {
        return Table$.MODULE$.qualify(schema, identifier);
    }

    public static String qualify(String string, String string2) {
        return Table$.MODULE$.qualify(string, string2);
    }

    public Table(Schema s, Identifier n) {
        super(s, n);
    }

    public boolean phantom() {
        return this.phantom;
    }

    public void phantom_$eq(boolean x$1) {
        this.phantom = x$1;
    }

    public Option<PrimaryKey> primaryKey() {
        return this.primaryKey;
    }

    public void primaryKey_$eq(Option<PrimaryKey> x$1) {
        this.primaryKey = x$1;
    }

    public ListBuffer<UniqueKey> uniqueKeys() {
        return this.uniqueKeys;
    }

    public ListBuffer<ForeignKey> foreignKeys() {
        return this.foreignKeys;
    }

    public ListBuffer<Index> indexes() {
        return this.indexes;
    }

    @Override
    public boolean hasQuotedIdentifier() {
        return this.name().quoted() || this.columns().exists((Function1 & Serializable)_$2 -> _$2.name().quoted()) || this.indexes().exists((Function1 & Serializable)_$3 -> _$3.name().quoted()) || this.uniqueKeys().exists((Function1 & Serializable)_$4 -> _$4.name().quoted()) || this.foreignKeys().exists((Function1 & Serializable)_$5 -> _$5.name().quoted());
    }

    @Override
    public Table attach(Engine engine) {
        super.attach(engine);
        this.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> pk.attach(engine));
        this.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> fk.attach(engine));
        this.uniqueKeys().foreach((Function1)(JProcedure1 & Serializable)uk -> uk.attach(engine));
        this.indexes().foreach((Function1)(JProcedure1 & Serializable)idx -> idx.attach(engine));
        return this;
    }

    @Override
    public Table clone(Schema newschema) {
        Table t = this.clone();
        Schema oldSchema = t.schema();
        t.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> {
            Schema schema = fk.referencedTable().schema();
            Schema schema2 = oldSchema;
            if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
                fk.referencedTable().schema_$eq(newschema);
                return;
            }
        });
        t.schema_$eq(newschema);
        t.attach(t.engine());
        return t;
    }

    public Table clone() {
        Table tb = new Table(this.schema(), this.name());
        tb.comment_$eq(this.comment());
        tb.module_$eq(this.module());
        this.columns().foreach((Function1 & Serializable)col -> tb.add(col.clone()));
        this.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> {
            PrimaryKey npk = pk.clone();
            npk.table_$eq(tb);
            tb.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply((Object)npk));
        });
        this.foreignKeys().foreach((Function1 & Serializable)fk -> tb.add(fk.clone()));
        this.uniqueKeys().foreach((Function1 & Serializable)uk -> tb.add(uk.clone()));
        this.indexes().foreach((Function1 & Serializable)idx -> tb.add(idx.clone()));
        return tb;
    }

    public boolean isPrimaryKeyIndex(String indexName) {
        return this.primaryKey().exists((Function1 & Serializable)_$6 -> {
            String string = _$6.name().value();
            String string2 = indexName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }) || indexName.toLowerCase().contains("primary_key");
    }

    public boolean isSameStruct(Table o) {
        String string = this.qualifiedName();
        String string2 = o.qualifiedName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        if (this.columns().size() != o.columns().size()) {
            return false;
        }
        return this.columns().forall((Function1 & Serializable)c -> {
            Option option = o.columns().find((Function1 & Serializable)_$7 -> {
                Identifier identifier = _$7.name();
                Identifier identifier2 = c.name();
                return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
            });
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            if (option instanceof Some) {
                Column c2 = (Column)((Some)option).value();
                return c.isSame(c2);
            }
            throw new MatchError((Object)option);
        });
    }

    public void toCase(boolean lower) {
        this.name_$eq(this.name().toCase(lower));
        this.columns().foreach((Function1)(JProcedure1 & Serializable)col -> col.toCase(lower));
        this.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> pk.toCase(lower));
        this.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> fk.toCase(lower));
        this.uniqueKeys().foreach((Function1)(JProcedure1 & Serializable)uk -> uk.toCase(lower));
        this.indexes().foreach((Function1)(JProcedure1 & Serializable)idx -> idx.toCase(lower));
    }

    private boolean hasPrimaryKey() {
        return this.primaryKey().isDefined();
    }

    public Option<ForeignKey> getForeignKey(String keyName) {
        return this.foreignKeys().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = keyName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Option<UniqueKey> getUniqueKey(String keyName) {
        return this.uniqueKeys().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = keyName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public UniqueKey createUniqueKey(String keyName, Seq<String> columnNames) {
        Engine eng = this.engine();
        UniqueKey uk = new UniqueKey(this, Identifier$.MODULE$.apply("uk_temp", Identifier$.MODULE$.$lessinit$greater$default$2()));
        columnNames.foreach((Function1)(JProcedure1 & Serializable)colName -> uk.addColumn(eng.toIdentifier((String)colName)));
        if (Strings$.MODULE$.isBlank((CharSequence)keyName)) {
            uk.name_$eq(eng.toIdentifier(Constraint$.MODULE$.autoname(uk)));
        } else {
            uk.name_$eq(eng.toIdentifier(keyName));
        }
        this.add(uk);
        return uk;
    }

    public Index createIndex(String indexName, boolean unique, Seq<String> columnNames) {
        Index index = new Index(this, Identifier$.MODULE$.apply("indx_temp", Identifier$.MODULE$.$lessinit$greater$default$2()));
        Engine eng = this.engine();
        columnNames.foreach((Function1)(JProcedure1 & Serializable)colName -> index.addColumn(eng.toIdentifier((String)colName)));
        index.unique_$eq(unique);
        if (Strings$.MODULE$.isBlank((CharSequence)indexName)) {
            index.name_$eq(eng.toIdentifier(Constraint$.MODULE$.autoname(index)));
        } else {
            index.name_$eq(eng.toIdentifier(indexName));
        }
        this.indexes().$plus$eq((Object)index);
        return index;
    }

    public PrimaryKey createPrimaryKey(String keyName, Seq<String> columnNames) {
        PrimaryKey primaryKey;
        Engine egn = this.engine();
        if (columnNames.size() == 1) {
            primaryKey = new PrimaryKey(this, Identifier$.MODULE$.empty(), egn.toIdentifier((String)columnNames.head()));
        } else {
            PrimaryKey pk2 = new PrimaryKey(this, Identifier$.MODULE$.empty(), null);
            columnNames.foreach((Function1)(JProcedure1 & Serializable)cn -> {
                Identifier cnName = egn.toIdentifier((String)cn);
                this.columns().foreach((Function1)(JProcedure1 & Serializable)c -> {
                    Identifier identifier = c.name();
                    Identifier identifier2 = cnName;
                    if (!(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null)) {
                        pk2.addColumn((Column)c);
                        return;
                    }
                });
            });
            primaryKey = pk2;
        }
        PrimaryKey pk = primaryKey;
        pk.name_$eq(this.engine().toIdentifier(Strings$.MODULE$.isBlank((CharSequence)keyName) ? Constraint$.MODULE$.autoname(pk) : keyName));
        this.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply((Object)pk));
        pk.columns().foreach((Function1)(JProcedure1 & Serializable)c -> this.column(c.toLiteral(this.engine())).nullable_$eq(false));
        return pk;
    }

    public ForeignKey createForeignKey(String keyName, String columnName, TableRef refTable, String refencedColumn) {
        Engine eng = this.engine();
        ForeignKey fk = new ForeignKey(this, Identifier$.MODULE$.apply("fk_temp", Identifier$.MODULE$.$lessinit$greater$default$2()), eng.toIdentifier(columnName));
        fk.refer(refTable, (Seq<Identifier>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{eng.toIdentifier(refencedColumn)}));
        fk.name_$eq(Strings$.MODULE$.isNotBlank((CharSequence)keyName) ? this.engine().toIdentifier(keyName) : this.engine().toIdentifier(Constraint$.MODULE$.autoname(fk)));
        return this.add(fk);
    }

    public ForeignKey createForeignKey(String keyName, String columnName, Table refTable) {
        Engine eng = this.engine();
        Option<PrimaryKey> option = refTable.primaryKey();
        if (option instanceof Some) {
            PrimaryKey pk = (PrimaryKey)((Some)option).value();
            ForeignKey fk = new ForeignKey(this, Identifier$.MODULE$.apply("fk_temp", Identifier$.MODULE$.$lessinit$greater$default$2()), eng.toIdentifier(columnName));
            fk.refer(refTable, (Seq<Identifier>)pk.columns().toSeq());
            if (Strings$.MODULE$.isBlank((CharSequence)keyName)) {
                fk.name_$eq(eng.toIdentifier(Constraint$.MODULE$.autoname(fk)));
            } else {
                fk.name_$eq(eng.toIdentifier(keyName));
            }
            return this.add(fk);
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("Cannot refer on a table without primary key");
        }
        throw new MatchError(option);
    }

    public ForeignKey add(ForeignKey key) {
        key.table_$eq(this);
        this.foreignKeys().dropWhileInPlace((Function1 & Serializable)_$8 -> {
            Identifier identifier = _$8.name();
            Identifier identifier2 = key.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        });
        this.foreignKeys().$plus$eq((Object)key);
        return key;
    }

    public UniqueKey add(UniqueKey key) {
        key.table_$eq(this);
        this.uniqueKeys().dropWhileInPlace((Function1 & Serializable)_$9 -> {
            Identifier identifier = _$9.name();
            Identifier identifier2 = key.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        });
        this.uniqueKeys().$plus$eq((Object)key);
        return key;
    }

    public Index add(Index index) {
        index.table_$eq(this);
        this.indexes().dropWhileInPlace((Function1 & Serializable)_$10 -> {
            Identifier identifier = _$10.name();
            Identifier identifier2 = index.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        });
        this.indexes().$plus$eq((Object)index);
        return index;
    }

    @Override
    public Column add(Column column) {
        Option ukName = this.uniqueKeys().find((Function1 & Serializable)uk -> uk.columns().size() == 1 && uk.columns().contains((Object)column.name())).map((Function1 & Serializable)_$11 -> _$11.name().value());
        this.remove(column);
        this.columns().$plus$eq((Object)column);
        if (column.unique()) {
            this.createUniqueKey((String)ukName.getOrElse(() -> this.add$$anonfun$4(column)), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{column.name().value()}));
        }
        return column;
    }

    @Override
    public void remove(Column column) {
        this.columns().find((Function1 & Serializable)_$12 -> {
            Identifier identifier = _$12.name();
            Identifier identifier2 = column.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        }).foreach((Function1 & Serializable)c -> {
            this.columns().$minus$eq(c);
            return (ListBuffer)this.uniqueKeys().$minus$minus$eq((IterableOnce)this.uniqueKeys().filter((Function1 & Serializable)uk -> uk.columns().size() == 1 && uk.columns().contains((Object)c.name())));
        });
    }

    public Option<Index> getIndex(String indexName) {
        return this.indexes().find((Function1 & Serializable)f -> {
            String string = f.name().value();
            String string2 = indexName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    @Override
    public void updateSchema(Schema newSchema) {
        Schema oldSchema = this.schema();
        this.schema_$eq(newSchema);
        this.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> {
            if (fk.referencedTable() != null) {
                Schema schema = fk.referencedTable().schema();
                Schema schema2 = oldSchema;
                if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
                    fk.referencedTable().schema_$eq(newSchema);
                    return;
                }
                return;
            }
        });
    }

    public void convertIndexToUniqueKeys() {
        ListBuffer ui = (ListBuffer)this.indexes().filter((Function1 & Serializable)i -> i.unique());
        this.indexes().$minus$minus$eq((IterableOnce)ui);
        ui.foreach((Function1 & Serializable)i -> this.createUniqueKey(i.name().value(), (Seq<String>)((IterableOnceOps)i.columns().map((Function1 & Serializable)_$13 -> _$13.value())).toSeq()));
    }

    private final String add$$anonfun$4(Column column$2) {
        return this.name().value() + "_" + column$2.name().value() + "_key";
    }
}

