/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.meta;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.meta.Column;
import org.beangle.jdbc.meta.Column$;
import org.beangle.jdbc.meta.Comment;
import org.beangle.jdbc.meta.Identifier;
import org.beangle.jdbc.meta.Schema;
import org.beangle.jdbc.meta.SqlType;
import org.beangle.jdbc.meta.Table$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public abstract class Relation
implements Ordered<Relation>,
Comment,
Cloneable {
    private Option comment;
    private Schema schema;
    private Identifier name;
    private final ListBuffer columns;
    private Option module;

    public Relation(Schema schema, Identifier name) {
        this.schema = schema;
        this.name = name;
        Ordered.$init$((Ordered)this);
        Comment.$init$(this);
        this.columns = new ListBuffer();
        this.module = None$.MODULE$;
    }

    public Option comment() {
        return this.comment;
    }

    public void comment_$eq(Option x$1) {
        this.comment = x$1;
    }

    public Schema schema() {
        return this.schema;
    }

    public void schema_$eq(Schema x$1) {
        this.schema = x$1;
    }

    public Identifier name() {
        return this.name;
    }

    public void name_$eq(Identifier x$1) {
        this.name = x$1;
    }

    public ListBuffer<Column> columns() {
        return this.columns;
    }

    public Option<String> module() {
        return this.module;
    }

    public void module_$eq(Option<String> x$1) {
        this.module = x$1;
    }

    public Relation attach(Engine engine) {
        this.columns().foreach((Function1)(JProcedure1 & Serializable)col -> {
            SqlType st = col.sqlType();
            col.sqlType_$eq(engine.toType(st.code(), BoxesRunTime.unboxToInt((Object)st.precision().getOrElse(Relation::attach$$anonfun$1$$anonfun$1)), BoxesRunTime.unboxToInt((Object)st.scale().getOrElse(Relation::attach$$anonfun$1$$anonfun$2))));
            col.defaultValue().foreach((Function1)(JProcedure1 & Serializable)v -> col.defaultValue_$eq(engine.convert(col.sqlType(), (String)v)));
            col.name_$eq(col.name().attach(engine));
        });
        this.name_$eq(this.name().attach(engine));
        return this;
    }

    public Column column(String columnName) {
        return (Column)this.columns().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = columnName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).get();
    }

    public Option<Column> getColumn(String columnName) {
        return this.columns().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = columnName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public boolean columnExits(Identifier columnName) {
        return this.columns().exists((Function1 & Serializable)f -> {
            Identifier identifier = f.name();
            Identifier identifier2 = columnName;
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        });
    }

    public void rename(Column column, Identifier newName) {
        this.remove(column);
        column.name_$eq(newName);
        this.add(column);
    }

    public Column add(Column column) {
        this.remove(column);
        this.columns().$plus$eq((Object)column);
        return column;
    }

    public void add(Seq<Column> cols) {
        cols.foreach((Function1 & Serializable)col -> this.add((Column)col));
    }

    public void remove(Column column) {
        this.columns().find((Function1 & Serializable)_$1 -> {
            Identifier identifier = _$1.name();
            Identifier identifier2 = column.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        }).foreach((Function1 & Serializable)c -> (ListBuffer)this.columns().$minus$eq(c));
    }

    public Column createColumn(String name, SqlType sqlType) {
        Engine egn = this.engine();
        Column col = new Column(egn.toIdentifier(name), sqlType, Column$.MODULE$.$lessinit$greater$default$3());
        this.add(col);
        return col;
    }

    public Column createColumn(String name, String typeName) {
        Engine egn = this.engine();
        Column col = new Column(egn.toIdentifier(name), egn.toType(typeName), Column$.MODULE$.$lessinit$greater$default$3());
        this.add(col);
        return col;
    }

    public abstract Relation clone(Schema var1);

    public boolean hasQuotedIdentifier() {
        return this.name().quoted() || this.columns().exists((Function1 & Serializable)_$2 -> _$2.name().quoted());
    }

    public Engine engine() {
        return this.schema().database().engine();
    }

    public List<String> quotedColumnNames() {
        Engine e = this.engine();
        return this.columns().result().map((Function1 & Serializable)_$3 -> _$3.name().toLiteral(e));
    }

    public String qualifiedName() {
        return Table$.MODULE$.qualify(this.schema(), this.name());
    }

    public int compare(Relation o) {
        return this.qualifiedName().compareTo(o.qualifiedName());
    }

    public Option<String> commentAndModule() {
        Option option = this.comment();
        if (option instanceof Some) {
            String c = (String)((Some)option).value();
            Option<String> option2 = this.module();
            if (option2 instanceof Some) {
                String m = (String)((Some)option2).value();
                return Some$.MODULE$.apply((Object)(c + "@" + m));
            }
            if (None$.MODULE$.equals(option2)) {
                return this.comment();
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return this.comment();
        }
        throw new MatchError((Object)option);
    }

    public void updateSchema(Schema newSchema) {
        this.schema_$eq(newSchema);
    }

    public void updateCommentAndModule(String newComment) {
        if (Strings$.MODULE$.isBlank((CharSequence)newComment)) {
            this.comment_$eq((Option)None$.MODULE$);
            this.module_$eq((Option<String>)None$.MODULE$);
            return;
        }
        if (newComment.contains("@")) {
            this.comment_$eq((Option)Some$.MODULE$.apply((Object)Strings$.MODULE$.substringBefore(newComment, "@")));
            this.module_$eq((Option<String>)Some$.MODULE$.apply((Object)Strings$.MODULE$.substringAfter(newComment, "@")));
            return;
        }
        this.comment_$eq((Option)Some$.MODULE$.apply((Object)newComment));
        this.module_$eq((Option<String>)None$.MODULE$);
    }

    public String toString() {
        return Table$.MODULE$.qualify(this.schema(), this.name());
    }

    private static final int attach$$anonfun$1$$anonfun$1() {
        return 0;
    }

    private static final int attach$$anonfun$1$$anonfun$2() {
        return 0;
    }
}

