/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.meta;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.concurrent.Tasks$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.meta.Column;
import org.beangle.jdbc.meta.Constraint;
import org.beangle.jdbc.meta.Database;
import org.beangle.jdbc.meta.ForeignKey;
import org.beangle.jdbc.meta.Identifier;
import org.beangle.jdbc.meta.Identifier$;
import org.beangle.jdbc.meta.Index;
import org.beangle.jdbc.meta.MetadataColumns$;
import org.beangle.jdbc.meta.MetadataLoadSql;
import org.beangle.jdbc.meta.MetadataLoader$;
import org.beangle.jdbc.meta.PrimaryKey;
import org.beangle.jdbc.meta.Schema;
import org.beangle.jdbc.meta.Schema$NameFilter$;
import org.beangle.jdbc.meta.Sequence;
import org.beangle.jdbc.meta.SqlType;
import org.beangle.jdbc.meta.SqlType$;
import org.beangle.jdbc.meta.Table;
import org.beangle.jdbc.meta.Table$;
import org.beangle.jdbc.meta.TableRef$;
import org.beangle.jdbc.meta.View;
import org.beangle.jdbc.query.JdbcExecutor$;
import org.slf4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map;
import scala.jdk.javaapi.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class MetadataLoader
implements Logging {
    private Logger logger;
    public final DatabaseMetaData org$beangle$jdbc$meta$MetadataLoader$$meta;
    public final Engine org$beangle$jdbc$meta$MetadataLoader$$engine;

    public static Database dump(DatabaseMetaData databaseMetaData, Engine engine, Option<Identifier> option, Option<Identifier> option2) {
        return MetadataLoader$.MODULE$.dump(databaseMetaData, engine, option, option2);
    }

    public MetadataLoader(DatabaseMetaData meta, Engine engine) {
        this.org$beangle$jdbc$meta$MetadataLoader$$meta = meta;
        this.org$beangle$jdbc$meta$MetadataLoader$$engine = engine;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public scala.collection.immutable.Seq<String> schemas() {
        Buffer names = Collections$.MODULE$.newBuffer();
        if (this.org$beangle$jdbc$meta$MetadataLoader$$engine.catalogAsSchema()) {
            ResultSet rs = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getCatalogs();
            while (rs.next()) {
                names.addOne((Object)rs.getString(MetadataColumns$.MODULE$.TableCat()));
            }
            rs.close();
        } else {
            ResultSet rs = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getSchemas();
            while (rs.next()) {
                names.addOne((Object)rs.getString(MetadataColumns$.MODULE$.TableSchema()));
            }
            rs.close();
        }
        Set systemSchemas = ((IterableOnceOps)this.org$beangle$jdbc$meta$MetadataLoader$$engine.systemSchemas().map((Function1 & Serializable)_$2 -> _$2.toLowerCase())).toSet();
        Buffer removed = (Buffer)names.filter((Function1 & Serializable)x -> {
            String n = x.toLowerCase();
            return n.contains("$") || !n.contains("_") && n.contains("sys") || systemSchemas.contains((Object)n);
        });
        names.subtractAll((IterableOnce)removed);
        return (scala.collection.immutable.Seq)names.toSet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public void loadTables(Schema schema, boolean extras) {
        Schema.NameFilter filter = new Schema.NameFilter(Schema$NameFilter$.MODULE$.$lessinit$greater$default$1());
        filter.include("*");
        this.loadTables(schema, filter, extras);
    }

    public void loadViews(Schema schema) {
        Schema.NameFilter filter = new Schema.NameFilter(Schema$NameFilter$.MODULE$.$lessinit$greater$default$1());
        filter.include("*");
        this.loadViews(schema, filter);
    }

    public void loadViews(Schema schema, Schema.NameFilter filter) {
        Tuple2<String, String> pattern = this.processCatalogSchema(schema);
        String catalogName = (String)pattern._1();
        String schemaPattern = (String)pattern._2();
        Stopwatch sw = new Stopwatch(true);
        ResultSet rs = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getTables(catalogName, schemaPattern, null, new String[]{"VIEW"});
        HashMap views = new HashMap();
        while (rs.next()) {
            String tableName = rs.getString(MetadataColumns$.MODULE$.TableName());
            if (tableName.contains("$") || !filter.isMatched(tableName)) continue;
            View view = schema.database().addView(this.getTableSchema(rs), rs.getString(MetadataColumns$.MODULE$.TableName()));
            view.updateCommentAndModule(rs.getString(MetadataColumns$.MODULE$.Remarks()));
            views.put((Object)Table$.MODULE$.qualify(view.schema(), view.name()), (Object)view);
        }
        rs.close();
        Logger$.MODULE$.debug$extension(this.logger(), () -> MetadataLoader.loadViews$$anonfun$1(views, sw));
        if (views.isEmpty()) {
            return;
        }
        int cols = this.loadColumns(schema.database(), false, catalogName, schemaPattern);
        Logger$.MODULE$.debug$extension(this.logger(), () -> MetadataLoader.loadViews$$anonfun$2(cols, sw));
        if (this.org$beangle$jdbc$meta$MetadataLoader$$engine.metadataLoadSql().supportViewExtra()) {
            this.batchLoadViewExtra(schema, this.org$beangle$jdbc$meta$MetadataLoader$$engine.metadataLoadSql());
            return;
        }
    }

    public void loadTables(Schema schema, Schema.NameFilter filter, boolean extras) {
        Tuple2<String, String> pattern = this.processCatalogSchema(schema);
        String catalogName = (String)pattern._1();
        String schemaPattern = (String)pattern._2();
        Stopwatch sw = new Stopwatch(true);
        ResultSet rs = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getTables(catalogName, schemaPattern, null, new String[]{"TABLE"});
        HashMap tables = new HashMap();
        while (rs.next()) {
            String tableName = rs.getString(MetadataColumns$.MODULE$.TableName());
            if (tableName.contains("$") || !filter.isMatched(tableName)) continue;
            Table table2 = schema.database().addTable(this.getTableSchema(rs), rs.getString(MetadataColumns$.MODULE$.TableName()));
            table2.updateCommentAndModule(rs.getString(MetadataColumns$.MODULE$.Remarks()));
            tables.put((Object)Table$.MODULE$.qualify(table2.schema(), table2.name()), (Object)table2);
        }
        rs.close();
        Logger$.MODULE$.debug$extension(this.logger(), () -> MetadataLoader.loadTables$$anonfun$1(tables, sw));
        if (tables.isEmpty()) {
            return;
        }
        int cols = this.loadColumns(schema.database(), true, catalogName, schemaPattern);
        int origTabCount = tables.size();
        schema.cleanEmptyTables();
        tables.filterInPlace((Function2 & Serializable)(_$3, table) -> table.columns().nonEmpty());
        if (tables.size() == origTabCount) {
            Logger$.MODULE$.debug$extension(this.logger(), () -> MetadataLoader.loadTables$$anonfun$3(cols, sw));
        } else {
            Logger$.MODULE$.debug$extension(this.logger(), () -> MetadataLoader.loadTables$$anonfun$4(cols, origTabCount, tables, sw));
        }
        if (extras) {
            if (this.org$beangle$jdbc$meta$MetadataLoader$$engine.metadataLoadSql().supportsTableExtra()) {
                this.batchLoadTableExtra(schema, this.org$beangle$jdbc$meta$MetadataLoader$$engine.metadataLoadSql());
                return;
            }
            Logger$.MODULE$.debug$extension(this.logger(), MetadataLoader::loadTables$$anonfun$5);
            ConcurrentLinkedQueue<String> tableNames = new ConcurrentLinkedQueue<String>();
            tableNames.addAll(CollectionConverters$.MODULE$.asJava((Seq)tables.keySet().toList().sortWith((Function2 & Serializable)(_$4, _$5) -> StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(_$4), _$5))));
            Tasks$.MODULE$.start((Runnable)new ExtraMetaLoadTask(this, tableNames, (HashMap<String, Table>)tables), 5, Tasks$.MODULE$.start$default$3());
            return;
        }
    }

    private int loadColumns(Database database, boolean isTable, String catalogName, String schemaPattern) {
        Stopwatch sw = new Stopwatch(true);
        ResultSet rs = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getColumns(catalogName, schemaPattern, "%", "%");
        IntRef cols = IntRef.create((int)0);
        Map types = Collections$.MODULE$.newMap();
        while (rs.next()) {
            String defaultValue = rs.getString(MetadataColumns$.MODULE$.ColumnDef());
            String colName = rs.getString(MetadataColumns$.MODULE$.ColumnName());
            if (colName == null) continue;
            Object relation = isTable ? database.getTable(this.getTableSchema(rs), rs.getString(MetadataColumns$.MODULE$.TableName())) : database.getView(this.getTableSchema(rs), rs.getString(MetadataColumns$.MODULE$.TableName()));
            relation.foreach((Function1)(JProcedure1 & Serializable)r -> {
                int n;
                String typename = new StringTokenizer(rs.getString(MetadataColumns$.MODULE$.TypeName()), "() ").nextToken();
                int typecode = this.org$beangle$jdbc$meta$MetadataLoader$$engine.resolveCode(rs.getInt(MetadataColumns$.MODULE$.DataType()), typename);
                IntRef length = IntRef.create((int)rs.getInt(MetadataColumns$.MODULE$.ColumnSize()));
                IntRef scale = IntRef.create((int)rs.getInt(MetadataColumns$.MODULE$.DecimalDigits()));
                if (scale.elem == -127 && length.elem == 0 && SqlType$.MODULE$.isNumberType(typecode)) {
                    int n2;
                    int n3;
                    scale.elem = n3 = 5;
                    length.elem = n2 = 19;
                }
                String key = typecode + "-" + typename + "-" + length.elem + "-" + scale.elem;
                SqlType sqlType = (SqlType)types.getOrElseUpdate((Object)key, () -> this.$anonfun$3(typecode, length, scale));
                boolean nullable = "yes".equalsIgnoreCase(rs.getString(MetadataColumns$.MODULE$.IsNullable()));
                Column col = new Column(Identifier$.MODULE$.apply(rs.getString(MetadataColumns$.MODULE$.ColumnName()), Identifier$.MODULE$.$lessinit$greater$default$2()), sqlType, nullable);
                col.comment_$eq(Option$.MODULE$.apply((Object)rs.getString(MetadataColumns$.MODULE$.Remarks())));
                if (defaultValue != null) {
                    String dv = Strings$.MODULE$.trim(defaultValue);
                    if (Strings$.MODULE$.isNotEmpty((CharSequence)dv) && dv.contains("::")) {
                        dv = Strings$.MODULE$.substringBefore(dv, "::");
                    }
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(dv))) {
                        String string = dv;
                        String string2 = "null";
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            col.defaultValue_$eq((Option<String>)Option$.MODULE$.apply((Object)dv));
                        }
                    }
                }
                r.add(col);
                cols$4.elem = n = cols$4.elem + 1;
            });
        }
        rs.close();
        return cols.elem;
    }

    private String getTableSchema(ResultSet rs) {
        return rs.getString(this.org$beangle$jdbc$meta$MetadataLoader$$engine.catalogAsSchema() ? MetadataColumns$.MODULE$.TableCat() : MetadataColumns$.MODULE$.TableSchema());
    }

    private Tuple2<String, String> processCatalogSchema(Schema schema) {
        String catalogName = schema.catalog() == null || schema.catalog().isEmpty() ? null : ((Identifier)schema.catalog().get()).value();
        String schemaPattern = schema.name().value();
        if (Strings$.MODULE$.isBlank((CharSequence)catalogName)) {
            catalogName = null;
        }
        if (Strings$.MODULE$.isBlank((CharSequence)schemaPattern)) {
            schemaPattern = null;
        }
        if (catalogName == null && schemaPattern != null && this.org$beangle$jdbc$meta$MetadataLoader$$engine.catalogAsSchema()) {
            String t = catalogName;
            catalogName = schemaPattern;
            schemaPattern = t;
        }
        return Tuple2$.MODULE$.apply((Object)catalogName, (Object)schemaPattern);
    }

    private void batchLoadTableExtra(Schema schema, MetadataLoadSql sql) {
        Stopwatch sw = new Stopwatch(true);
        ObjectRef rs = ObjectRef.create(null);
        String schemaName = schema.name().toLiteral(this.org$beangle$jdbc$meta$MetadataLoader$$engine);
        ResultSet resultSet = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getConnection().createStatement().executeQuery(sql.primaryKeySql().replace(":schema", schemaName));
        rs.elem = resultSet;
        resultSet = null;
        while (((ResultSet)rs.elem).next()) {
            schema.database().getTable(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableSchema()), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableName())).foreach((Function1)(JProcedure1 & Serializable)table -> {
                String colname = ((ResultSet)rs$2.elem).getString(MetadataColumns$.MODULE$.ColumnName());
                Identifier pkName = this.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$2.elem, MetadataColumns$.MODULE$.PKName());
                Option<PrimaryKey> option = table.primaryKey();
                if (None$.MODULE$.equals(option)) {
                    table.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply((Object)new PrimaryKey((Table)table, pkName, table.column(colname).name())));
                    return;
                }
                if (option instanceof Some) {
                    PrimaryKey pk = (PrimaryKey)((Some)option).value();
                    pk.addColumn(table.column(colname));
                    return;
                }
                throw new MatchError(option);
            });
        }
        ((ResultSet)rs.elem).close();
        ResultSet resultSet2 = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getConnection().createStatement().executeQuery(sql.importedKeySql().replace(":schema", schemaName));
        rs.elem = resultSet2;
        resultSet2 = null;
        while (((ResultSet)rs.elem).next()) {
            schema.database().getTable(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKTabkeSchem()), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKTableName())).foreach((Function1)(JProcedure1 & Serializable)table -> {
                ForeignKey foreignKey;
                Identifier fkName = this.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.FKName());
                Column column = table.column(((ResultSet)rs$3.elem).getString(MetadataColumns$.MODULE$.FKColumnName()));
                Option<ForeignKey> option = table.getForeignKey(fkName.value());
                if (None$.MODULE$.equals(option)) {
                    foreignKey = table.add(new ForeignKey((Table)table, this.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.FKName()), column.name()));
                } else if (option instanceof Some) {
                    ForeignKey oldk;
                    foreignKey = oldk = (ForeignKey)((Some)option).value();
                } else {
                    throw new MatchError(option);
                }
                ForeignKey fk = foreignKey;
                Schema pkSchema = schema.database().getOrCreateSchema(this.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.PKTableSchem()));
                fk.refer(TableRef$.MODULE$.apply(pkSchema, this.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.PKTableName())), (scala.collection.immutable.Seq<Identifier>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{this.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$3.elem, MetadataColumns$.MODULE$.PKColumnName())}));
                fk.cascadeDelete_$eq(((ResultSet)rs$3.elem).getInt(MetadataColumns$.MODULE$.DeleteRule()) != 3);
            });
        }
        ((ResultSet)rs.elem).close();
        ResultSet resultSet3 = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getConnection().createStatement().executeQuery(sql.indexInfoSql().replace(":schema", schemaName));
        rs.elem = resultSet3;
        resultSet3 = null;
        while (((ResultSet)rs.elem).next()) {
            schema.database().getTable(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableSchema()), ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.TableName())).foreach((Function1)(JProcedure1 & Serializable)table -> {
                String indexName = ((ResultSet)rs$4.elem).getString(MetadataColumns$.MODULE$.IndexName());
                if (!table.primaryKey().exists((Function1 & Serializable)_$6 -> {
                    String string = _$6.name().value();
                    String string2 = indexName;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                })) {
                    Index index;
                    Option<Index> option = table.getIndex(indexName);
                    if (None$.MODULE$.equals(option)) {
                        index = table.add(new Index((Table)table, Identifier$.MODULE$.apply(indexName, Identifier$.MODULE$.$lessinit$greater$default$2())));
                    } else if (option instanceof Some) {
                        Index oldIdx;
                        index = oldIdx = (Index)((Some)option).value();
                    } else {
                        throw new MatchError(option);
                    }
                    Index idx = index;
                    idx.unique_$eq(!((ResultSet)rs$4.elem).getBoolean("NON_UNIQUE"));
                    String columnName = ((ResultSet)rs$4.elem).getString(MetadataColumns$.MODULE$.ColumnName());
                    Option<Column> option2 = table.getColumn(columnName);
                    if (option2 instanceof Some) {
                        Column column = (Column)((Some)option2).value();
                        idx.addColumn(column.name());
                        return;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        idx.addColumn(Identifier$.MODULE$.apply(columnName, Identifier$.MODULE$.$lessinit$greater$default$2()));
                        return;
                    }
                    throw new MatchError(option2);
                }
            });
        }
        ((ResultSet)rs.elem).close();
        schema.tables().values().foreach((Function1)(JProcedure1 & Serializable)t -> t.convertIndexToUniqueKeys());
        Logger$.MODULE$.debug$extension(this.logger(), () -> MetadataLoader.batchLoadTableExtra$$anonfun$5(sw));
    }

    private void batchLoadViewExtra(Schema schema, MetadataLoadSql sql) {
        if (Strings$.MODULE$.isBlank((CharSequence)this.org$beangle$jdbc$meta$MetadataLoader$$engine.metadataLoadSql().viewDefSql())) {
            return;
        }
        schema.views().values().foreach((Function1)(JProcedure1 & Serializable)v -> {
            String sql = this.org$beangle$jdbc$meta$MetadataLoader$$engine.metadataLoadSql().viewDefSql();
            sql = Strings$.MODULE$.replace(sql, ":schema", schema.name().toLiteral(v.engine()));
            sql = Strings$.MODULE$.replace(sql, ":view_name", v.name().toLiteral(v.engine()));
            Statement statement = null;
            ResultSet rs = null;
            try {
                Object[] values;
                Object object;
                statement = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                if (rs.next() && ArrayOps$.MODULE$.nonEmpty$extension(object = Predef$.MODULE$.genericArrayOps((Object)(values = JdbcExecutor$.MODULE$.convert(rs, JdbcExecutor$.MODULE$.getColumnTypes(rs, this.org$beangle$jdbc$meta$MetadataLoader$$engine))))) && values[0] != null) {
                    Object dfn = values[0].toString().trim();
                    if (!((String)dfn).toLowerCase().startsWith("create ")) {
                        dfn = "create view " + v.qualifiedName() + " as " + (String)dfn;
                    }
                    v.definition_$eq((Option<String>)Some$.MODULE$.apply(dfn));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public void loadSequences(Schema schema) {
        block14: {
            sequences = new HashSet();
            if (Strings$.MODULE$.isBlank((CharSequence)this.org$beangle$jdbc$meta$MetadataLoader$$engine.metadataLoadSql().sequenceSql())) {
                return;
            }
            sql = this.org$beangle$jdbc$meta$MetadataLoader$$engine.metadataLoadSql().sequenceSql();
            if ((sql = Strings$.MODULE$.replace(sql, ":schema", schema.name().toLiteral(this.org$beangle$jdbc$meta$MetadataLoader$$engine))) == null) break block14;
            statement = null;
            rs = ObjectRef.create(null);
            try {
                statement = this.org$beangle$jdbc$meta$MetadataLoader$$meta.getConnection().createStatement();
                var6_6 = statement.executeQuery(sql);
                rs.elem = var6_6;
                var6_6 = null;
                columnNames = new HashSet();
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), ((ResultSet)rs.elem).getMetaData().getColumnCount()).foreach((Function1)(JFunction1.mcZI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)Z, loadSequences$$anonfun$1(scala.collection.mutable.HashSet scala.runtime.ObjectRef int ), (I)Z)((HashSet)columnNames, (ObjectRef)rs));
                while (((ResultSet)rs.elem).next()) {
                    block15: {
                        sequence = new Sequence(schema, this.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, "sequence_name"));
                        if (columnNames.contains((Object)"current_value")) {
                            sequence.current_$eq(Long.valueOf(((ResultSet)rs.elem).getString("current_value")));
                        } else if (columnNames.contains((Object)"next_value")) {
                            sequence.current_$eq(Long.valueOf(((ResultSet)rs.elem).getString("next_value")) - 1L);
                        }
                        if (columnNames.contains((Object)"increment_by")) {
                            sequence.increment_$eq(Integer.valueOf(((ResultSet)rs.elem).getString("increment_by")));
                        }
                        if (columnNames.contains((Object)"cache_size")) {
                            sequence.cache_$eq(Integer.valueOf(((ResultSet)rs.elem).getString("cache_size")));
                        }
                        if (!columnNames.contains((Object)"cycle_flag")) break block15;
                        v0 = flag = ((ResultSet)rs.elem).getString("cycle_flag").toLowerCase();
                        var10_10 = "y";
                        if (!(v0 == null ? var10_10 != null : v0.equals(var10_10) == false)) ** GOTO lbl-1000
                        v1 = flag;
                        var11_11 = "yes";
                        if (!(v1 == null ? var11_11 != null : v1.equals(var11_11) == false)) ** GOTO lbl-1000
                        v2 = flag;
                        var12_12 = "on";
                        if (!(v2 != null ? v2.equals(var12_12) == false : var12_12 != null)) lbl-1000:
                        // 3 sources

                        {
                            v3 = true;
                        } else {
                            v3 = false;
                        }
                        sequence.cycle_$eq(v3);
                    }
                    sequences.$plus$eq((Object)sequence);
                }
            }
            finally {
                if ((ResultSet)rs.elem != null) {
                    ((ResultSet)rs.elem).close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        schema.sequences().$plus$plus$eq((IterableOnce)sequences);
    }

    public Identifier org$beangle$jdbc$meta$MetadataLoader$$getIdentifier(ResultSet rs, String columnName) {
        return Identifier$.MODULE$.apply(rs.getString(columnName), Identifier$.MODULE$.$lessinit$greater$default$2());
    }

    private static final String loadViews$$anonfun$1(HashMap views$1, Stopwatch sw$1) {
        return "Load " + views$1.size() + " views in " + sw$1.toString();
    }

    private static final String loadViews$$anonfun$2(int cols$1, Stopwatch sw$2) {
        return "Load " + cols$1 + " columns in " + sw$2;
    }

    private static final String loadTables$$anonfun$1(HashMap tables$1, Stopwatch sw$3) {
        return "Load " + tables$1.size() + " tables in " + sw$3.toString();
    }

    private static final String loadTables$$anonfun$3(int cols$2, Stopwatch sw$4) {
        return "Load " + cols$2 + " columns in " + sw$4;
    }

    private static final String loadTables$$anonfun$4(int cols$3, int origTabCount$1, HashMap tables$2, Stopwatch sw$5) {
        return "Load " + cols$3 + " columns and evict empty " + (origTabCount$1 - tables$2.size()) + " tables in " + sw$5 + ".";
    }

    private static final String loadTables$$anonfun$5() {
        return "Loading primary key,foreign key and index.";
    }

    private final SqlType $anonfun$3(int typecode$1, IntRef length$1, IntRef scale$1) {
        return this.org$beangle$jdbc$meta$MetadataLoader$$engine.toType(typecode$1, length$1.elem, scale$1.elem);
    }

    private static final String batchLoadTableExtra$$anonfun$5(Stopwatch sw$6) {
        return "Load constraint and index in " + sw$6 + ".";
    }

    public static final String org$beangle$jdbc$meta$MetadataLoader$ExtraMetaLoadTask$$_$run$$anonfun$1(Table table$1) {
        return "Loading " + table$1.qualifiedName() + "...";
    }

    public static final String org$beangle$jdbc$meta$MetadataLoader$ExtraMetaLoadTask$$_$run$$anonfun$2() {
        return "Error in loading metadata ";
    }

    public static final Throwable org$beangle$jdbc$meta$MetadataLoader$ExtraMetaLoadTask$$_$run$$anonfun$3(Exception e$1) {
        return e$1;
    }

    public static final String org$beangle$jdbc$meta$MetadataLoader$ExtraMetaLoadTask$$_$run$$anonfun$4(IntRef completed$1) {
        return Thread.currentThread().getName() + " loaded " + completed$1.elem + " tables";
    }

    private static final /* synthetic */ boolean loadSequences$$anonfun$1(HashSet columnNames$1, ObjectRef rs$6, int i) {
        return columnNames$1.add((Object)((ResultSet)rs$6.elem).getMetaData().getColumnLabel(i).toLowerCase());
    }

    public class ExtraMetaLoadTask
    implements Runnable {
        private final ConcurrentLinkedQueue buffer;
        private final HashMap tables;
        private final /* synthetic */ MetadataLoader $outer;

        public ExtraMetaLoadTask(MetadataLoader $outer, ConcurrentLinkedQueue<String> buffer, HashMap<String, Table> tables) {
            this.buffer = buffer;
            this.tables = tables;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public ConcurrentLinkedQueue<String> buffer() {
            return this.buffer;
        }

        public HashMap<String, Table> tables() {
            return this.tables;
        }

        @Override
        public void run() {
            IntRef completed = IntRef.create((int)0);
            String nextTableName = this.buffer().poll();
            while (nextTableName != null) {
                try {
                    int n;
                    Table table = (Table)this.tables().apply((Object)nextTableName);
                    Schema schema = table.schema();
                    String catalogName = this.$outer.org$beangle$jdbc$meta$MetadataLoader$$engine.catalogAsSchema() ? table.schema().name().value() : null;
                    String schemaName = this.$outer.org$beangle$jdbc$meta$MetadataLoader$$engine.catalogAsSchema() ? null : table.schema().name().value();
                    Logger$.MODULE$.debug$extension(this.$outer.logger(), () -> MetadataLoader.org$beangle$jdbc$meta$MetadataLoader$ExtraMetaLoadTask$$_$run$$anonfun$1(table));
                    ObjectRef rs = ObjectRef.create(null);
                    ResultSet resultSet = this.$outer.org$beangle$jdbc$meta$MetadataLoader$$meta.getPrimaryKeys(catalogName, schemaName, table.name().value());
                    rs.elem = resultSet;
                    resultSet = null;
                    Constraint pk = null;
                    while (((ResultSet)rs.elem).next()) {
                        Identifier colName = Identifier$.MODULE$.apply(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.ColumnName()), Identifier$.MODULE$.$lessinit$greater$default$2());
                        if (pk == null) {
                            pk = new PrimaryKey(table, Identifier$.MODULE$.apply(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.PKName()), Identifier$.MODULE$.$lessinit$greater$default$2()), colName);
                            continue;
                        }
                        pk.addColumn(colName);
                    }
                    if (pk != null) {
                        table.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply(pk));
                    }
                    ((ResultSet)rs.elem).close();
                    ResultSet resultSet2 = this.$outer.org$beangle$jdbc$meta$MetadataLoader$$meta.getImportedKeys(catalogName, schemaName, table.name().value());
                    rs.elem = resultSet2;
                    resultSet2 = null;
                    while (((ResultSet)rs.elem).next()) {
                        ForeignKey foreignKey;
                        String fkName = ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKName());
                        Identifier columnName = Identifier$.MODULE$.apply(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKColumnName()), Identifier$.MODULE$.$lessinit$greater$default$2());
                        Option<ForeignKey> option = table.getForeignKey(fkName);
                        if (None$.MODULE$.equals(option)) {
                            foreignKey = table.add(new ForeignKey(table, Identifier$.MODULE$.apply(((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.FKName()), Identifier$.MODULE$.$lessinit$greater$default$2()), columnName));
                        } else if (option instanceof Some) {
                            ForeignKey oldk;
                            foreignKey = oldk = (ForeignKey)((Some)option).value();
                        } else {
                            throw new MatchError(option);
                        }
                        ForeignKey fk = foreignKey;
                        Schema pkSchema = schema.database().getOrCreateSchema(this.$outer.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, this.$outer.org$beangle$jdbc$meta$MetadataLoader$$engine.catalogAsSchema() ? MetadataColumns$.MODULE$.PKTableCat() : MetadataColumns$.MODULE$.PKTableSchem()));
                        fk.refer(TableRef$.MODULE$.apply(pkSchema, this.$outer.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, MetadataColumns$.MODULE$.PKTableName())), (scala.collection.immutable.Seq<Identifier>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{this.$outer.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, MetadataColumns$.MODULE$.PKColumnName())}));
                        fk.cascadeDelete_$eq(((ResultSet)rs.elem).getInt(MetadataColumns$.MODULE$.DeleteRule()) != 3);
                    }
                    ((ResultSet)rs.elem).close();
                    ResultSet resultSet3 = this.$outer.org$beangle$jdbc$meta$MetadataLoader$$meta.getIndexInfo(catalogName, schemaName, table.name().value(), false, true);
                    rs.elem = resultSet3;
                    resultSet3 = null;
                    while (((ResultSet)rs.elem).next()) {
                        String index = ((ResultSet)rs.elem).getString(MetadataColumns$.MODULE$.IndexName());
                        if (index == null || table.isPrimaryKeyIndex(index)) continue;
                        Index info = (Index)table.getIndex(index).getOrElse(() -> this.$anonfun$4(table, rs));
                        info.unique_$eq(!((ResultSet)rs.elem).getBoolean("NON_UNIQUE"));
                        info.addColumn(this.$outer.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs.elem, MetadataColumns$.MODULE$.ColumnName()));
                    }
                    ((ResultSet)rs.elem).close();
                    completed.elem = n = completed.elem + 1;
                    table.convertIndexToUniqueKeys();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (Exception e) {
                    Logger$.MODULE$.error$extension(this.$outer.logger(), MetadataLoader::org$beangle$jdbc$meta$MetadataLoader$ExtraMetaLoadTask$$_$run$$anonfun$2, () -> MetadataLoader.org$beangle$jdbc$meta$MetadataLoader$ExtraMetaLoadTask$$_$run$$anonfun$3(e));
                }
                nextTableName = this.buffer().poll();
            }
            Logger$.MODULE$.debug$extension(this.$outer.logger(), () -> MetadataLoader.org$beangle$jdbc$meta$MetadataLoader$ExtraMetaLoadTask$$_$run$$anonfun$4(completed));
        }

        public final /* synthetic */ MetadataLoader org$beangle$jdbc$meta$MetadataLoader$ExtraMetaLoadTask$$$outer() {
            return this.$outer;
        }

        private final Index $anonfun$4(Table table$2, ObjectRef rs$5) {
            return table$2.add(new Index(table$2, this.$outer.org$beangle$jdbc$meta$MetadataLoader$$getIdentifier((ResultSet)rs$5.elem, MetadataColumns$.MODULE$.IndexName())));
        }
    }
}

