/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.meta;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.beangle.commons.io.IOs$;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.engine.Engines$;
import org.beangle.jdbc.meta.Database;
import org.beangle.jdbc.meta.Identifier;
import org.beangle.jdbc.meta.MetadataLoader;
import org.beangle.jdbc.meta.Schema;
import org.beangle.jdbc.meta.Schema$NameFilter$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class MetadataLoader$
implements Serializable {
    public static final MetadataLoader$ MODULE$ = new MetadataLoader$();

    private MetadataLoader$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MetadataLoader$.class);
    }

    public Database dump(DatabaseMetaData meta, Engine engine, Option<Identifier> catalog, Option<Identifier> schema) {
        Database database = new Database(engine);
        Connection conn = meta.getConnection();
        MetadataLoader loader = new MetadataLoader(conn.getMetaData(), engine);
        Schema.NameFilter allFilter = new Schema.NameFilter(Schema$NameFilter$.MODULE$.$lessinit$greater$default$1());
        allFilter.include("*");
        Set schemaNames = schema.isEmpty() ? loader.schemas() : Option$.MODULE$.option2Iterable(schema.map((Function1 & Serializable)_$1 -> _$1.value())).toSet();
        ((IterableOnceOps)schemaNames).foreach((Function1)(JProcedure1 & Serializable)s -> {
            Schema schema = database.getOrCreateSchema(engine.toIdentifier((String)s));
            schema.catalog_$eq(catalog);
            loader.loadTables(schema, allFilter, true);
            loader.loadViews(schema, allFilter);
            loader.loadSequences(schema);
        });
        return database;
    }

    public Seq<String> schemas(DataSource ds) {
        Seq<String> seq;
        Connection conn = null;
        try {
            conn = ds.getConnection();
            DatabaseMetaData meta = conn.getMetaData();
            MetadataLoader metadataLoader = new MetadataLoader(meta, Engines$.MODULE$.forMetadata(meta));
            seq = metadataLoader.schemas();
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{conn}));
            throw throwable;
        }
        IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{conn}));
        return seq;
    }
}

