/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.meta;

import java.io.Serializable;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.meta.Constraint;
import org.beangle.jdbc.meta.ForeignKey$;
import org.beangle.jdbc.meta.Identifier;
import org.beangle.jdbc.meta.Schema;
import org.beangle.jdbc.meta.Table;
import org.beangle.jdbc.meta.TableRef;
import org.beangle.jdbc.meta.TableRef$;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;

public class ForeignKey
extends Constraint {
    private boolean cascadeDelete = false;
    private ListBuffer referencedColumns = new ListBuffer();
    private TableRef referencedTable;

    public static Identifier $lessinit$greater$default$3() {
        return ForeignKey$.MODULE$.$lessinit$greater$default$3();
    }

    public ForeignKey(Table t, Identifier n, Identifier column) {
        super(t, n);
        this.addColumn(column);
    }

    public boolean cascadeDelete() {
        return this.cascadeDelete;
    }

    public void cascadeDelete_$eq(boolean x$1) {
        this.cascadeDelete = x$1;
    }

    public ListBuffer<Identifier> referencedColumns() {
        return this.referencedColumns;
    }

    public void referencedColumns_$eq(ListBuffer<Identifier> x$1) {
        this.referencedColumns = x$1;
    }

    public TableRef referencedTable() {
        return this.referencedTable;
    }

    public void referencedTable_$eq(TableRef x$1) {
        this.referencedTable = x$1;
    }

    @Override
    public void toCase(boolean lower) {
        super.toCase(lower);
        ListBuffer lowers = (ListBuffer)this.referencedColumns().map((Function1 & Serializable)col -> col.toCase(lower));
        this.referencedColumns().clear();
        this.referencedColumns().$plus$plus$eq((IterableOnce)lowers);
        Schema schema = this.table().schema();
        Schema schema2 = this.referencedTable().schema();
        if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
            this.referencedTable().toCase(lower);
            return;
        }
    }

    @Override
    public void attach(Engine engine) {
        super.attach(engine);
        ListBuffer changed = (ListBuffer)this.referencedColumns().map((Function1 & Serializable)col -> col.attach(engine));
        this.referencedColumns().clear();
        this.referencedColumns().$plus$plus$eq((IterableOnce)changed);
        Schema schema = this.table().schema();
        Schema schema2 = this.referencedTable().schema();
        if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
            this.referencedTable().name_$eq(this.referencedTable().name().attach(engine));
            return;
        }
    }

    @Override
    public ForeignKey clone() {
        ForeignKey cloned = (ForeignKey)super.clone();
        cloned.cascadeDelete_$eq(this.cascadeDelete());
        cloned.referencedTable_$eq(this.referencedTable());
        ListBuffer newColumns = new ListBuffer();
        newColumns.$plus$plus$eq(this.referencedColumns());
        cloned.referencedColumns_$eq((ListBuffer<Identifier>)newColumns);
        return cloned;
    }

    public void refer(Table table, Seq<Identifier> cols) {
        this.referencedTable_$eq(TableRef$.MODULE$.apply(table.schema(), table.name()));
        if (cols.nonEmpty()) {
            this.referencedColumns().$plus$plus$eq(cols);
            return;
        }
    }

    public void refer(TableRef table, Seq<Identifier> cols) {
        this.referencedTable_$eq(table);
        if (cols.nonEmpty()) {
            this.referencedColumns().$plus$plus$eq(cols);
            return;
        }
    }

    public String toString() {
        return "Foreign key(" + this.name() + ')';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof ForeignKey)) return false;
        ForeignKey c = (ForeignKey)object;
        Identifier identifier = this.name();
        Identifier identifier2 = c.name();
        if (identifier == null) {
            if (identifier2 != null) {
                return false;
            }
        } else if (!((Object)identifier).equals(identifier2)) return false;
        if (this.enabled() != c.enabled()) return false;
        ListBuffer<Identifier> listBuffer = this.columns();
        ListBuffer<Identifier> listBuffer2 = c.columns();
        if (listBuffer == null) {
            if (listBuffer2 != null) {
                return false;
            }
        } else if (!listBuffer.equals(listBuffer2)) return false;
        if (this.cascadeDelete() != c.cascadeDelete()) return false;
        ListBuffer<Identifier> listBuffer3 = this.referencedColumns();
        ListBuffer<Identifier> listBuffer4 = c.referencedColumns();
        if (listBuffer3 == null) {
            if (listBuffer4 != null) {
                return false;
            }
        } else if (!listBuffer3.equals(listBuffer4)) return false;
        String string = this.referencedTable().qualifiedName();
        String string2 = c.referencedTable().qualifiedName();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }
}

