/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.engine;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.jdbc.engine.TypeNames$;
import org.beangle.jdbc.engine.TypeNames$TypeInfo$;
import org.beangle.jdbc.meta.SqlType;
import org.beangle.jdbc.meta.SqlType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TypeNames {
    private final Map code2names;
    private final Map name2codes;

    public TypeNames(Map<Object, List<Tuple2<Object, String>>> code2names, Map<String, List<Tuple2<Object, Object>>> name2codes) {
        this.code2names = code2names;
        this.name2codes = name2codes;
    }

    private Map<Object, List<Tuple2<Object, String>>> code2names() {
        return this.code2names;
    }

    private Map<String, List<Tuple2<Object, Object>>> name2codes() {
        return this.name2codes;
    }

    public SqlType toType(int typecode) {
        return this.toType(typecode, 0, 0);
    }

    public SqlType toType(int sqlCode, int precision, int scale) {
        int targetCode = this.normalize(sqlCode, precision);
        return SqlType$.MODULE$.apply(targetCode, this.toName(targetCode, precision, scale), precision, scale);
    }

    public SqlType toType(String typeName) {
        TypeInfo info = TypeNames$.MODULE$.parse(typeName);
        int precision = info.precisionValue();
        int code = this.toCode(info.category(), precision);
        return SqlType$.MODULE$.apply(code, typeName, precision, info.scaleValue());
    }

    public String toName(int typecode) {
        Option option = this.code2names().get((Object)BoxesRunTime.boxToInteger((int)this.normalize(typecode, 0)));
        if (None$.MODULE$.equals(option)) {
            return "other";
        }
        if (option instanceof Some) {
            List l = (List)((Some)option).value();
            return (String)((Tuple2)l.head())._2();
        }
        throw new MatchError((Object)option);
    }

    public String toName(int typecode, int precision, int scale) {
        Option option = this.code2names().get((Object)BoxesRunTime.boxToInteger((int)typecode));
        if (None$.MODULE$.equals(option)) {
            return "other";
        }
        if (option instanceof Some) {
            String string;
            List l = (List)((Some)option).value();
            Option option2 = l.find((Function1 & Serializable)_$3 -> precision <= BoxesRunTime.unboxToInt((Object)_$3._1()));
            if (None$.MODULE$.equals(option2)) {
                string = this.replace((String)((Tuple2)l.head())._2(), precision, scale);
            } else if (option2 instanceof Some) {
                Tuple2 n = (Tuple2)((Some)option2).value();
                string = this.replace((String)n._2(), precision, scale);
            } else {
                throw new MatchError((Object)option2);
            }
            String name = string;
            if (name.contains("(0)")) {
                return Strings$.MODULE$.replace(name, "(0)", "");
            }
            if (name.contains("(0,0)")) {
                return Strings$.MODULE$.replace(name, "(0,0)", "");
            }
            return name;
        }
        throw new MatchError((Object)option);
    }

    public int toCode(String typeName, int precision) {
        Option option = this.name2codes().get((Object)typeName);
        if (None$.MODULE$.equals(option)) {
            return 1111;
        }
        if (option instanceof Some) {
            List l = (List)((Some)option).value();
            Option option2 = l.find((Function1 & Serializable)_$4 -> precision <= _$4._1$mcI$sp());
            if (None$.MODULE$.equals(option2)) {
                return ((Tuple2)l.head())._2$mcI$sp();
            }
            if (option2 instanceof Some) {
                Tuple2 n = (Tuple2)((Some)option2).value();
                return n._2$mcI$sp();
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private int normalize(int sqlCode, int precision) {
        int n = sqlCode;
        if (3 == n || 2 == n) {
            int n2 = precision;
            switch (n2) {
                case 1: {
                    return 16;
                }
                case 5: {
                    return 5;
                }
                case 10: {
                    return 4;
                }
                case 19: {
                    return -5;
                }
            }
            return sqlCode;
        }
        return sqlCode;
    }

    private String replace(String typeString, int precision, int scale) {
        String finalType = typeString;
        finalType = Strings$.MODULE$.replace(finalType, "$s", BoxesRunTime.boxToInteger((int)scale).toString());
        finalType = Strings$.MODULE$.replace(finalType, "$l", BoxesRunTime.boxToInteger((int)precision).toString());
        return Strings$.MODULE$.replace(finalType, "$p", BoxesRunTime.boxToInteger((int)precision).toString());
    }

    public static class Builder {
        private final scala.collection.mutable.Map<Object, Buffer<Tuple2<Object, String>>> code2names = Collections$.MODULE$.newMap();
        private final scala.collection.mutable.Map<String, Buffer<Tuple2<Object, Object>>> name2codes = Collections$.MODULE$.newMap();

        public void put(int typecode, String value2) {
            this.put(typecode, 0, value2);
        }

        public void put(int typecode, int capacity, String pattern) {
            int n;
            TypeInfo info = TypeNames$.MODULE$.parse(pattern);
            Buffer names = (Buffer)this.code2names.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)typecode), this::$anonfun$2);
            Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)capacity));
            names.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, (Object)info.name()));
            Buffer codes = (Buffer)this.name2codes.getOrElseUpdate((Object)info.category(), this::$anonfun$3);
            Option<String> option = info.precision();
            if (option instanceof Some) {
                String p = (String)((Some)option).value();
                n = capacity == 0 ? (Numbers$.MODULE$.isDigits(p) ? Numbers$.MODULE$.toInt(p, Numbers$.MODULE$.toInt$default$2()) : 0) : capacity;
            } else if (None$.MODULE$.equals(option)) {
                n = capacity;
            } else {
                throw new MatchError(option);
            }
            int precision = n;
            Integer n3 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)precision));
            codes.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n3, (Object)BoxesRunTime.boxToInteger((int)typecode)));
        }

        public TypeNames build() {
            scala.collection.mutable.Map names = (scala.collection.mutable.Map)this.code2names.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    int code = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    Buffer names = (Buffer)tuple2._2();
                    return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)code), (Object)((IterableOnceOps)names.sortBy((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToInt((Object)_$1._1()), (Ordering)Ordering.Int$.MODULE$)).toList());
                }
                throw new MatchError((Object)tuple2);
            });
            scala.collection.mutable.Map codes = (scala.collection.mutable.Map)this.name2codes.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Buffer codes = (Buffer)tuple2._2();
                    return Tuple2$.MODULE$.apply((Object)name, (Object)((IterableOnceOps)codes.sortBy((Function1 & Serializable)_$2 -> _$2._1$mcI$sp(), (Ordering)Ordering.Int$.MODULE$)).toList());
                }
                throw new MatchError((Object)tuple2);
            });
            return new TypeNames((Map<Object, List<Tuple2<Object, String>>>)names.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Map<String, List<Tuple2<Object, Object>>>)codes.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        private final Buffer $anonfun$2() {
            return new ArrayBuffer();
        }

        private final Buffer $anonfun$3() {
            return new ArrayBuffer();
        }
    }

    public static class TypeInfo
    implements Product,
    Serializable {
        private final String name;
        private final String category;
        private final Option precision;
        private final Option scale;

        public static TypeInfo apply(String string, String string2, Option<String> option, Option<String> option2) {
            return TypeNames$TypeInfo$.MODULE$.apply(string, string2, option, option2);
        }

        public static TypeInfo fromProduct(Product product) {
            return TypeNames$TypeInfo$.MODULE$.fromProduct(product);
        }

        public static TypeInfo unapply(TypeInfo typeInfo) {
            return TypeNames$TypeInfo$.MODULE$.unapply(typeInfo);
        }

        public TypeInfo(String name, String category, Option<String> precision, Option<String> scale) {
            this.name = name;
            this.category = category;
            this.precision = precision;
            this.scale = scale;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TypeInfo)) return false;
            TypeInfo typeInfo = (TypeInfo)object;
            String string = this.name();
            String string2 = typeInfo.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.category();
            String string4 = typeInfo.category();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.precision();
            Option<String> option2 = typeInfo.precision();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.scale();
            Option<String> option4 = typeInfo.scale();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!typeInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TypeInfo;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "TypeInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "category";
                }
                case 2: {
                    return "precision";
                }
                case 3: {
                    return "scale";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String category() {
            return this.category;
        }

        public Option<String> precision() {
            return this.precision;
        }

        public Option<String> scale() {
            return this.scale;
        }

        public int precisionValue() {
            Option<String> option = this.precision();
            if (option instanceof Some) {
                String p = (String)((Some)option).value();
                if (Numbers$.MODULE$.isDigits(p)) {
                    return Numbers$.MODULE$.toInt(p, Numbers$.MODULE$.toInt$default$2());
                }
                throw new RuntimeException("Cannot parse precision " + p);
            }
            if (None$.MODULE$.equals(option)) {
                return 0;
            }
            throw new MatchError(option);
        }

        public int scaleValue() {
            Option<String> option = this.scale();
            if (option instanceof Some) {
                String p = (String)((Some)option).value();
                if (Numbers$.MODULE$.isDigits(p)) {
                    return Numbers$.MODULE$.toInt(p, Numbers$.MODULE$.toInt$default$2());
                }
                throw new RuntimeException("Cannot parse scale " + p);
            }
            if (None$.MODULE$.equals(option)) {
                return 0;
            }
            throw new MatchError(option);
        }

        public TypeInfo copy(String name, String category, Option<String> precision, Option<String> scale) {
            return new TypeInfo(name, category, precision, scale);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.category();
        }

        public Option<String> copy$default$3() {
            return this.precision();
        }

        public Option<String> copy$default$4() {
            return this.scale();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.category();
        }

        public Option<String> _3() {
            return this.precision();
        }

        public Option<String> _4() {
            return this.scale();
        }
    }
}

