/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.engine;

import java.io.Serializable;
import org.beangle.commons.lang.Numbers$;
import org.beangle.jdbc.engine.AbstractDialect;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.engine.Engine$;
import org.beangle.jdbc.engine.Options;
import org.beangle.jdbc.engine.StoreCase;
import org.beangle.jdbc.engine.StoreCase$;
import org.beangle.jdbc.engine.SystemFunctions;
import org.beangle.jdbc.engine.TypeNames;
import org.beangle.jdbc.engine.Version;
import org.beangle.jdbc.meta.MetadataLoadSql;
import org.beangle.jdbc.meta.SqlType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class AbstractEngine
implements Engine,
AbstractDialect {
    private Options options;
    private TypeNames typeNames;
    private final TypeNames.Builder typeMappingBuilder;
    private final SystemFunctions systemFunctions;
    private MetadataLoadSql metadataLoadSql;
    private Set keywords;

    public AbstractEngine() {
        AbstractDialect.$init$(this);
        this.typeMappingBuilder = new TypeNames.Builder();
        this.systemFunctions = new SystemFunctions();
        this.metadataLoadSql = new MetadataLoadSql();
        this.keywords = Predef$.MODULE$.Set().empty();
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public void options_$eq(Options x$1) {
        this.options = x$1;
    }

    public TypeNames typeNames() {
        return this.typeNames;
    }

    public void typeNames_$eq(TypeNames x$1) {
        this.typeNames = x$1;
    }

    @Override
    public SystemFunctions systemFunctions() {
        return this.systemFunctions;
    }

    @Override
    public MetadataLoadSql metadataLoadSql() {
        return this.metadataLoadSql;
    }

    public void metadataLoadSql_$eq(MetadataLoadSql x$1) {
        this.metadataLoadSql = x$1;
    }

    @Override
    public Set<String> keywords() {
        return this.keywords;
    }

    public void keywords_$eq(Set<String> x$1) {
        this.keywords = x$1;
    }

    @Override
    public abstract Version version();

    public void registerReserved(String resourceName) {
        this.keywords_$eq((Set<String>)((Set)this.keywords().$plus$plus(Engine$.MODULE$.loadKeywords(resourceName))));
    }

    @Override
    public Tuple2<Object, Object> quoteChars() {
        return new Tuple2.mcCC.sp('\"', '\"');
    }

    @Override
    public int maxIdentifierLength() {
        return 128;
    }

    public void registerTypes(Seq<Tuple2<Object, String>> tuples) {
        tuples.foreach((Function1)(JProcedure1 & Serializable)tuple -> this.typeMappingBuilder.put(BoxesRunTime.unboxToInt((Object)tuple._1()), (String)tuple._2()));
        this.typeNames_$eq(this.typeMappingBuilder.build());
    }

    public void registerTypes2(Seq<Tuple3<Object, Object, String>> tuples) {
        tuples.foreach((Function1)(JProcedure1 & Serializable)tuple -> this.typeMappingBuilder.put(BoxesRunTime.unboxToInt((Object)tuple._1()), BoxesRunTime.unboxToInt((Object)tuple._2()), (String)tuple._3()));
        this.typeNames_$eq(this.typeMappingBuilder.build());
    }

    @Override
    public SqlType toType(String typeName) {
        return this.typeNames().toType(typeName);
    }

    @Override
    public final SqlType toType(int sqlCode) {
        return this.toType(sqlCode, 0, 0);
    }

    @Override
    public final SqlType toType(int sqlCode, int precision) {
        return this.toType(sqlCode, precision, 0);
    }

    @Override
    public SqlType toType(int sqlCode, int precision, int scale) {
        return this.typeNames().toType(sqlCode, precision, scale);
    }

    @Override
    public boolean supportBoolean() {
        return true;
    }

    public void functions(Function1<SystemFunctions, BoxedUnit> f) {
        f.apply((Object)this.systemFunctions());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Option<String> convert(SqlType sqlType, String value2) {
        if (value2 == null) {
            return None$.MODULE$;
        }
        if (sqlType.isNumberType() || sqlType.isBooleanType() && !this.supportBoolean()) {
            String string = value2;
            if ("true".equals(string)) {
                return Some$.MODULE$.apply((Object)"1");
            }
            if (!"false".equals(string)) return Some$.MODULE$.apply((Object)value2).filter((Function1 & Serializable)str -> Numbers$.MODULE$.isDigits(str));
            return Some$.MODULE$.apply((Object)"0");
        }
        if (sqlType.isBooleanType()) {
            String string = value2;
            switch (string == null ? 0 : string.hashCode()) {
                case 48: {
                    if ("0".equals(string)) return Some$.MODULE$.apply((Object)"false");
                    return None$.MODULE$;
                }
                case 49: {
                    if ("1".equals(string)) return Some$.MODULE$.apply((Object)"true");
                    return None$.MODULE$;
                }
                case 78: {
                    if ("N".equals(string)) return Some$.MODULE$.apply((Object)"false");
                    return None$.MODULE$;
                }
                case 89: {
                    if ("Y".equals(string)) return Some$.MODULE$.apply((Object)"true");
                    return None$.MODULE$;
                }
                case 3521: {
                    if ("no".equals(string)) return Some$.MODULE$.apply((Object)"false");
                    return None$.MODULE$;
                }
                case 119527: {
                    if ("yes".equals(string)) return Some$.MODULE$.apply((Object)"true");
                    return None$.MODULE$;
                }
                case 3569038: {
                    if ("true".equals(string)) return Some$.MODULE$.apply((Object)"true");
                    return None$.MODULE$;
                }
                case 97196323: {
                    if ("false".equals(string)) return Some$.MODULE$.apply((Object)"false");
                    return None$.MODULE$;
                }
            }
            return None$.MODULE$;
        }
        if (!sqlType.isTemporalType()) return Option$.MODULE$.apply((Object)value2);
        return Option$.MODULE$.apply((Object)this.systemFunctions().current(sqlType));
    }

    @Override
    public StoreCase storeCase() {
        return StoreCase$.Mixed;
    }

    @Override
    public boolean catalogAsSchema() {
        return false;
    }

    @Override
    public Seq<String> systemSchemas() {
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"information_schema"}));
    }
}

