/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc.ds;

import java.io.Serializable;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings$;
import org.beangle.jdbc.ds.DatasourceConfig;
import org.beangle.jdbc.ds.Source$;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.meta.Identifier;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class Source
implements Product,
Serializable {
    private final String name;
    private final Engine engine;
    private final DataSource dataSource;
    private final Option catalog;
    private final Option schema;

    public static Source apply(DataSource dataSource) {
        return Source$.MODULE$.apply(dataSource);
    }

    public static Source apply(DatasourceConfig datasourceConfig) {
        return Source$.MODULE$.apply(datasourceConfig);
    }

    public static Source apply(String string, DataSource dataSource, Option<Identifier> option, Option<Identifier> option2) {
        return Source$.MODULE$.apply(string, dataSource, option, option2);
    }

    public static Source apply(String string, Engine engine, DataSource dataSource, Option<Identifier> option, Option<Identifier> option2) {
        return Source$.MODULE$.apply(string, engine, dataSource, option, option2);
    }

    public static Source fromProduct(Product product) {
        return Source$.MODULE$.fromProduct(product);
    }

    public static Source unapply(Source source) {
        return Source$.MODULE$.unapply(source);
    }

    public Source(String name, Engine engine, DataSource dataSource, Option<Identifier> catalog, Option<Identifier> schema) {
        this.name = name;
        this.engine = engine;
        this.dataSource = dataSource;
        this.catalog = catalog;
        this.schema = schema;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Source)) return false;
        Source source = (Source)object;
        String string = this.name();
        String string2 = source.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Engine engine = this.engine();
        Engine engine2 = source.engine();
        if (engine == null) {
            if (engine2 != null) {
                return false;
            }
        } else if (!engine.equals(engine2)) return false;
        DataSource dataSource = this.dataSource();
        DataSource dataSource2 = source.dataSource();
        if (dataSource == null) {
            if (dataSource2 != null) {
                return false;
            }
        } else if (!dataSource.equals(dataSource2)) return false;
        Option<Identifier> option = this.catalog();
        Option<Identifier> option2 = source.catalog();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Identifier> option3 = this.schema();
        Option<Identifier> option4 = source.schema();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!source.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Source;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "Source";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "name";
            }
            case 1: {
                return "engine";
            }
            case 2: {
                return "dataSource";
            }
            case 3: {
                return "catalog";
            }
            case 4: {
                return "schema";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String name() {
        return this.name;
    }

    public Engine engine() {
        return this.engine;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public Option<Identifier> catalog() {
        return this.catalog;
    }

    public Option<Identifier> schema() {
        return this.schema;
    }

    public Tuple2<Option<Identifier>, Identifier> parse(String schemaName) {
        if (schemaName.isBlank()) {
            return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)this.engine().toIdentifier(this.engine().defaultSchema()));
        }
        if (schemaName.contains(".")) {
            String c = Strings$.MODULE$.substringBefore(schemaName, ".");
            String s = Strings$.MODULE$.substringBefore(schemaName, ".");
            return Tuple2$.MODULE$.apply((Object)Option$.MODULE$.apply((Object)this.engine().toIdentifier(c)), (Object)this.engine().toIdentifier(s));
        }
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)this.engine().toIdentifier(schemaName));
    }

    public Source copy(String name, Engine engine, DataSource dataSource, Option<Identifier> catalog, Option<Identifier> schema) {
        return new Source(name, engine, dataSource, catalog, schema);
    }

    public String copy$default$1() {
        return this.name();
    }

    public Engine copy$default$2() {
        return this.engine();
    }

    public DataSource copy$default$3() {
        return this.dataSource();
    }

    public Option<Identifier> copy$default$4() {
        return this.catalog();
    }

    public Option<Identifier> copy$default$5() {
        return this.schema();
    }

    public String _1() {
        return this.name();
    }

    public Engine _2() {
        return this.engine();
    }

    public DataSource _3() {
        return this.dataSource();
    }

    public Option<Identifier> _4() {
        return this.catalog();
    }

    public Option<Identifier> _5() {
        return this.schema();
    }
}

