/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.jdbc;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;
import org.beangle.commons.lang.Enums$;
import org.beangle.commons.lang.annotation.value;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.time.WeekState;
import org.beangle.jdbc.SqlTypeMapping;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.meta.SqlType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DefaultSqlTypeMapping
implements SqlTypeMapping {
    private final Engine engine;
    private final Map<Class<?>, Object> concretTypes;
    private final Map<Class<?>, Object> generalTypes;

    public DefaultSqlTypeMapping(Engine engine) {
        this.engine = engine;
        this.concretTypes = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(Boolean.TYPE, (Object)BoxesRunTime.boxToInteger((int)16)), Tuple2$.MODULE$.apply(Boolean.class, (Object)BoxesRunTime.boxToInteger((int)16)), Tuple2$.MODULE$.apply(Byte.class, (Object)BoxesRunTime.boxToInteger((int)-6)), Tuple2$.MODULE$.apply(Byte.TYPE, (Object)BoxesRunTime.boxToInteger((int)-6)), Tuple2$.MODULE$.apply(Short.TYPE, (Object)BoxesRunTime.boxToInteger((int)5)), Tuple2$.MODULE$.apply(Short.class, (Object)BoxesRunTime.boxToInteger((int)5)), Tuple2$.MODULE$.apply(Integer.TYPE, (Object)BoxesRunTime.boxToInteger((int)4)), Tuple2$.MODULE$.apply(Integer.class, (Object)BoxesRunTime.boxToInteger((int)4)), Tuple2$.MODULE$.apply(Long.TYPE, (Object)BoxesRunTime.boxToInteger((int)-5)), Tuple2$.MODULE$.apply(Long.class, (Object)BoxesRunTime.boxToInteger((int)-5)), Tuple2$.MODULE$.apply(BigInteger.class, (Object)BoxesRunTime.boxToInteger((int)-5)), Tuple2$.MODULE$.apply(Float.TYPE, (Object)BoxesRunTime.boxToInteger((int)7)), Tuple2$.MODULE$.apply(Float.class, (Object)BoxesRunTime.boxToInteger((int)7)), Tuple2$.MODULE$.apply(Double.TYPE, (Object)BoxesRunTime.boxToInteger((int)8)), Tuple2$.MODULE$.apply(Double.class, (Object)BoxesRunTime.boxToInteger((int)8)), Tuple2$.MODULE$.apply(BigDecimal.class, (Object)BoxesRunTime.boxToInteger((int)3)), Tuple2$.MODULE$.apply(Character.TYPE, (Object)BoxesRunTime.boxToInteger((int)1)), Tuple2$.MODULE$.apply(Character.class, (Object)BoxesRunTime.boxToInteger((int)1)), Tuple2$.MODULE$.apply(String.class, (Object)BoxesRunTime.boxToInteger((int)12)), Tuple2$.MODULE$.apply(Date.class, (Object)BoxesRunTime.boxToInteger((int)91)), Tuple2$.MODULE$.apply(LocalDate.class, (Object)BoxesRunTime.boxToInteger((int)91)), Tuple2$.MODULE$.apply(YearMonth.class, (Object)BoxesRunTime.boxToInteger((int)91)), Tuple2$.MODULE$.apply(Time.class, (Object)BoxesRunTime.boxToInteger((int)92)), Tuple2$.MODULE$.apply(LocalTime.class, (Object)BoxesRunTime.boxToInteger((int)92)), Tuple2$.MODULE$.apply(Timestamp.class, (Object)BoxesRunTime.boxToInteger((int)93)), Tuple2$.MODULE$.apply(java.util.Date.class, (Object)BoxesRunTime.boxToInteger((int)93)), Tuple2$.MODULE$.apply(Calendar.class, (Object)BoxesRunTime.boxToInteger((int)93)), Tuple2$.MODULE$.apply(LocalDateTime.class, (Object)BoxesRunTime.boxToInteger((int)93)), Tuple2$.MODULE$.apply(Instant.class, (Object)BoxesRunTime.boxToInteger((int)2014)), Tuple2$.MODULE$.apply(OffsetDateTime.class, (Object)BoxesRunTime.boxToInteger((int)2014)), Tuple2$.MODULE$.apply(ZonedDateTime.class, (Object)BoxesRunTime.boxToInteger((int)2014)), Tuple2$.MODULE$.apply(Locale.class, (Object)BoxesRunTime.boxToInteger((int)12)), Tuple2$.MODULE$.apply(Duration.class, (Object)BoxesRunTime.boxToInteger((int)-5)), Tuple2$.MODULE$.apply(HourMinute.class, (Object)BoxesRunTime.boxToInteger((int)5)), Tuple2$.MODULE$.apply(WeekState.class, (Object)BoxesRunTime.boxToInteger((int)-5)), Tuple2$.MODULE$.apply(Year.class, (Object)BoxesRunTime.boxToInteger((int)4)), Tuple2$.MODULE$.apply(Clob.class, (Object)BoxesRunTime.boxToInteger((int)2005)), Tuple2$.MODULE$.apply(Blob.class, (Object)BoxesRunTime.boxToInteger((int)2004)), Tuple2$.MODULE$.apply(byte[].class, (Object)BoxesRunTime.boxToInteger((int)-3))}));
        this.generalTypes = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(java.util.Date.class, (Object)BoxesRunTime.boxToInteger((int)93)), Tuple2$.MODULE$.apply(CharSequence.class, (Object)BoxesRunTime.boxToInteger((int)12)), Tuple2$.MODULE$.apply(Number.class, (Object)BoxesRunTime.boxToInteger((int)2))}));
    }

    @Override
    public int sqlCode(Class<?> clazz) {
        Option option = this.concretTypes.get(clazz);
        if (option instanceof Some) {
            int c = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return c;
        }
        if (None$.MODULE$.equals(option)) {
            Tuple2 tuple2;
            Option finded = this.generalTypes.find((Function1 & Serializable)_$1 -> ((Class)_$1._1()).isAssignableFrom(clazz));
            Option option2 = finded;
            if (option2 instanceof Some && (tuple2 = (Tuple2)((Some)option2).value()) != null) {
                int tc = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return tc;
            }
            if (None$.MODULE$.equals(option2)) {
                if (clazz.isAnnotationPresent(value.class)) {
                    Constructor<?>[] ctors = clazz.getConstructors();
                    Class<?> find = null;
                    for (int i = 0; find == null && i < ctors.length; ++i) {
                        Constructor<?> ctor = ctors[i];
                        Parameter[] params = ctor.getParameters();
                        if (params.length != 1) continue;
                        find = params[0].getType();
                    }
                    return BoxesRunTime.unboxToInt((Object)this.concretTypes.getOrElse(find, () -> this.sqlCode$$anonfun$1(clazz)));
                }
                if (Enums$.MODULE$.isEnum(clazz)) {
                    return 4;
                }
                return this.raiseMappingError(clazz);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private int raiseMappingError(Class<?> clazz) {
        throw new RuntimeException("Cannot find sqltype for " + clazz.getName());
    }

    @Override
    public SqlType sqlType(Class<?> clazz) {
        int sqlTypeCode = this.sqlCode(clazz);
        if (sqlTypeCode == 12) {
            return this.engine.toType(sqlTypeCode, 255);
        }
        return this.engine.toType(sqlTypeCode);
    }

    private final int sqlCode$$anonfun$1(Class clazz$2) {
        return this.raiseMappingError(clazz$2);
    }
}

