/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ids.cas.web.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.codec.binary.Aes;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.ids.cas.CasSetting;
import org.beangle.ids.cas.service.CasService;
import org.beangle.ids.cas.service.UsernameValidator$;
import org.beangle.ids.cas.ticket.TicketRegistry;
import org.beangle.ids.cas.web.action.LogoutAction;
import org.beangle.ids.cas.web.helper.CaptchaHelper;
import org.beangle.ids.cas.web.helper.CsrfDefender;
import org.beangle.ids.cas.web.helper.SessionHelper$;
import org.beangle.security.Securities$;
import org.beangle.security.authc.AuthenticationException;
import org.beangle.security.authc.AuthenticationToken;
import org.beangle.security.authc.BadCredentialException;
import org.beangle.security.authc.DBCredentialStore;
import org.beangle.security.authc.PasswordPolicyProvider;
import org.beangle.security.authc.PasswordStrengthChecker$;
import org.beangle.security.authc.UsernamePasswordToken;
import org.beangle.security.context.SecurityContext$;
import org.beangle.security.session.Session;
import org.beangle.security.web.EntryPoint;
import org.beangle.security.web.WebSecurityManager;
import org.beangle.security.web.access.SecurityContextBuilder;
import org.beangle.security.web.session.CookieSessionIdPolicy;
import org.beangle.web.action.To;
import org.beangle.web.action.annotation.ignore;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.MessageSupport;
import org.beangle.web.action.support.ParamSupport;
import org.beangle.web.action.support.RouteSupport;
import org.beangle.web.action.support.ServletSupport;
import org.beangle.web.action.view.Status$;
import org.beangle.web.action.view.View;
import org.beangle.web.servlet.url.UrlBuilder;
import org.beangle.web.servlet.util.CookieUtils$;
import org.beangle.web.servlet.util.RequestUtils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class LoginAction
implements MessageSupport,
RouteSupport,
ParamSupport,
Logging,
ActionSupport,
ServletSupport,
Initializing {
    private Logger logger;
    private final WebSecurityManager secuirtyManager;
    private final TicketRegistry ticketRegistry;
    private CsrfDefender csrfDefender;
    private CasSetting setting;
    private CaptchaHelper captchaHelper;
    private CasService casService;
    private EntryPoint entryPoint;
    private PasswordPolicyProvider passwordPolicyProvider;
    private DBCredentialStore credentialStore;
    private SecurityContextBuilder securityContextBuilder;

    public LoginAction(WebSecurityManager secuirtyManager, TicketRegistry ticketRegistry) {
        this.secuirtyManager = secuirtyManager;
        this.ticketRegistry = ticketRegistry;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public CasSetting setting() {
        return this.setting;
    }

    public void setting_$eq(CasSetting x$1) {
        this.setting = x$1;
    }

    public CaptchaHelper captchaHelper() {
        return this.captchaHelper;
    }

    public void captchaHelper_$eq(CaptchaHelper x$1) {
        this.captchaHelper = x$1;
    }

    public CasService casService() {
        return this.casService;
    }

    public void casService_$eq(CasService x$1) {
        this.casService = x$1;
    }

    public EntryPoint entryPoint() {
        return this.entryPoint;
    }

    public void entryPoint_$eq(EntryPoint x$1) {
        this.entryPoint = x$1;
    }

    public PasswordPolicyProvider passwordPolicyProvider() {
        return this.passwordPolicyProvider;
    }

    public void passwordPolicyProvider_$eq(PasswordPolicyProvider x$1) {
        this.passwordPolicyProvider = x$1;
    }

    public DBCredentialStore credentialStore() {
        return this.credentialStore;
    }

    public void credentialStore_$eq(DBCredentialStore x$1) {
        this.credentialStore = x$1;
    }

    public SecurityContextBuilder securityContextBuilder() {
        return this.securityContextBuilder;
    }

    public void securityContextBuilder_$eq(SecurityContextBuilder x$1) {
        this.securityContextBuilder = x$1;
    }

    public void init() {
        this.csrfDefender = new CsrfDefender(this.setting().key(), this.setting().origin());
    }

    @mapping(value="")
    public View index(@param(value="service", required=false) String service) {
        Option option = this.get("logoutRequest");
        if (!None$.MODULE$.equals(option)) {
            if (option instanceof Some) {
                String d = (String)((Some)option).value();
                if (Securities$.MODULE$.session().isDefined()) {
                    return this.redirect((To)this.to(LogoutAction.class, "index"), null);
                }
                return null;
            }
            throw new MatchError((Object)option);
        }
        Option option2 = Securities$.MODULE$.session();
        if (option2 instanceof Some) {
            Session session = (Session)((Some)option2).value();
            return this.forwardService(service, session);
        }
        if (None$.MODULE$.equals(option2)) {
            Option u = this.get("username");
            Option p = this.get("password");
            if (Strings$.MODULE$.isBlank((CharSequence)u.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())) || Strings$.MODULE$.isBlank((CharSequence)p.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))) {
                return this.toLoginForm(this.request(), service);
            }
            boolean isService = this.getBoolean("isService", false);
            boolean validCsrf = isService || this.csrfDefender.valid(this.request(), this.response());
            String username = ((String)u.get()).trim();
            if (validCsrf) {
                View view;
                if (!isService && this.setting().enableCaptcha() && !this.captchaHelper().verify(this.request(), this.response())) {
                    this.put("error", "\u9519\u8bef\u7684\u9a8c\u8bc1\u7801");
                    return this.toLoginForm(this.request(), service);
                }
                if (UsernameValidator$.MODULE$.illegal(username)) {
                    this.put("error", "\u975e\u6cd5\u7528\u6237\u540d");
                    return this.toLoginForm(this.request(), service);
                }
                if (this.overMaxFailure(username)) {
                    this.put("error", "\u5bc6\u7801\u9519\u8bef\u4e09\u6b21\u4ee5\u4e0a\uff0c\u6682\u505c\u767b\u5f55");
                    return this.toLoginForm(this.request(), service);
                }
                String password = (String)p.get();
                if (password.startsWith("?")) {
                    password = Aes.ECB$.MODULE$.decodeHex(this.loginKey(), password.substring(1), Aes.ECB$.MODULE$.decodeHex$default$3());
                }
                UsernamePasswordToken token = new UsernamePasswordToken((Object)username, (Object)password);
                try {
                    HttpServletRequest req = this.request();
                    if (this.setting().passwordReadOnly()) {
                        token.addDetail("credentialReadOnly", (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    Session session = this.secuirtyManager.login(req, this.response(), (AuthenticationToken)token);
                    SecurityContext$.MODULE$.set(this.securityContextBuilder().build(req, (Option)Some$.MODULE$.apply((Object)session)));
                    if (isService) {
                        view = this.forwardService(service, session);
                    } else if (this.setting().passwordReadOnly()) {
                        view = this.forwardService(service, session);
                    } else {
                        BooleanRef credentialOk = BooleanRef.create((boolean)true);
                        ObjectRef msg = ObjectRef.create((Object)"");
                        if (this.setting().checkPasswordStrength()) {
                            boolean bl;
                            credentialOk.elem = bl = PasswordStrengthChecker$.MODULE$.check(password, this.passwordPolicyProvider().getPolicy());
                            String string = "\u68c0\u6d4b\u5230\u5f31\u5bc6\u7801\uff0c\u8bf7\u4fee\u6539";
                            msg.elem = string;
                            string = null;
                        }
                        if (credentialOk.elem) {
                            this.credentialStore().getAge((Object)username).foreach((Function1)(JProcedure1 & Serializable)age -> {
                                boolean bl;
                                credentialOk$1.elem = bl = !age.expired();
                                String string = "\u5bc6\u7801\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u4fee\u6539";
                                msg$1.elem = string;
                                string = null;
                            });
                        }
                        view = !credentialOk.elem ? this.redirect((To)this.to("/edit", (String)(Strings$.MODULE$.isNotBlank((CharSequence)service) ? "service=" + service : "")), (String)msg.elem) : this.forwardService(service, session);
                    }
                }
                catch (AuthenticationException e) {
                    String msg = this.casService().getMesage((Exception)((Object)e));
                    this.put("error", msg);
                    if (e instanceof BadCredentialException) {
                        this.rememberFailue(username);
                    }
                    view = this.toLoginForm(this.request(), service);
                }
                return view;
            }
            return null;
        }
        throw new MatchError((Object)option2);
    }

    public boolean overMaxFailure(String princial) {
        String p = princial.replace("@", "_");
        String c = CookieUtils$.MODULE$.getCookieValue(this.request(), "failure_" + p);
        int failure = 0;
        if (Strings$.MODULE$.isNotBlank((CharSequence)c)) {
            failure = Numbers$.MODULE$.toInt(c, Numbers$.MODULE$.toInt$default$2());
        }
        return failure >= 3;
    }

    public void rememberFailue(String princial) {
        String p = princial.replace("@", "_");
        String c = CookieUtils$.MODULE$.getCookieValue(this.request(), "failure_" + p);
        int failure = 1;
        if (Strings$.MODULE$.isNotBlank((CharSequence)c)) {
            failure = Numbers$.MODULE$.toInt(c, Numbers$.MODULE$.toInt$default$2()) + 1;
        }
        CookieUtils$.MODULE$.addCookie(this.request(), this.response(), "failure_" + p, BoxesRunTime.boxToInteger((int)failure).toString(), 300);
    }

    @ignore
    public View toLoginForm(HttpServletRequest req, String service) {
        if (this.entryPoint().isLocalLogin(req, null)) {
            if (this.casService().isValidClient(service)) {
                if (req.getParameter("gateway") != null && Strings$.MODULE$.isNotBlank((CharSequence)service)) {
                    return this.redirectService(this.response(), service);
                }
                if (this.setting().forceHttps() && !RequestUtils$.MODULE$.isHttps(this.request())) {
                    UrlBuilder builder = new UrlBuilder(req.getContextPath());
                    builder.setScheme("https").setServerName(req.getServerName()).setPort(443).setContextPath(req.getContextPath()).setServletPath("/login").setQueryString(req.getQueryString());
                    return this.redirectService(this.response(), builder.buildUrl());
                }
                this.csrfDefender.addToken(req, this.response());
                this.put("setting", this.setting());
                if (this.setting().enableCaptcha()) {
                    this.put("captcha_url", this.captchaHelper().generateCaptchaUrl(this.request(), this.response()));
                }
                this.put("current_timestamp", BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
                return this.forward("index");
            }
            this.response().getWriter().write("Invalid client");
            return Status$.MODULE$.Forbidden();
        }
        this.entryPoint().remoteLogin(req, this.response());
        return null;
    }

    public View success() {
        this.put("logined", BoxesRunTime.boxToBoolean((boolean)Securities$.MODULE$.session().isDefined()));
        return this.forward(this.forward$default$1());
    }

    private View forwardService(String service, Session session) {
        if (service == null) {
            return this.redirect("success", null);
        }
        CookieSessionIdPolicy idPolicy = (CookieSessionIdPolicy)this.secuirtyManager.sessionIdPolicy();
        boolean isMember = SessionHelper$.MODULE$.isMember(this.request(), service, idPolicy);
        if (isMember) {
            if (SessionHelper$.MODULE$.isSameDomain(this.request(), service, idPolicy)) {
                return this.redirectService(this.response(), service);
            }
            if (this.casService().isValidClient(service)) {
                String serviceWithSid = service + (service.contains("?") ? "&" : "?") + idPolicy.name() + "=" + session.id();
                return this.redirectService(this.response(), serviceWithSid);
            }
            this.response().getWriter().write("Invalid client");
            return Status$.MODULE$.Forbidden();
        }
        if (this.casService().isValidClient(service)) {
            String ticket = this.ticketRegistry.generate(session, service);
            return this.redirectService(this.response(), service + (service.contains("?") ? "&" : "?") + "ticket=" + ticket);
        }
        this.response().getWriter().write("Invalid client");
        return Status$.MODULE$.Forbidden();
    }

    private View redirectService(HttpServletResponse response, String service) {
        response.sendRedirect(service);
        return null;
    }

    private String loginKey() {
        String serverName = this.request().getServerName();
        if (serverName.length() >= 16) {
            return serverName.substring(0, 16);
        }
        return Strings$.MODULE$.rightPad(serverName, 16, '0');
    }
}

