/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ids.cas.web.helper;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URL;
import java.security.SecureRandom;
import org.beangle.commons.codec.binary.Hex$;
import org.beangle.commons.codec.digest.Digests$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.web.servlet.util.CookieUtils$;
import org.slf4j.Logger;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;

public class CsrfDefender
implements Logging {
    private Logger logger;
    private final String key;
    private final URL target;
    private String tokenName;
    private final SecureRandom secureRandom;

    public CsrfDefender(String key, URL target) {
        this.key = key;
        this.target = target;
        Logging.$init$((Logging)this);
        this.tokenName = "CSRF_TOKEN";
        this.secureRandom = new SecureRandom();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public String tokenName() {
        return this.tokenName;
    }

    public void tokenName_$eq(String x$1) {
        this.tokenName = x$1;
    }

    public SecureRandom secureRandom() {
        return this.secureRandom;
    }

    public CsrfDefender(String key, String origin) {
        this(key, new URL(origin));
    }

    public boolean validSource(HttpServletRequest req) {
        boolean bl;
        block5: {
            ObjectRef source = ObjectRef.create((Object)req.getHeader("Origin"));
            if (Strings$.MODULE$.isBlank((CharSequence)((String)source.elem))) {
                String string = req.getHeader("Referer");
                source.elem = string;
                string = null;
                if (Strings$.MODULE$.isBlank((CharSequence)((String)source.elem))) {
                    return false;
                }
            }
            try {
                URL sourceURL = new URL((String)source.elem);
                if (!this.target.getProtocol().equals(sourceURL.getProtocol()) || !this.target.getHost().equals(sourceURL.getHost()) || this.target.getPort() != sourceURL.getPort()) {
                    bl = false;
                    break block5;
                }
                bl = true;
            }
            catch (Throwable e) {
                Logger$.MODULE$.error$extension(this.logger(), () -> CsrfDefender.validSource$$anonfun$1(source, e));
                bl = false;
            }
        }
        return bl;
    }

    public boolean valid(HttpServletRequest req, HttpServletResponse res) {
        if (!req.getMethod().equalsIgnoreCase("POST")) {
            res.sendError(403, "Only Support Http post method.");
            return false;
        }
        if (this.validSource(req)) {
            String token = CookieUtils$.MODULE$.getCookieValue(req, this.tokenName());
            if (Strings$.MODULE$.isEmpty((CharSequence)token) || !this.valid(token)) {
                res.sendError(403, "CSRFToken is absent or invalid.");
                return false;
            }
            CookieUtils$.MODULE$.deleteCookieByName(req, res, this.tokenName());
            return true;
        }
        res.sendError(403, "Invalid source.");
        return false;
    }

    public void addToken(HttpServletRequest req, HttpServletResponse res) {
        CookieUtils$.MODULE$.addCookie(req, res, this.tokenName(), this.generateToken(), -1);
    }

    public String generateToken() {
        byte[] buffer = new byte[25];
        this.secureRandom().nextBytes(buffer);
        String token = Hex$.MODULE$.encode(buffer, Hex$.MODULE$.encode$default$2());
        String hash = Digests$.MODULE$.md5Hex(token + this.key);
        return token + hash.substring(0, 10);
    }

    private boolean valid(String token) {
        if (token.length() != 60) {
            return false;
        }
        String t = token.substring(0, 50);
        String string = Digests$.MODULE$.md5Hex(t + this.key).substring(0, 10);
        String string2 = token.substring(50);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final String validSource$$anonfun$1(ObjectRef source$1, Throwable e$1) {
        return "error source:" + (String)source$1.elem + " for " + e$1.getMessage();
    }
}

