/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ids.cas.web.helper;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.SecureRandom;
import org.beangle.commons.codec.binary.Hex$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.commons.net.http.Response;
import org.beangle.web.servlet.util.CookieUtils$;

public class CaptchaHelper {
    private final String captchaBaseUrl;
    private final String imageUrlPattern;
    private final String verifyUrlPattern;
    private final SecureRandom secureRandom;
    private final String cookieName;

    public CaptchaHelper(String captchaBaseUrl) {
        this.captchaBaseUrl = captchaBaseUrl;
        this.imageUrlPattern = captchaBaseUrl + "/captcha/image/{id}.jpg";
        this.verifyUrlPattern = captchaBaseUrl + "/captcha/validate/{id}?response={response}";
        this.secureRandom = new SecureRandom();
        this.cookieName = "CAPTCHA_ID";
    }

    public String captchaBaseUrl() {
        return this.captchaBaseUrl;
    }

    public String imageUrlPattern() {
        return this.imageUrlPattern;
    }

    public String verifyUrlPattern() {
        return this.verifyUrlPattern;
    }

    public SecureRandom secureRandom() {
        return this.secureRandom;
    }

    public String cookieName() {
        return this.cookieName;
    }

    public String generateCaptchaUrl(HttpServletRequest request, HttpServletResponse response2) {
        byte[] buffer = new byte[25];
        this.secureRandom().nextBytes(buffer);
        String captchaId = Hex$.MODULE$.encode(buffer, Hex$.MODULE$.encode$default$2());
        CookieUtils$.MODULE$.addCookie(request, response2, this.cookieName(), captchaId, -1);
        return Strings$.MODULE$.replace(this.imageUrlPattern(), "{id}", captchaId);
    }

    public boolean verify(HttpServletRequest request, HttpServletResponse response2) {
        boolean bl;
        block5: {
            String captchaId = CookieUtils$.MODULE$.getCookieValue(request, this.cookieName());
            CookieUtils$.MODULE$.deleteCookieByName(request, response2, this.cookieName());
            if (captchaId == null) {
                bl = false;
            } else {
                try {
                    String verifyUrl = Strings$.MODULE$.replace(this.verifyUrlPattern(), "{id}", captchaId);
                    verifyUrl = Strings$.MODULE$.replace(verifyUrl, "{response}", request.getParameter("captcha_response"));
                    Response rs = HttpUtils$.MODULE$.getText(verifyUrl);
                    if (rs.isOk() && rs.getText().contains("success")) {
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
            }
        }
        return bl;
    }
}

