/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ids.cas.web.action;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.logging.Logging;
import org.beangle.security.session.Session;
import org.beangle.security.session.SessionRegistry;
import org.beangle.security.web.WebSecurityManager;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.response;
import org.beangle.web.action.context.ActionContext$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.MessageSupport;
import org.beangle.web.action.support.ParamSupport;
import org.beangle.web.action.support.RouteSupport;
import org.beangle.web.action.view.Status$;
import org.beangle.web.action.view.View;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.runtime.Statics;

public class SessionAction
implements MessageSupport,
RouteSupport,
ParamSupport,
Logging,
ActionSupport {
    private Logger logger;
    private final WebSecurityManager secuirtyManager;

    public SessionAction(WebSecurityManager secuirtyManager) {
        this.secuirtyManager = secuirtyManager;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    @mapping(value="{id}")
    @response
    public Object index(String id) {
        Session session;
        Option option = this.secuirtyManager.registry().get(id, false);
        if (option instanceof Some) {
            Session s;
            session = s = (Session)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            session = this.notfound(id);
        } else {
            throw new MatchError((Object)option);
        }
        return session;
    }

    @mapping(value="{principal}/ids")
    public View ids(String principal) {
        String ids = ((IterableOnceOps)this.secuirtyManager.registry().findByPrincipal(principal).map((Function1 & Serializable)_$1 -> _$1.id())).mkString(",");
        ActionContext$.MODULE$.current().response().getWriter().print(ids);
        return Status$.MODULE$.Ok();
    }

    @mapping(value="{id}/expire")
    @response
    public View expire(String id) {
        View view;
        Option option = this.secuirtyManager.registry().get(id, true);
        if (option instanceof Some) {
            Object object;
            Session s = (Session)((Some)option).value();
            if (s.expired()) {
                this.secuirtyManager.registry().expire(s.id());
                object = "Expire " + id + " successfully.";
            } else {
                object = "Cannot expire live session.";
            }
            String msg = object;
            ActionContext$.MODULE$.current().response().getWriter().print(msg);
            view = Status$.MODULE$.Ok();
        } else if (None$.MODULE$.equals(option)) {
            view = this.notfound(id);
        } else {
            throw new MatchError((Object)option);
        }
        return view;
    }

    @mapping(value="{id}/access")
    @response
    public View access(String id) {
        View view;
        SessionRegistry registry = this.secuirtyManager.registry();
        Option option = registry.get(id, false);
        if (option instanceof Some) {
            Instant instant;
            Session s = (Session)((Some)option).value();
            Option option2 = this.get("time");
            if (option2 instanceof Some) {
                String time = (String)((Some)option2).value();
                instant = Instant.ofEpochSecond(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(time)));
            } else if (None$.MODULE$.equals(option2)) {
                instant = Instant.now();
            } else {
                throw new MatchError((Object)option2);
            }
            Instant accessAt = instant;
            registry.access(s.id(), accessAt);
            ActionContext$.MODULE$.current().response().getWriter().print("ok");
            view = Status$.MODULE$.Ok();
        } else if (None$.MODULE$.equals(option)) {
            view = this.notfound(id);
        } else {
            throw new MatchError((Object)option);
        }
        return view;
    }

    private View notfound(String id) {
        ActionContext$.MODULE$.current().response().getWriter().print("session id " + id + " is not found.");
        return Status$.MODULE$.NotFound();
    }
}

