/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ids.sms.service.impl;

import org.beangle.commons.lang.Strings$;
import org.beangle.ids.sms.service.SmsCacheService;
import org.beangle.ids.sms.service.SmsCodeService;
import org.beangle.ids.sms.service.impl.DefaultSmsCodeService$;
import org.beangle.notify.sms.Receiver;
import org.beangle.notify.sms.SmsResponse;
import org.beangle.notify.sms.SmsSender;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public class DefaultSmsCodeService
implements SmsCodeService {
    private SmsCacheService smsCacheService;
    private SmsSender smsSender;
    private String template = "\u60a8\u7684\u767b\u5f55\u9a8c\u8bc1\u7801\u4e3a{code}\uff0c{ttl}\u5206\u949f\u6709\u6548!";

    public static String generateDefaultCode() {
        return DefaultSmsCodeService$.MODULE$.generateDefaultCode();
    }

    public SmsCacheService smsCacheService() {
        return this.smsCacheService;
    }

    public void smsCacheService_$eq(SmsCacheService x$1) {
        this.smsCacheService = x$1;
    }

    public SmsSender smsSender() {
        return this.smsSender;
    }

    public void smsSender_$eq(SmsSender x$1) {
        this.smsSender = x$1;
    }

    public String template() {
        return this.template;
    }

    public void template_$eq(String x$1) {
        this.template = x$1;
    }

    @Override
    public String send(Receiver receiver) {
        Option<String> option = this.smsCacheService().get(receiver.mobile());
        if (option instanceof Some) {
            String code = (String)((Some)option).value();
            return "\u9a8c\u8bc1\u7801\u5df2\u7ecf\u53d1\u9001";
        }
        if (None$.MODULE$.equals(option)) {
            String code = this.generateCode();
            String contents = Strings$.MODULE$.replace(this.template(), "{code}", code);
            contents = Strings$.MODULE$.replace(contents, "{ttl}", BoxesRunTime.boxToInteger((int)this.smsCacheService().ttlMinutes()).toString());
            SmsResponse res = this.smsSender().send(receiver, contents);
            if (res.isOk()) {
                this.smsCacheService().set(receiver.mobile(), code);
                return "\u9a8c\u8bc1\u7801\u6210\u529f\u53d1\u9001\u5230" + receiver.maskMobile();
            }
            return "\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25:" + res.message();
        }
        throw new MatchError(option);
    }

    @Override
    public boolean verify(String mobile, String code) {
        boolean matched = this.smsCacheService().get(mobile).contains((Object)code);
        if (matched) {
            this.smsCacheService().remove(mobile);
        }
        return matched;
    }

    public String generateCode() {
        return DefaultSmsCodeService$.MODULE$.generateDefaultCode();
    }
}

