/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Objects;
import java.util.function.Function;
import org.apache.maven.artifact.Artifact;
import org.basepom.mojo.duplicatefinder.artifact.ArtifactHelper;

public abstract class ClasspathElement
implements Comparable<ClasspathElement> {
    public abstract String getName();

    public File getFile() {
        throw new UnsupportedOperationException();
    }

    public Artifact getArtifact() {
        throw new UnsupportedOperationException();
    }

    public boolean isLocalFolder() {
        return false;
    }

    public boolean hasArtifact() {
        return false;
    }

    @Override
    public int compareTo(ClasspathElement element) {
        return Ordering.natural().compare((Object)this.getName(), (Object)element.getName());
    }

    public static Function<ClasspathElement, String> getNameFunction() {
        return ClasspathElement::getName;
    }

    public static final class ClasspathLocalFolder
    extends ClasspathElement {
        private final File localFolder;

        public ClasspathLocalFolder(File localFolder) {
            this.localFolder = (File)Preconditions.checkNotNull((Object)localFolder, (Object)"localFolder is null");
            Preconditions.checkState((boolean)localFolder.isDirectory(), (Object)"localFolder must be a directory");
        }

        @Override
        public String getName() {
            return this.localFolder.getAbsolutePath();
        }

        @Override
        public boolean isLocalFolder() {
            return true;
        }

        @Override
        public File getFile() {
            return this.localFolder;
        }

        public int hashCode() {
            return Objects.hashCode(this.localFolder);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ClasspathLocalFolder that = (ClasspathLocalFolder)o;
            return Objects.equals(this.localFolder, that.localFolder);
        }
    }

    public static final class ClasspathArtifact
    extends ClasspathElement {
        private final Artifact artifact;

        public ClasspathArtifact(Artifact artifact) {
            this.artifact = (Artifact)Preconditions.checkNotNull((Object)artifact, (Object)"artifact is null");
        }

        @Override
        public String getName() {
            return Joiner.on((char)':').skipNulls().join((Object)this.artifact.getGroupId(), (Object)this.artifact.getArtifactId(), new Object[]{this.artifact.getVersion(), this.getType(this.artifact), this.getClassifier(this.artifact)});
        }

        private String getType(Artifact artifact) {
            if (ArtifactHelper.isJarArtifact(artifact)) {
                return Strings.nullToEmpty((String)artifact.getClassifier()).isEmpty() ? null : "jar";
            }
            return artifact.getType();
        }

        private String getClassifier(Artifact artifact) {
            if (Strings.nullToEmpty((String)artifact.getClassifier()).isEmpty()) {
                return null;
            }
            if (ArtifactHelper.isTestArtifact(artifact)) {
                return "tests";
            }
            return artifact.getClassifier();
        }

        @Override
        public boolean hasArtifact() {
            return true;
        }

        @Override
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Artifact getArtifact() {
            return this.artifact;
        }

        public int hashCode() {
            return Objects.hash(this.artifact);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ClasspathArtifact that = (ClasspathArtifact)o;
            return Objects.equals(this.artifact, that.artifact);
        }
    }
}

