/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.classpath;

import java.util.Optional;
import org.basepom.mojo.duplicatefinder.classpath.ClasspathDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class TestClasspathDescriptor {
    @Test
    public void testValidIdentifierNames() {
        String[] validNames;
        for (String test : validNames = new String[]{"_.class", "hello/world.class", "test.class", "__auto_generated/from/some/tool.class", "some/inner$thing.class", "some/package/package-info.class", "package-info.class", "some/package/module-info.class", "module-info.class"}) {
            Optional result = ClasspathDescriptor.validateClassName((String)test);
            Assert.assertTrue((String)("Failure for '" + test + "'"), (boolean)result.isPresent());
        }
    }

    @Test
    public void testInvalidIdentifierNames() {
        String[] invalidNames;
        for (String test : invalidNames = new String[]{null, "", "/", "hello.world", "foo/hello.world", "META-INF/test.class", "2.0/foo.class", "foo/bar/baz-blo/tst.class", "META-INF/versions/9/foo/module-info.class", "META-INF/versions/9/foo/package-info.class"}) {
            Optional result = ClasspathDescriptor.validateClassName((String)test);
            Assert.assertFalse((String)("Failure for '" + test + "'"), (boolean)result.isPresent());
        }
    }

    @Test
    public void testMatchDefaultClassnames() {
        String[] validClassNames;
        for (String test : validClassNames = new String[]{"foo$bar", "hello.foo$bar", "package-info", "module-info", "demo.package-info", "foo.module-info"}) {
            Assert.assertTrue((String)("Failure for '" + test + "'"), (boolean)ClasspathDescriptor.DEFAULT_IGNORED_CLASS_PREDICATE.apply(test));
        }
    }
}

