/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.artifact;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.basepom.mojo.duplicatefinder.artifact.MavenCoordinates;
import org.junit.Assert;
import org.junit.Test;

public class TestMavenCoordinates {
    @Test
    public void testCreateFromDependencyBasic() throws Exception {
        Dependency dependency = new Dependency();
        dependency.setGroupId("test.group");
        dependency.setArtifactId("test-artifact");
        dependency.setVersion("1.0");
        MavenCoordinates coordinates = new MavenCoordinates(dependency);
        Assert.assertEquals((Object)"test.group", (Object)coordinates.getGroupId());
        Assert.assertEquals((Object)"test-artifact", (Object)coordinates.getArtifactId());
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertTrue((boolean)coordinates.getVersion().isPresent());
        Assert.assertTrue((boolean)coordinates.getVersionRange().isPresent());
        Assert.assertEquals((Object)new DefaultArtifactVersion("1.0"), coordinates.getVersion().get());
        Assert.assertFalse((boolean)coordinates.getClassifier().isPresent());
    }

    @Test
    public void testCreateFromDependencyWithClassifier() throws Exception {
        Dependency dependency = new Dependency();
        dependency.setGroupId("test.group");
        dependency.setArtifactId("test-artifact");
        dependency.setVersion("1.0");
        dependency.setClassifier("jdk17");
        MavenCoordinates coordinates = new MavenCoordinates(dependency);
        Assert.assertEquals((Object)"test.group", (Object)coordinates.getGroupId());
        Assert.assertEquals((Object)"test-artifact", (Object)coordinates.getArtifactId());
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertTrue((boolean)coordinates.getVersion().isPresent());
        Assert.assertTrue((boolean)coordinates.getVersionRange().isPresent());
        Assert.assertEquals((Object)new DefaultArtifactVersion("1.0"), coordinates.getVersion().get());
        Assert.assertTrue((boolean)coordinates.getClassifier().isPresent());
        Assert.assertEquals((Object)"jdk17", coordinates.getClassifier().get());
    }

    @Test
    public void testCreateFromDependencyWithVersionRange() throws Exception {
        Dependency dependency = new Dependency();
        dependency.setGroupId("test.group");
        dependency.setArtifactId("test-artifact");
        dependency.setVersion("[1.0, 2.0)");
        MavenCoordinates coordinates = new MavenCoordinates(dependency);
        Assert.assertEquals((Object)"test.group", (Object)coordinates.getGroupId());
        Assert.assertEquals((Object)"test-artifact", (Object)coordinates.getArtifactId());
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertTrue((boolean)coordinates.getVersion().isPresent());
        Assert.assertEquals((Object)new DefaultArtifactVersion("[1.0, 2.0)"), coordinates.getVersion().get());
        Assert.assertTrue((boolean)coordinates.getVersionRange().isPresent());
        Assert.assertTrue((boolean)((VersionRange)coordinates.getVersionRange().get()).containsVersion((ArtifactVersion)new DefaultArtifactVersion("1.1")));
        Assert.assertFalse((boolean)((VersionRange)coordinates.getVersionRange().get()).containsVersion((ArtifactVersion)new DefaultArtifactVersion("2.0")));
    }

    @Test
    public void testCreateFromArtifactBasic() throws Exception {
        DefaultArtifact artifact = new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler());
        MavenCoordinates coordinates = new MavenCoordinates((Artifact)artifact);
        Assert.assertEquals((Object)"test.group", (Object)coordinates.getGroupId());
        Assert.assertEquals((Object)"test-artifact", (Object)coordinates.getArtifactId());
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertTrue((boolean)coordinates.getVersion().isPresent());
        Assert.assertTrue((boolean)coordinates.getVersionRange().isPresent());
        Assert.assertEquals((Object)new DefaultArtifactVersion("1.0"), coordinates.getVersion().get());
        Assert.assertFalse((boolean)coordinates.getClassifier().isPresent());
    }

    @Test
    public void testCreateFromArtifactWithClassifier() throws Exception {
        DefaultArtifact artifact = new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", "jdk17", (ArtifactHandler)new DefaultArtifactHandler());
        MavenCoordinates coordinates = new MavenCoordinates((Artifact)artifact);
        Assert.assertEquals((Object)"test.group", (Object)coordinates.getGroupId());
        Assert.assertEquals((Object)"test-artifact", (Object)coordinates.getArtifactId());
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertTrue((boolean)coordinates.getVersion().isPresent());
        Assert.assertTrue((boolean)coordinates.getVersionRange().isPresent());
        Assert.assertEquals((Object)new DefaultArtifactVersion("1.0"), coordinates.getVersion().get());
        Assert.assertTrue((boolean)coordinates.getClassifier().isPresent());
        Assert.assertEquals((Object)"jdk17", coordinates.getClassifier().get());
    }

    @Test
    public void testCreateFromArtifactWithVersionRange() throws Exception {
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)"[1.0, 2.0)");
        DefaultArtifact artifact = new DefaultArtifact("test.group", "test-artifact", versionRange, "test", "jar", "jdk17", (ArtifactHandler)new DefaultArtifactHandler());
        MavenCoordinates coordinates = new MavenCoordinates((Artifact)artifact);
        Assert.assertEquals((Object)"test.group", (Object)coordinates.getGroupId());
        Assert.assertEquals((Object)"test-artifact", (Object)coordinates.getArtifactId());
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertFalse((boolean)coordinates.getVersion().isPresent());
        Assert.assertTrue((boolean)coordinates.getVersionRange().isPresent());
    }

    @Test
    public void testCreateFromArtifactWithVersionRangeRestricted() throws Exception {
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)"[1.0, 2.0)").restrict(VersionRange.createFromVersion((String)"1.2"));
        DefaultArtifact artifact = new DefaultArtifact("test.group", "test-artifact", versionRange, "test", "jar", "jdk17", (ArtifactHandler)new DefaultArtifactHandler());
        MavenCoordinates coordinates = new MavenCoordinates((Artifact)artifact);
        Assert.assertEquals((Object)"test.group", (Object)coordinates.getGroupId());
        Assert.assertEquals((Object)"test-artifact", (Object)coordinates.getArtifactId());
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertTrue((boolean)coordinates.getVersion().isPresent());
        Assert.assertEquals((Object)new DefaultArtifactVersion("1.2"), coordinates.getVersion().get());
        Assert.assertTrue((boolean)coordinates.getVersionRange().isPresent());
    }

    @Test
    public void testTestJar() throws Exception {
        MavenCoordinates coordinates = new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "test-jar", null, (ArtifactHandler)new DefaultArtifactHandler()));
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertTrue((boolean)coordinates.getClassifier().isPresent());
        Assert.assertEquals((Object)"tests", coordinates.getClassifier().get());
        coordinates = new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", "tests", (ArtifactHandler)new DefaultArtifactHandler()));
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertTrue((boolean)coordinates.getClassifier().isPresent());
        Assert.assertEquals((Object)"tests", coordinates.getClassifier().get());
        coordinates = new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "test-jar", "special", (ArtifactHandler)new DefaultArtifactHandler()));
        Assert.assertEquals((Object)"jar", (Object)coordinates.getType());
        Assert.assertTrue((boolean)coordinates.getClassifier().isPresent());
        Assert.assertEquals((Object)"special", coordinates.getClassifier().get());
    }

    @Test
    public void testBasicMismatches() throws Exception {
        Dependency dependency = new Dependency();
        dependency.setGroupId("test.group");
        dependency.setArtifactId("test-artifact");
        dependency.setVersion("1.0");
        MavenCoordinates dependencyCoordinates = new MavenCoordinates(dependency);
        Assert.assertFalse((boolean)dependencyCoordinates.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group2", "test-artifact", "1.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertFalse((boolean)dependencyCoordinates.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact2", "1.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertFalse((boolean)dependencyCoordinates.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "war", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertTrue((boolean)dependencyCoordinates.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertTrue((boolean)dependencyCoordinates.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", "foo", (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertTrue((boolean)dependencyCoordinates.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", "bar", (ArtifactHandler)new DefaultArtifactHandler()))));
        dependency.setClassifier("baz");
        MavenCoordinates dependencyCoordinatesWithClassifier = new MavenCoordinates(dependency);
        Assert.assertTrue((boolean)dependencyCoordinatesWithClassifier.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", "baz", (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertFalse((boolean)dependencyCoordinatesWithClassifier.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertFalse((boolean)dependencyCoordinatesWithClassifier.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", "bar", (ArtifactHandler)new DefaultArtifactHandler()))));
    }

    @Test
    public void testVersionMatches() throws Exception {
        Dependency dependency = new Dependency();
        dependency.setGroupId("test.group");
        dependency.setArtifactId("test-artifact");
        MavenCoordinates dependencyCoordinatesNoVersionNoVersionRange = new MavenCoordinates(dependency);
        Assert.assertTrue((boolean)dependencyCoordinatesNoVersionNoVersionRange.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertTrue((boolean)dependencyCoordinatesNoVersionNoVersionRange.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "2.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        dependency.setVersion("1.0");
        MavenCoordinates dependencyCoordinatesVersion = new MavenCoordinates(dependency);
        Assert.assertFalse((boolean)dependencyCoordinatesVersion.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", VersionRange.createFromVersionSpec((String)"[1.0, 2.0)"), "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertFalse((boolean)dependencyCoordinatesVersion.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.1", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertTrue((boolean)dependencyCoordinatesVersion.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        dependency.setVersion("[2.0, 3.0)");
        MavenCoordinates dependencyCoordinatesVersionRange = new MavenCoordinates(dependency);
        Assert.assertFalse((boolean)dependencyCoordinatesVersionRange.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "1.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertFalse((boolean)dependencyCoordinatesVersionRange.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "3.0", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
        Assert.assertTrue((boolean)dependencyCoordinatesVersionRange.matches(new MavenCoordinates((Artifact)new DefaultArtifact("test.group", "test-artifact", "2.2", "test", "jar", null, (ArtifactHandler)new DefaultArtifactHandler()))));
    }
}

