/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.artifact;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;

public class MavenCoordinates {
    private final String artifactId;
    private final String groupId;
    private final Optional<? extends ArtifactVersion> version;
    private final Optional<VersionRange> versionRange;
    private final String type;
    private final Optional<String> classifier;

    public MavenCoordinates(Dependency dependency) throws InvalidVersionSpecificationException {
        Preconditions.checkNotNull((Object)dependency, (Object)"dependency is null");
        this.artifactId = (String)Preconditions.checkNotNull((Object)dependency.getArtifactId(), (String)"artifactId for dependency '%s' is null", (Object)dependency);
        this.groupId = (String)Preconditions.checkNotNull((Object)dependency.getGroupId(), (String)"groupId for dependency '%s' is null", (Object)dependency);
        String version = dependency.getVersion();
        this.version = version == null ? Optional.absent() : Optional.of((Object)new DefaultArtifactVersion(version));
        this.versionRange = this.version.isPresent() ? Optional.of((Object)VersionRange.createFromVersionSpec((String)version)) : Optional.absent();
        String type = dependency.getType();
        String classifier = dependency.getClassifier();
        if ("test-jar".equals(type)) {
            this.classifier = Optional.of((Object)((String)MoreObjects.firstNonNull((Object)classifier, (Object)"tests")));
            this.type = "jar";
        } else {
            this.type = (String)MoreObjects.firstNonNull((Object)type, (Object)"jar");
            this.classifier = Optional.fromNullable((Object)classifier);
        }
    }

    public MavenCoordinates(Artifact artifact) throws OverConstrainedVersionException {
        String version;
        Preconditions.checkNotNull((Object)artifact, (Object)"artifact is null");
        this.artifactId = (String)Preconditions.checkNotNull((Object)artifact.getArtifactId(), (String)"artifactId for artifact '%s' is null", (Object)artifact);
        this.groupId = (String)Preconditions.checkNotNull((Object)artifact.getGroupId(), (String)"groupId for artifact '%s' is null", (Object)artifact);
        this.versionRange = Optional.fromNullable((Object)artifact.getVersionRange());
        this.version = this.versionRange.isPresent() ? Optional.fromNullable((Object)artifact.getSelectedVersion()) : ((version = artifact.getBaseVersion()) == null ? Optional.absent() : Optional.of((Object)new DefaultArtifactVersion(version)));
        String type = artifact.getType();
        String classifier = artifact.getClassifier();
        if ("test-jar".equals(type)) {
            this.classifier = Optional.of((Object)((String)MoreObjects.firstNonNull((Object)classifier, (Object)"tests")));
            this.type = "jar";
        } else {
            this.type = (String)MoreObjects.firstNonNull((Object)type, (Object)"jar");
            this.classifier = Optional.fromNullable((Object)classifier);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Optional<? extends ArtifactVersion> getVersion() {
        return this.version;
    }

    public Optional<VersionRange> getVersionRange() {
        return this.versionRange;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getClassifier() {
        return this.classifier;
    }

    public boolean matches(Artifact artifact) throws OverConstrainedVersionException {
        return this.matches(new MavenCoordinates(artifact));
    }

    public boolean matches(MavenCoordinates other) {
        if (!(Objects.equals(this.getGroupId(), other.getGroupId()) && Objects.equals(this.getArtifactId(), other.getArtifactId()) && Objects.equals(this.getType(), other.getType()))) {
            return false;
        }
        if (this.getClassifier().isPresent() && !Objects.equals(this.getClassifier().get(), other.getClassifier().orNull())) {
            return false;
        }
        if (!this.getVersionRange().isPresent() && !this.getVersion().isPresent()) {
            return true;
        }
        if (!other.getVersion().isPresent()) {
            return false;
        }
        if (this.getVersionRange().isPresent()) {
            ArtifactVersion recommendedVersion = ((VersionRange)this.getVersionRange().get()).getRecommendedVersion();
            if (recommendedVersion != null) {
                return Objects.equals(recommendedVersion, other.getVersion().orNull());
            }
            if (((VersionRange)this.getVersionRange().get()).containsVersion((ArtifactVersion)other.getVersion().get())) {
                return true;
            }
        }
        return Objects.equals(this.getVersion().orNull(), other.getVersion().orNull());
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.classifier, this.type);
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        MavenCoordinates that = (MavenCoordinates)other;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.type, that.type);
    }

    public String toString() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.getGroupId());
        builder.add((Object)this.getArtifactId());
        if (this.getVersion().isPresent()) {
            builder.add((Object)((ArtifactVersion)this.getVersion().get()).toString());
        } else {
            builder.add((Object)"<any>");
        }
        builder.add((Object)this.getType());
        builder.add((Object)((String)this.getClassifier().or((Object)"<any>")));
        return Joiner.on((char)':').join((Iterable)builder.build());
    }
}

