/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.classpath;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.basepom.mojo.duplicatefinder.PluginLog;
import org.basepom.mojo.duplicatefinder.artifact.MavenCoordinates;

public class MatchArtifactPredicate
implements Predicate<Artifact> {
    private static final PluginLog LOG = new PluginLog(MatchArtifactPredicate.class);
    private final List<MavenCoordinates> mavenCoordinates;

    MatchArtifactPredicate(Collection<MavenCoordinates> dependencies) throws InvalidVersionSpecificationException {
        this.mavenCoordinates = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(dependencies, (Object)"dependencies is null")));
    }

    public boolean apply(Artifact artifact) {
        if (artifact != null) {
            for (MavenCoordinates mavenCoordinate : this.mavenCoordinates) {
                try {
                    if (!mavenCoordinate.matches(artifact)) continue;
                    LOG.debug("Ignoring artifact '%s' (matches %s)", artifact, mavenCoordinate);
                    return true;
                }
                catch (OverConstrainedVersionException e) {
                    LOG.warn("Caught '%s' while comparing '%s' to '%s'", e.getMessage(), mavenCoordinate, artifact);
                }
            }
        }
        return false;
    }
}

